package com.ejianc.business.settle.service;

import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.settle.bean.SettleEntity;

import java.util.Date;

/**
 * 结算实体
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    /**
     * @Description queryUnusedContract 查询合同是否被完工使用
     * @param contractId
     */
    CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType);

    /**
     * 查询合同对应类型的结算记录
     *
     * @param contractId
     * @param settleType
     * @return
     */
    SettleRecordVO queryDetailRecord(Long contractId, Integer settleType);


    /**
     * 新增合同结算前校验
     *
     * @param contractId
     * @param settleType
     * @return
     */
    String beforeNewSettleCheck(Long contractId, Integer settleType);

    boolean pushSettleToPool(SettleVO settleVO);

}
