package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service("settle") 
public class SettleBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private ISettleService service;
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IContractService contractService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SettleEntity settleEntity = service.selectById(billId);
		if (settleEntity != null) {
			settleEntity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			settleEntity.setCommitDate(new Date());
			settleEntity.setCommitUserCode(userContext.getUserCode());
			settleEntity.setCommitUserName(userContext.getUserName());
		}
		//推送结算池
//		boolean poolRes = service.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
//		settleEntity.setPushPoolFlag(poolRes ? BillPushStatusEnum.推送成功.getStatus() : BillPushStatusEnum.未成功推送.getStatus());
		service.saveOrUpdate(settleEntity, false);
		if (settleEntity.getSettleType()==1){
			// 完工结算修改合同状态为已封账
			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
			List<ContractEntity> contractEntities = contractService.queryList(param, false);
			contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已封账.getCode());
			logger.info("======完工结算终审审核完回调,已封账======,{}", JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);
			return CommonResponse.success("完工结算终审回调成功！");
		}else {
			return CommonResponse.success("过程结算终审回调成功！");
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		logger.info("完工单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		// 签章流程校验
		SettleEntity settleEntity = service.selectById(billId);
		if (settleEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审/撤回！");
		}
		if (settleEntity.getSettleType()==1){
			logger.info("完工结算弃审/撤回前回调结算实体信息为：{}", JSONObject.toJSONString(settleEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			// 完工结算撤回修改合同状态为履约中
			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
			List<ContractEntity> contractEntities = contractService.queryList(param, false);
			contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			logger.info("======完工结算弃审前回调,修改合同状态为履约中======,{}", JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);
		}
		service.saveOrUpdate(settleEntity, false);
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}
}
