package com.ejianc.business.settle.service.impl;

import cn.hutool.log.Log;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

/**
 * 结算实体
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {

    @Autowired
    private IChangeService changeService;

    @Autowired
    private SettleMapper settleMapper;


    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private ISettleOtherService otherService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        //若当前合同有完工结算单子 或 当前合同有其他未生效的结算单子 则不能添加新的结算单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getContractId, contractId);
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前合同已进行完工结算，请选择其他合同。");
        }
        QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("contract_id", contractId);
        ContractEntity contractEntity = contractService.selectById(contractId);
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
            changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
            changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            int changeResultCount = changeService.count(changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error("当前合同正在进行变更，不可以进行完工结算！");
            }
        }

        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, contractId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = super.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，请选择其他合同。");
        }

        //设置最小可用结算日期
        Date resultDate = settleMapper.selectMaxSettleDate(contractId);
        if (null == resultDate) {
            resultDate = null != settleDate ? settleDate : new Date();
            settleVO.setMinSettleDate(null);
        } else {
            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大日期加1
            resultDate = DateUtils.addDays(resultDate, 1);
            settleVO.setMinSettleDate(resultDate);
            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
                resultDate = settleDate;
            }
        }
        settleVO.setSettleDate(resultDate);
        //查询当前合同结算金额 已提交的
        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        //设置 已结算数据
        if (list.size() > 0) {
            settleVO.setSettleScale(list.get(0).getTotalSettleScale()==null?BigDecimal.ZERO : list.get(0).getTotalSettleScale());
            settleVO.setLastTaxMny(list.get(0).getTotalTaxMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
            settleVO.setLastMny(list.get(0).getTotalMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }
        return CommonResponse.success("当前合同可用！", settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleRecordVO settleRecordVO = new SettleRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
//        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType()==1){
                vo.setSettleTypeStr("完工结算");
            }else if (vo.getSettleType()==0){
                vo.setSettleTypeStr("过程结算");
            }
            if (vo.getTotalSettleScale()!=null){
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring+'%');

            }
        });
        settleRecordVO.setSettleList(settleVOS);
        //取第一条数据计算累计结算金额 与比例
        SettleEntity lastSettleRecord = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        if (lastSettleRecord!=null){
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
            //检测是否可以创建新的结算单
        }else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank(beforeNewSettleCheck(contractId, settleType)));
        return settleRecordVO;
    }


    /**
     * 校验逻辑
     * <p>
     * 节点结算：
     * 2）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的节点结算单据）
     * 3）判断是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行节点结算
     * <p>
     * 过程结算：
     * 1）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的过程结算单据）
     * 2）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行过程结算
     * <p>
     * 完工结算：
     * 1）是否有出库单没有进行领料结算，如果有，不可以进行完工结算
     * 2）是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
     * 3）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行完工结算（一个合同只可以有一个未生效的过程结算单据）
     * 4）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行完工结算
     *
     * @param contractId
     * @param settleType
     * @return
     */
    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.and(q -> q.in("settle_type", SettleTypeEnum.节点.getCode(), SettleTypeEnum.过程.getCode())
                .in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
        ).or().and(q -> q.eq("settle_type", SettleTypeEnum.完工));

        List<SettleEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList)) {
            if (SettleTypeEnum.完工.getCode().equals(settleType)) {
                return "合同已经生成了完工结算，不可以进行 " + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            } else {
                return "有未生效的过" + SettleTypeEnum.getDescriptionByCode(SettleTypeEnum.节点.getCode()) + "算单据，不可以进行" + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            }
        }

        if (SettleTypeEnum.完工.getCode().equals(settleType)) {
            //TODO 1、是否有出库单没有进行领料结算，如果有，不可以进行完工结算
            //2、是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
            contractQuery.eq("contract_id", contractId);
            ContractEntity contractEntity = contractService.selectById(contractId);
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
                changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
                changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
                int changeResultCount = changeService.count(changeContractLambda);
                if (changeResultCount > 0) {
                    return "当前合同正在进行变更，不可以进行完工结算！";
                }
            }
        }

        return null;
    }

    //推送至结算池
    @Override
    public boolean pushSettleToPool(SettleVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            BeanConvertorUtil.convert(settleVO, poolVO);
            // 合同类型：0劳务合同，1专业合同
//            Integer contractType = settleVO.getContractType();
            // 结算类型：0-过程（月度），1-完工，2-节点
            Integer settleType = settleVO.getSettleType();
            if (settleType == 0) {
                // 过程（月度）
//                poolVO.setSourceType(SettleSourceTypeEnum.其他支出合同过程结算.getCode());
            }
            if (settleType == 1) {
                // 完工（最终）
//                poolVO.setSourceType(SettleSourceTypeEnum.其他支出合同完工结算.getCode());
            }
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}", settleVO.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", settleVO.getId(), e);
        }
        return false;
    }
    // 将settleVO转换成settlePoolVO
//    private void convertSettleVOToSettlePoolVO(SettleVO s, SettlePoolVO spv) {
//        if (null == s || null == spv) {
//            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
//            return;
//        }
//        logger.info("结算单对象 -> 结算池对象手动转换开始");
//        // 结算单来源--id
//        spv.setSourceId(s.getId());
//        // 合同类型：0劳务合同，1专业合同
//        Integer contractType = s.getContractType();
//        // 结算类型：0-过程（月度），1-完工，2-节点
//        Integer settleType = s.getSettleType();
//
//        BigDecimal lastTaxMny;
//        BigDecimal lastMny;
//        BigDecimal subtract;
//        // 结算类型：0-过程（月度）    区分是否含本期
//        if (0 == settleType) {
//            spv.setLastTaxMny(s.getLastTaxMny());// 不含本期累计过程结算金额
//            spv.setLastMny(s.getLastMny());// 不含本期累计过程结算金额(无税)
//            spv.setLastTax(getSubStractAbs(s.getLastTaxMny(), s.getLastTaxMny()));// 税额 = |含税金额 - 无税金额|
//            // 劳务合同结算
//                spv.setSourceType(SettleSourceTypeEnum.劳务分包月度结算.getCode());
//                spv.setSettleProperty(0);// 属性类型：支出
//                spv.setUltimateFlag(0);// 是否最终结算：否
//                spv.setContractType("contractOther");// 其他支出合同
//        }
//
//        // 结算类型：1-完工（最终）    对于最终结算来说不区分是否含本期
//        if (1 == settleType) {
//            spv.setLastTaxMny(s.getTotalProcessTaxMny());// 完工用累计过程结算金额
//            spv.setLastMny(s.getTotalProcessMny());// 完工用累计过程结算金额（无税）
//            spv.setLastTax(getSubStractAbs(s.getTotalProcessTaxMny(), s.getTotalProcessMny()));// 税额 = |含税金额 - 无税金额|
//            // 劳务合同结算
//            if (contractType == 0) {
//                spv.setSourceType(SettleSourceTypeEnum.劳务分包最终结算.getCode());
//                spv.setSettleProperty(0);// 属性类型：支出
//                spv.setUltimateFlag(1);// 是否最终结算：是
//                spv.setContractType("laborsub");// 劳务分包合同
//            }
//            // 专业合同结算
//            if (contractType == 1) {
//                spv.setSourceType(SettleSourceTypeEnum.专业分包最终结算.getCode());
//                spv.setSettleProperty(0);// 属性类型：支出
//                spv.setUltimateFlag(1);// 是否最终结算：是
//                spv.setContractType("prosub");// 专业分包合同
//            }
//        }
//        // 主合同ID/名称/编码  甲方ID/名称   签订日期需要到合同中去查询
//        ContractEntity ce = contractService.selectById(s.getContractId());
//        logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}", s.getContractId());
//        if (ce == null) {
//            logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}，未查询到合同信息，故结算单的 主合同/甲方/乙方/签订日期/创建时间和人员/更新时间和人员 等信息无法推送至结算池", s.getContractId());
//            return;
//        }
//        // 主合同
//        spv.setMaiContractId(ce.getMainContractId());
//        spv.setMaiContractName(ce.getMainContractName());
//        spv.setMaiContractCode(ce.getMainContractCode());
//        // 甲方
//        spv.setPartyaId(ce.getFirstPartyId());
//        spv.setPartyaName(ce.getFirstPartyName());
//        // 签订日期
//        spv.setSignDate(ce.getSignDate());
//        // 创建时间和人员 使用 结算单的创建时间和人员
//        spv.setCreateTime(ce.getCreateTime());
//        spv.setCreateUserCode(ce.getCreateUserCode());
//        // 更新时间和人员 使用 结算单的更新时间和人员
//        spv.setUpdateTime(ce.getUpdateTime());
//        spv.setUpdateUserCode(ce.getUpdateUserCode());
//        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
//    }

    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }
}
