package com.ejianc.business.settle.service;

import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 结算实体
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    /**
     * @Description queryUnusedContract 查询合同是否被完工使用
     * @param contractId
     */
    CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType);

    /**
     * 查询合同对应类型的结算记录
     *
     * @param contractId
     * @param settleType
     * @return
     */
    SettleRecordVO queryDetailRecord(Long contractId, Integer settleType);


    /**
     * 新增合同结算前校验
     *
     * @param contractId
     * @param settleType
     * @return
     */
    String beforeNewSettleCheck(Long contractId, Integer settleType);
    // 推送至结算池
    boolean pushSettleToPool(SettleVO settleVO);

    void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO);

    // 从结算池中删除数据
    boolean delSettleFromPool(Long id);

    ExecutionVO targetCost(SettleVO settleVO, String linkUrl);

    ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag);

    /**
     * 获取含本期累计结算金额
     *
     * @param contractId 合同id
     * @param taxMny     本期结算金额
     * @return 含本期累计结算金额
     */
    BigDecimal getLastTaxMny(Long contractId, BigDecimal taxMny, Boolean flag);


    /**
     * 获取超结金额
     *
     * @param totalTaxMny    含本期累计结算金额
     * @param contractTaxMny 合同金额
     * @return 超结金额
     */
    BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny);


    /**
     * 计算合同金额
     *
     * @param contractTaxMny 合同金额
     * @param roleValue      控制规则值
     * @return 合同金额
     */
    BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue);

}
