package com.ejianc.business.proother.service;

import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.vo.ChangeDetailVO;
import com.ejianc.business.proother.vo.ChangeVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 分包变更实体
 * 
 * @author generator
 * 
 */
public interface IChangeService extends IBaseService<ChangeEntity> {

    // 校验  其他支出合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    ParamsCheckVO changeMnyCtrl(ChangeVO changeVO, Boolean flag);

    ChangeVO queryDetailRecord(Long id);

    Boolean editChangeFlag(Long id);

    ChangeVO addConvertByConId(Long contractId, Long changeId);

    ChangeVO insertOrUpdate(ChangeVO saveorUpdateVO, Boolean isControl);

    String getLinkUrl(ChangeVO cv);

    ChangeVO queryDetail(Long id);

    CommonResponse<String> deleteById(Long changeBillId);

    Map<String, Object> queryChangeCompare(Long id);

    ChangeVO queryChangeRecord(Long contractId, Long changeId);

    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState);

    List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList);

    ExecutionVO targetCost(ChangeVO changeVO, String linkUrl, Integer contractType);
}
