package com.ejianc.business.proother.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proother.bean.*;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.mapper.ContractMapper;
import com.ejianc.business.proother.service.IContractDetailService;
import com.ejianc.business.proother.service.IContractOtherCostService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.proother.vo.ContractDetailVO;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private IContractOtherCostService otherCostService;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "OTH_CON";

    @Autowired
    private IContractService service;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private ITenderSubApi tenderApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    // 其他支出合同-补充协议  【合同金额】控【补充协议金额】
    private final String OTHER_OUT_SUPPLEMENT_PARAM_CODE = "P-8M2mcP96";

    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;


    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * 新增或者修改合同
     *
     * @param contractVO
     * @return
     */
    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority, Boolean isControl) {
        ContractEntity entity = BeanMapper.map(contractVO, ContractEntity.class);
        if(entity.getId() == null){
            // 初始化主键
            entity.setId(IdWorker.getId());
            //设置合同初始状态
            entity.setSignatureStatus(SignatureStatusEnum.待签章.getCode());
            //如果编码为空，就新增编码
            if (StringUtils.isBlank(entity.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), contractVO));
                if(!billCode.isSuccess()) {
                    logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }

                entity.setBillCode(billCode.getData());
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
            //回写定标结果占据状态
            if (Boolean.FALSE.equals(isControl)){
                tenderApi.updateById(entity.getTargetResultId(), occupyState);
            }
        }else {
            //若定标结果更换则回写原来定标结果为为占用状态，新定标结果为占用状态
            ContractEntity oldContractEntity = super.selectById(entity.getId());
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())){
                tenderApi.updateById(oldContractEntity.getTargetResultId(), unOccupyState);
                tenderApi.updateById(entity.getTargetResultId(), occupyState);
            }
            if (StringUtils.isBlank(entity.getBillCode())){
                entity.setBillCode(oldContractEntity.getBillCode());
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }

        }
        //补充金额明细
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        //分包明细
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        //其他费用
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        //设置初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());

        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = service.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())){
                    delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())){
                    delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }
        }
        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());

        //起草方式为使用合同模板时，将合同文件同步标识置为未同步
        if(DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }

        if (Boolean.FALSE.equals(isControl)){
            super.saveOrUpdate(entity, false);

            //目标成本推送
            String linkUrl = this.getLinkUrl(BeanMapper.map(entity, ContractVO.class));
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class),linkUrl,entity.getContractType());
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }

            return queryDetail(entity.getId());
        }

        return BeanMapper.map(entity, ContractVO.class);
    }

    public String getLinkUrl(ContractVO cv) {
        String linkUrl;
        // 是否是补充协议
        if (0 == cv.getSupplementFlag()){
            if (0 == cv.getAddType()){
                // 参照定标结果新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubCard";
            } else {
                // 直接新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubDirectCard";
            }
        } else {
            if (0 == cv.getAddType()){
                // 参照定标结果新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubCard";
            } else {
                // 直接新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubDirectCard";
            }
        }
        return linkUrl;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setBillType("BT220308000000001");
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (contractVO.getProjectId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(contractVO.getProjectId());
        }
        if (contractVO.getOrgId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(contractVO.getOrgId());
        }
        totalVO.setMoney(contractVO.getContractMny()); //总计划金额无税
        totalVO.setTaxMoney(contractVO.getContractTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }


    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null){
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        // 删除目标成本推送，为保持合同代码一致性，暂时还参照分包合同的写法
        if(CollectionUtils.isNotEmpty(vos)){
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (ContractVO contractVO : vos) {
                ContractEntity contractEntity = service.selectById(contractVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, ContractVO.class),"",contractEntity.getContractType());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据:{}", JSON.toJSONString(totalExecutionVOList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }
        vos.forEach(contractVO ->{
            ContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()){
                CommonResponse<String>  tender = tenderApi.updateById(contractEntity.getTargetResultId(), unOccupyState);
                logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
            }
        });
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.其他支出.getTypeCode());
            data.setSourceTypeName("其他支出合同");
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            String cardType = vo.getAddType()==1?"otherSubCard":"otherSubDirectCard";
            data.setPcCardUrl("/ejc-proother-frontend/#/otherSubList/contractMultiCards?id="+vo.getId()+"&supplementFlag="+vo.getSupplementFlag()+"&cardType="+cardType+"&performanceStatus="+vo.getPerformanceStatus());
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = service.selectById(id);
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = service.saveOrUpdate(contractEntity, false);
        if(!deleteContractFileResult) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    /**
     * 计算合同列表需要字段
     * @param param
     * @return
     */
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    /**
     * 查询合同详情
     * @param id
     * @return
     */
    @Override
    public ContractVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ContractEntity contractEntity = super.selectById(id, orderMap);
        ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);

        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree(contractVO.getDetailList()));
        }

        return contractVO;
    }


    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO contractVO = new ContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
//        contractVO.setContractType(contractEntity.getContractType());

        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("performance_status", PerformanceStatusEnum.履约中.getCode());
        query.orderByDesc("create_time");
        List<ContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(supplementEntities)){
            for (ContractEntity c : supplementEntities){
                if (c.getContractTaxMny() != null){
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus())))){
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }else {
            contractVO.setEditFlag(false);
        }
        return contractVO;
    }

    /**
     * 新增或者修改补充协议
     * @param contractVO
     * @return
     */
    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO, Boolean isControl) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank(contractVO.getBillCode()) && checkSameBillCode(contractVO)) {
            throw new BusinessException("编码重复，不允许保存!");
        }
        //主合同
        ContractEntity mainContract = service.selectById(contractVO.getMainContractId());
        if(null == mainContract) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }

        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", contractVO.getMainContractId()));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        List<ContractEntity> supplementList = service.queryList(param, false);

        if (StringUtils.isBlank(contractVO.getBillCode())){
            //设置补充协议编码
            String supplementNum = "";
            if (supplementList.size() < 9) {
                supplementNum += "0" + (supplementList.size() + 1);
            }else {
                supplementNum += (supplementList.size() + 1);
            }
            contractVO.setBillCode(mainContract.getBillCode() + "2" + supplementNum);
        }

        if(contractVO.getId() == null){
            //新增补充协议

            //校验：补充协议只能存在一条未生效的
            supplementList.stream().forEach(e -> {
                if(!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });
            entity = BeanMapper.map(mainContract, ContractEntity.class);
            //清空基础字段
            clearBaseFields(entity);
            // 初始化主键，在清空基础字段之后，避免主键被清空
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.待签章.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(contractVO.getBillCode());

            //基本信息
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());

            entity.setDraftType(contractVO.getDraftType());
            //设置文件路径
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());

            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());

            //补充金额明细
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            //分包明细
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            //其他费用
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            //子表
            entity.setDetailList(BeanMapper.mapList(contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList(contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList(contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList(contractVO.getPaymentList(), ContractPaymentEntity.class));

            //初始化变更字段
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            //补充协议状态
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = BeanMapper.map(contractVO, ContractEntity.class);
        }

        //设置初始金额
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        //设置关联的附件Ids
        entity.setAttachIds(contractVO.getAttachIds());

        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());

        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        if (Boolean.FALSE.equals(isControl)) {
            service.saveOrUpdate(entity, false);

            //目标成本推送
            String linkUrl = this.getLinkUrl(vo);
            ExecutionVO executionVO = service.targetCost(vo, linkUrl, vo.getContractType());
            logger.info("目标成本推送数据:{}", JSON.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }

            return queryDetail(entity.getId());
        }
        return vo;
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(ContractEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(ContractEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap=new HashMap<>();
            for(ContractDetailEntity cdEntity : detailList){
                if (cdEntity.getId() == null){
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(),cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for(ContractDetailEntity cdEntity : detailList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }
    }


    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }


    /**
     * 查询补充协议代入的主合同信息
     * @param contractId
     * @return
     */
    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());

        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
//        supplementVO.setContractType(contractVO.getContractType());

        return supplementVO;
    }


    /**
     * 判断当前合同是否能新增补充协议
     * @param id
     * @return
     */
    @Override
    public Boolean addSupplementFlag(Long id) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode()))//不是已签章的
                .or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));//单据状态不是1和3的
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    // 校验  其他支出合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public ParamsCheckVO supplementMnyCtrl(ContractVO contractVO, Boolean flag) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> dataSource = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(OTHER_OUT_SUPPLEMENT_PARAM_CODE);
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        BillParamVO billParamVO = billParamByCode.getData();
        // 控制规则值  百分比
        BigDecimal roleValue = billParamVO.getRoleValue();
        // 默认控制方式为提醒
        if (1 == billParamVO.getControlType()) {
            paramsCheckVO.setWarnType(paramsArray[1]);
        } else {
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        }
        // 为none时不需要控制
        if (!"none".equals(paramsCheckVO.getWarnType())) {
            // 查询当前补充协议所属主合同下的所有补充协议的含税合同金额的累加值--排除自己（如果当前数据已入库的话）
            QueryWrapper<ContractEntity> contractEntityQueryWrapper = new QueryWrapper<>();
            Long mainContractId = contractVO.getMainContractId();
            contractEntityQueryWrapper
                    .eq("dr", 0)
                    .eq("tenant_id", InvocationInfoProxy.getTenantid())
                    .eq("main_contract_id", mainContractId)
                    .eq("supplement_flag", 1);
            if (contractVO.getId() != null) {
                // 排除自己
                contractEntityQueryWrapper.notIn("id", Arrays.asList(contractVO.getId()));
            }
            contractEntityQueryWrapper.select("sum(contract_tax_mny) as contractTaxMnySupTotal");
            Map<String, Object> map = super.getMap(contractEntityQueryWrapper);
            BigDecimal contractTaxMnySupTotal = BigDecimal.ZERO;
            if (map != null) {
                // 查询到的不包含自己的所属主合同下的所有补充协议的含税合同金额的累加值
                contractTaxMnySupTotal = map.get("contractTaxMnySupTotal") != null ? new BigDecimal(map.get("contractTaxMnySupTotal").toString()) : BigDecimal.ZERO;
            }
            // 当前补充协议金额
            BigDecimal curDataContractTaxMny = contractVO.getContractTaxMny() != null ? contractVO.getContractTaxMny() : BigDecimal.ZERO;
            // 合同的补充协议金额（当前补充协议所属主合同下的所有补充协议的含税合同金额的累加值） = 查询到的含税合同金额累加值 + 当前数据的合同金额
            contractTaxMnySupTotal = contractTaxMnySupTotal.add(curDataContractTaxMny);
            // 查询当前补充协议所属主合同的含税合同金额
            contractEntityQueryWrapper = new QueryWrapper<ContractEntity>();
            contractEntityQueryWrapper.eq("id", mainContractId);
            ContractEntity contractEntity = super.getOne(contractEntityQueryWrapper);
            if (contractEntity == null) {
                logger.info("查询主合同失败！");
                throw new BusinessException("查询主合同失败！");
            }
            // 计算 主合同金额 * X%
            BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
            contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
            BigDecimal conTaxMny = contractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
            // 控制金额：补充协议金额 > 合同金额*X%
            if (contractTaxMnySupTotal.compareTo(conTaxMny) > 0) {
                BigDecimal overTaxMny = contractTaxMnySupTotal.subtract(conTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次补充协议金额：").append(curDataContractTaxMny.setScale(2, RoundingMode.DOWN))
                        .append("，含本次补充协议金额：").append(contractTaxMnySupTotal.setScale(2, RoundingMode.DOWN))
                        .append("，合同金额*").append(roleValue).append("%：").append(conTaxMny.setScale(2, RoundingMode.DOWN))
                        .append("。超出金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                dataSource.add(paramsCheckDsVO);
                paramsCheckVO.setDataSource(dataSource);
            } else {
                // 无需控制
                paramsCheckVO.setWarnType(paramsArray[0]);
            }
        }
        return paramsCheckVO;
    }


    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }






}
