package com.ejianc.business.settle.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 结算实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proother_settle")
public class SettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "settle_date")
    private Date settleDate; // 结算日期
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 非必填，0-300字
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 本期结算金额
    @TableField(value="mny")
    private BigDecimal mny; // 本期结算金额(无税)
    @TableField(value="tax")
    private BigDecimal tax; // 本期结算税额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="last_tax_mny")
    private BigDecimal lastTaxMny; // 已结算金额
    @TableField(value="last_mny")
    private BigDecimal lastMny; // 已结算金额(无税)
    @TableField(value="last_tax")
    private BigDecimal lastTax; // 已结算税额
    @TableField(value="total_tax_mny")
    private BigDecimal totalTaxMny; // 含本期结算金额
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 含本期结算金额(无税)
    @TableField(value="settle_scale")
    private BigDecimal settleScale; // 已结算比例

    @TableField(value="total_settle_scale")
    private BigDecimal TotalSettleScale; //含本期已结算比例

    @TableField(value = "supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value = "supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value = "settle_type")
    private Integer settleType; // 结算类型：0-过程，1-完工
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;

    /**
     * 推送结算池标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "push_pool_flag")
    private String pushPoolFlag;
    /**
     * 明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "settleDetailService", pidName = "settleId")
    private List<SettleDetailEntity> detailList = new ArrayList<>();



    /**
     * 其他费用实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "settleOtherService", pidName = "settleId")
    private List<SettleOtherEntity> otherList = new ArrayList<>();

    @TableField(value = "relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value = "proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getTotalSettleScale() {
        return TotalSettleScale;
    }

    public void setTotalSettleScale(BigDecimal totalSettleScale) {
        TotalSettleScale = totalSettleScale;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public List<SettleDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SettleDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<SettleOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<SettleOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getLastTaxMny() {
        return lastTaxMny;
    }

    public void setLastTaxMny(BigDecimal lastTaxMny) {
        this.lastTaxMny = lastTaxMny;
    }
    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }
    public BigDecimal getLastTax() {
        return lastTax;
    }

    public void setLastTax(BigDecimal lastTax) {
        this.lastTax = lastTax;
    }
    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getSettleScale() {
        return settleScale;
    }

    public void setSettleScale(BigDecimal settleScale) {
        this.settleScale = settleScale;
    }
    
}
