/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contract.relieve.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private ISettleService settleService;

    @Override
    public Boolean isCanRelieve(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        List list = this.service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType("BT220308000000001");
        totalVO.setBussinessType(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        LambdaQueryWrapper processQuery = new LambdaQueryWrapper();
        processQuery.eq(SettleEntity::getContractId, (Object)contractVO.getId());
        processQuery.in(SettleEntity::getBillState, new Object[]{1, 3});
        processQuery.eq(BaseEntity::getDr, (Object)0);
        processQuery.eq(SettleEntity::getSettleType, (Object)0);
        List processEntity = this.settleService.list((Wrapper)processQuery);
        BigDecimal sumMonthMny = BigDecimal.ZERO;
        BigDecimal sumMonthTaxMny = BigDecimal.ZERO;
        for (SettleEntity monthVo : processEntity) {
            sumMonthMny = ComputeUtil.safeAdd((BigDecimal)sumMonthMny, (BigDecimal)monthVo.getMny());
            sumMonthTaxMny = ComputeUtil.safeAdd((BigDecimal)sumMonthTaxMny, (BigDecimal)monthVo.getTaxMny());
        }
        LambdaQueryWrapper quarterQuery = new LambdaQueryWrapper();
        quarterQuery.eq(SettleEntity::getContractId, (Object)contractVO.getId());
        quarterQuery.in(SettleEntity::getBillState, new Object[]{1, 3});
        quarterQuery.eq(BaseEntity::getDr, (Object)0);
        quarterQuery.eq(SettleEntity::getSettleType, (Object)1);
        List quarterEntity = this.settleService.list((Wrapper)quarterQuery);
        BigDecimal sumQuarterMny = BigDecimal.ZERO;
        BigDecimal sumQuarterTaxMny = BigDecimal.ZERO;
        for (SettleEntity quarterVo : quarterEntity) {
            sumQuarterMny = ComputeUtil.safeAdd((BigDecimal)sumQuarterMny, (BigDecimal)quarterVo.getMny());
            sumQuarterTaxMny = ComputeUtil.safeAdd((BigDecimal)sumQuarterTaxMny, (BigDecimal)quarterVo.getTaxMny());
        }
        if (sumQuarterMny.compareTo(sumMonthMny) == 1) {
            totalVO.setMoney(sumQuarterMny.subtract(contractVO.getContractMny()));
        } else {
            totalVO.setMoney(sumMonthMny.subtract(contractVO.getContractMny()));
        }
        if (sumQuarterTaxMny.compareTo(sumMonthTaxMny) == 1) {
            totalVO.setTaxMoney(sumQuarterTaxMny.subtract(contractVO.getContractTaxMny()));
        } else {
            totalVO.setTaxMoney(sumMonthTaxMny.subtract(contractVO.getContractTaxMny()));
        }
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

