/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractClauseEntity;
import com.ejianc.business.proother.contract.bean.ContractDetailEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.bean.ContractOtherCostEntity;
import com.ejianc.business.proother.contract.bean.ContractPaymentEntity;
import com.ejianc.business.proother.contract.mapper.ContractMapper;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ChangeVO;
import com.ejianc.business.proother.contract.vo.ContractDetailVO;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.relieve.vo.ContractRelieveVO;
import com.ejianc.business.proother.settle.vo.SettleDetailVO;
import com.ejianc.business.proother.settle.vo.SettleOtherVO;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderOtherApi;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private static final String BILL_CODE = "OTH_CON";
    private static final String PROOTHER_CONTRACT_YNJT_OTH = "AC_MDGP_YNJT01";
    private static final String PROOTHER_CONTRACT_YNJT_WRITTEN = "OTH_WRITTEN";
    private static final String WRITTEN_CATEGORY_NAME = "\u975e\u4e66\u9762\u5408\u540c\u4ee3\u7528\u5355";
    private static final String GenerateSourceTypeOTH = "ACQT10086";
    private static final String GenerateSourceTypeWritten = "OTH_WRITTEN_01";
    @Autowired
    private IContractService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ITenderSubApi tenderApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractRelieveService relieveService;
    private final String OTHER_OUT_SUPPLEMENT_PARAM_CODE = "P-8M2mcP96";
    int unOccupyState = 0;
    int occupyState = 1;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private ITenderOtherApi tenderOtherApi;

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority, Boolean isControl) {
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                if (Boolean.FALSE.equals(isControl)) {
                    switch (this.GenerateBillCodeType) {
                        case "common": {
                            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                            if (!billCode.isSuccess()) {
                                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            entity.setBillCode((String)billCode.getData());
                            break;
                        }
                        case "ynjt": {
                            CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(BillCodeParam.build((String)(WRITTEN_CATEGORY_NAME.equals(entity.getContractCategoryName()) ? PROOTHER_CONTRACT_YNJT_WRITTEN : PROOTHER_CONTRACT_YNJT_OTH), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                            if (!billCodeFirstPart.isSuccess()) {
                                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            CommonSNVO commonSNVO = new CommonSNVO();
                            commonSNVO.setSnLength(Integer.valueOf(4));
                            commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                            commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                            commonSNVO.setSourceType(WRITTEN_CATEGORY_NAME.equals(entity.getContractCategoryName()) ? GenerateSourceTypeWritten : GenerateSourceTypeOTH);
                            CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                            if (!snResp.isSuccess()) {
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            entity.setBillCode((String)billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + (String)snResp.getData());
                        }
                    }
                } else {
                    entity.setBillCode(entity.getId().toString());
                }
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        } else {
            ContractEntity oldContractEntity = (ContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(oldContractEntity.getBillCode());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u4fdd\u5b58\uff1aisControl-{}, targetResultId-{}", (Object)isControl, (Object)entity.getTargetResultId());
        if (Boolean.FALSE.equals(isControl) && null != entity.getTargetResultId()) {
            this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u5b9a\u6807\u91d1\u989d\u6821\u9a8c---start----");
            QueryWrapper query = new QueryWrapper();
            query.select(new String[]{"sum(base_tax_mny) as lastContractTaxMny"});
            query.eq((Object)"target_result_id", (Object)entity.getTargetResultId());
            if (null != entity.getId()) {
                query.ne((Object)"id", (Object)entity.getId());
            }
            Map totalTaxMny = this.service.getMap((Wrapper)query);
            this.logger.info("\u603b\u6570\u636e\u5e93\u83b7\u53d6\u7d2f\u8ba1\u7b7e\u8ba2\u91d1\u989d\uff1b{}", (Object)JSONObject.toJSONString((Object)totalTaxMny));
            BigDecimal lastContractTaxMny = BigDecimal.ZERO;
            if (null != totalTaxMny && null != totalTaxMny.get("lastContractTaxMny")) {
                lastContractTaxMny = new BigDecimal(totalTaxMny.get("lastContractTaxMny").toString());
            }
            this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c-\u3010{}\u3011\uff0c\u5b9a\u6807\u91d1\u989d-\u3010{}\u3011\uff0c\u73b0\u6709\u7b7e\u8ba2\u5408\u540c\u91d1\u989d-\u3010{}\u3011", new Object[]{JSONObject.toJSONString((Object)((Object)((Object)entity)).toString()), entity.getTargetResultTaxMny(), lastContractTaxMny});
            if (lastContractTaxMny.add(entity.getContractTaxMny()).compareTo(entity.getTargetResultTaxMny()) > 0) {
                this.logger.error("\u5176\u4ed6\u652f\u51fa\u5408\u540c-\u3010{}\u3011\uff0c\u8d85\u8fc7\u5b9a\u6807\u91d1\u989d-\u3010{}\u3011\uff0c\u73b0\u6709\u7b7e\u8ba2\u5408\u540c\u91d1\u989d-\u3010{}\u3011", new Object[]{JSONObject.toJSONString((Object)((Object)((Object)entity)).toString()), entity.getTargetResultTaxMny(), lastContractTaxMny});
                throw new BusinessException("\u5408\u540c\u91d1\u989d[" + entity.getContractTaxMny() + "] + \u7d2f\u8ba1\u5df2\u7b7e\u5408\u540c\u91d1\u989d[" + lastContractTaxMny + "]\u8d85\u8fc7\u5b9a\u6807\u91d1\u989d[" + entity.getTargetResultTaxMny() + "]\uff0c\u4e0d\u53ef\u4fdd\u5b58");
            }
            ContractEntity oldEntityFromDb = (ContractEntity)((Object)this.service.selectById(entity.getId()));
            if (null != oldEntityFromDb) {
                TenderPicketageVO delTenderPicketageVO = new TenderPicketageVO();
                delTenderPicketageVO.setId(oldEntityFromDb.getTargetResultId());
                delTenderPicketageVO.setContractMoneyTax(oldEntityFromDb.getContractTaxMny());
                delTenderPicketageVO.setContractMoney(oldEntityFromDb.getContractMny());
                CommonResponse delTenderResp = this.tenderOtherApi.delUpdateStatus(delTenderPicketageVO);
                this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011\uff0c\u7ed3\u679c-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)delTenderPicketageVO), (Object)JSONObject.toJSONString((Object)delTenderResp));
                if (!delTenderResp.isSuccess()) {
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
                }
            }
            TenderPicketageVO saveTenderPicketageVO = new TenderPicketageVO();
            saveTenderPicketageVO.setId(entity.getTargetResultId());
            saveTenderPicketageVO.setContractMoney(entity.getContractMny());
            saveTenderPicketageVO.setContractMoneyTax(entity.getContractTaxMny());
            CommonResponse saveTenderResp = this.tenderOtherApi.updateStatus(saveTenderPicketageVO);
            this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u66f4\u65b0\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011\uff0c\u7ed3\u679c-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)saveTenderPicketageVO), (Object)JSONObject.toJSONString((Object)saveTenderResp));
            if (!saveTenderResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5b9a\u6807\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        } else {
            entity.setFilingRef(null);
        }
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = (ContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                this.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        this.resetPid(entity.getDetailList());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (Boolean.FALSE.equals(isControl)) {
            super.saveOrUpdate((Object)entity, false);
            String linkUrl = this.getLinkUrl((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class));
            ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class), linkUrl, entity.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            return this.queryDetail(entity.getId());
        }
        return (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
    }

    @Override
    public String getLinkUrl(ContractVO cv) {
        String linkUrl = 0 == cv.getSupplementFlag() ? (0 == cv.getAddType() ? this.BaseHost + "ejc-proother-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubCard" : this.BaseHost + "ejc-proother-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubDirectCard") : (0 == cv.getAddType() ? this.BaseHost + "ejc-proother-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubCard" : this.BaseHost + "ejc-proother-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubDirectCard");
        return linkUrl;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType(ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (contractVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(contractVO.getProjectId());
        if (contractVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (ContractVO contractVO2 : vos) {
                ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractVO2.getId()));
                ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), "", contractEntity.getContractType());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString(totalExecutionVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        vos.forEach(contractVO -> {
            ContractEntity contractEntity = (ContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                TenderPicketageVO delTenderPicketageVO = new TenderPicketageVO();
                delTenderPicketageVO.setId(contractEntity.getTargetResultId());
                delTenderPicketageVO.setContractMoneyTax(contractEntity.getContractTaxMny());
                delTenderPicketageVO.setContractMoney(contractEntity.getContractMny());
                this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)delTenderPicketageVO));
                CommonResponse delTenderResp = this.tenderOtherApi.delUpdateStatus(delTenderPicketageVO);
                this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011\uff0c\u7ed3\u679c-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)delTenderPicketageVO), (Object)JSONObject.toJSONString((Object)delTenderResp));
                if (!delTenderResp.isSuccess()) {
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
                }
            }
        });
        this.service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
            data.setSourceTypeName("\u5176\u4ed6\u652f\u51fa\u5408\u540c");
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            String cardType = vo.getAddType() == 1 ? "otherSubCard" : "otherSubDirectCard";
            data.setPcCardUrl("/ejc-proother-frontend/#/otherSubList/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus());
            data.setAddType(Integer.valueOf(1));
            data.setSourceTypeName(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeName());
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public String delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return null;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return StringUtils.isNotBlank((CharSequence)delDataResp.getMsg()) ? delDataResp.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u5220\u9664\u5931\u8d25\uff01";
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = this.service.saveOrUpdate((Object)contractEntity, false);
        if (!deleteContractFileResult.booleanValue()) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        if (CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree((List)contractVO.getDetailList()));
        }
        return contractVO;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (ContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        } else {
            contractVO.setEditFlag(Boolean.valueOf(false));
        }
        return contractVO;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO, Boolean isControl) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)contractVO.getBillCode()) && this.checkSameBillCode(contractVO).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVO.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVO.getMainContractId()));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        List supplementList = this.service.queryList(param, false);
        if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            contractVO.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (contractVO.getId() == null) {
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), ContractEntity.class));
            this.clearBaseFields(entity);
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setFilingStatus(contractVO.getFilingStatus());
            if (entity.getFilingStatus() == FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()) {
                entity.setFilingRef(0);
            } else {
                entity.setFilingRef(null);
            }
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());
            entity.setDraftType(contractVO.getDraftType());
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());
            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            entity.setDetailList(BeanMapper.mapList((Iterable)contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList((Iterable)contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList((Iterable)contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList((Iterable)contractVO.getPaymentList(), ContractPaymentEntity.class));
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        }
        if (entity.getFilingStatus() == FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()) {
            entity.setFilingRef(0);
        } else {
            entity.setFilingRef(null);
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setAttachIds(contractVO.getAttachIds());
        this.resetPid(entity.getDetailList());
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        if (Boolean.FALSE.equals(isControl)) {
            this.service.saveOrUpdate((Object)entity, false);
            String linkUrl = this.getLinkUrl(vo);
            ExecutionVO executionVO = this.service.targetCost(vo, linkUrl, vo.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e:{}", (Object)JSON.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            return this.queryDetail(entity.getId());
        }
        return vo;
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
    }

    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ParamsCheckVO supplementMnyCtrl(ContractVO contractVO, Boolean flag) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode("P-8M2mcP96");
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
        BigDecimal roleValue = billParamVO.getRoleValue();
        if (1 == billParamVO.getControlType()) {
            paramsCheckVO.setWarnType(paramsArray[1]);
        } else {
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        }
        if (!"none".equals(paramsCheckVO.getWarnType())) {
            QueryWrapper contractEntityQueryWrapper = new QueryWrapper();
            Long mainContractId = contractVO.getMainContractId();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)contractEntityQueryWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"main_contract_id", (Object)mainContractId)).eq((Object)"supplement_flag", (Object)1);
            if (contractVO.getId() != null) {
                contractEntityQueryWrapper.notIn((Object)"id", Arrays.asList(contractVO.getId()));
            }
            contractEntityQueryWrapper.select(new String[]{"sum(contract_tax_mny) as contractTaxMnySupTotal"});
            Map map = super.getMap((Wrapper)contractEntityQueryWrapper);
            BigDecimal contractTaxMnySupTotal = BigDecimal.ZERO;
            if (map != null) {
                contractTaxMnySupTotal = map.get("contractTaxMnySupTotal") != null ? new BigDecimal(map.get("contractTaxMnySupTotal").toString()) : BigDecimal.ZERO;
            }
            BigDecimal curDataContractTaxMny = contractVO.getContractTaxMny() != null ? contractVO.getContractTaxMny() : BigDecimal.ZERO;
            contractTaxMnySupTotal = contractTaxMnySupTotal.add(curDataContractTaxMny);
            contractEntityQueryWrapper = new QueryWrapper();
            contractEntityQueryWrapper.eq((Object)"id", (Object)mainContractId);
            ContractEntity contractEntity = (ContractEntity)((Object)super.getOne((Wrapper)contractEntityQueryWrapper));
            if (contractEntity == null) {
                this.logger.info("\u67e5\u8be2\u4e3b\u5408\u540c\u5931\u8d25\uff01");
                throw new BusinessException("\u67e5\u8be2\u4e3b\u5408\u540c\u5931\u8d25\uff01");
            }
            BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
            contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
            BigDecimal conTaxMny = contractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
            if (contractTaxMnySupTotal.compareTo(conTaxMny) > 0) {
                BigDecimal overTaxMny = contractTaxMnySupTotal.subtract(conTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(curDataContractTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySupTotal.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(conTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                dataSource.add(paramsCheckDsVO);
                paramsCheckVO.setDataSource(dataSource);
            } else {
                paramsCheckVO.setWarnType(paramsArray[0]);
            }
        }
        return paramsCheckVO;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public CommonResponse<ContractPaymentResultVO> queryPaymentApplyList(Long id) {
        CommonResponse jsonObjectCommonResponse = this.paymentApplyApi.queryJsonByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (!jsonObjectCommonResponse.isSuccess()) {
            this.logger.error(jsonObjectCommonResponse.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u9519\u8bef");
        }
        return jsonObjectCommonResponse;
    }

    @Override
    public JSONObject excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartFile mf = null;
        JSONObject handleResult = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            handleResult.put("success", (Object)false);
            handleResult.put("errMsg", (Object)"Excel\u4e3a\u7a7a");
            return handleResult;
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<SettleDetailVO> successList = new ArrayList<SettleDetailVO>();
            ArrayList<SettleDetailVO> errorList = new ArrayList<SettleDetailVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SettleDetailVO vo = new SettleDetailVO();
                String warnType = "";
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setDetailName(null);
                    warnType = warnType + "[\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a]";
                } else {
                    vo.setDetailName((String)datas.get(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setDetailUnit((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setDetailNum(null);
                    warnType = warnType + "[\u5de5\u7a0b\u91cf\u4e3a\u7a7a]";
                } else {
                    vo.setDetailNum(new BigDecimal((String)datas.get(2)));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setDetailTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\u4e3a\u7a7a]";
                } else {
                    vo.setDetailTaxRate(new BigDecimal((String)datas.get(3)));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setDetailTaxPrice(null);
                    warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a]";
                } else {
                    vo.setDetailTaxPrice(new BigDecimal((String)datas.get(4)));
                }
                vo.setRowState("add");
                if (StringUtils.isEmpty((CharSequence)warnType)) {
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
            handleResult.put("successList", successList);
            handleResult.put("errorList", errorList);
            handleResult.put("successNum", (Object)successList.size());
            handleResult.put("errorNum", (Object)errorList.size());
            handleResult.put("success", (Object)true);
            return handleResult;
        }
        handleResult.put("success", (Object)false);
        handleResult.put("errMsg", (Object)"Excel\u4e3a\u7a7a");
        return handleResult;
    }

    @Override
    public JSONObject excelImportOtherInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartFile mf = null;
        JSONObject handleResult = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            handleResult.put("success", (Object)false);
            handleResult.put("errMsg", (Object)"Excel\u4e3a\u7a7a");
            return handleResult;
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<SettleOtherVO> successList = new ArrayList<SettleOtherVO>();
            ArrayList<SettleOtherVO> errorList = new ArrayList<SettleOtherVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SettleOtherVO vo = new SettleOtherVO();
                String warnType = "";
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setCostName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                } else {
                    vo.setCostName((String)datas.get(0));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCostTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\u4e3a\u7a7a]";
                } else {
                    vo.setCostTaxRate(new BigDecimal((String)datas.get(1)));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setTaxMny(null);
                    warnType = warnType + "[\u91d1\u989d\u4e3a\u7a7a]";
                } else {
                    vo.setTaxMny(new BigDecimal((String)datas.get(2)));
                }
                vo.setRowState("add");
                if (StringUtils.isEmpty((CharSequence)warnType)) {
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
            handleResult.put("successList", successList);
            handleResult.put("errorList", errorList);
            handleResult.put("successNum", (Object)successList.size());
            handleResult.put("errorNum", (Object)errorList.size());
            handleResult.put("success", (Object)true);
            return handleResult;
        }
        handleResult.put("success", (Object)false);
        handleResult.put("errMsg", (Object)"Excel\u4e3a\u7a7a");
        return handleResult;
    }

    @Override
    public boolean changeContractPerformanceState(String performanceStatus, Long contractId) {
        try {
            ContractEntity contract = (ContractEntity)((Object)super.selectById((Serializable)contractId));
            contract.setPerformanceStatus(performanceStatus);
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setId(contractId);
            contractPoolVO.setSourceId(contractId);
            contractPoolVO.setPerformanceStatus(performanceStatus);
            contractPoolVO.setPerformanceStatusName(ContractPerformanceStateEnum.getByStateCode((String)performanceStatus).getStateName());
            this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001, \u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse resp = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("\u5176\u4ed6\u652f\u51fa\u5408\u540c-{}\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001, \u7ed3\u679c\uff1a{}", (Object)contractId.toString(), (Object)JSONObject.toJSONString((Object)resp));
            contract.setBillPushFlag(resp.isSuccess() ? BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus() : BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            super.saveOrUpdate((Object)contract, false);
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u5176\u4ed6\u652f\u51fa\u5408\u540c-{}\u66f4\u65b0\u5408\u540c\u6c60\u5c65\u7ea6\u72b6\u6001-{}\u5f02\u5e38: ", new Object[]{contractId, performanceStatus, e});
            return false;
        }
    }

    @Override
    public CommonResponse<String> pushTargetCost(ContractVO contractVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractVO.getId()));
        ContractVO entity = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        if (contractEntity.getChangeStatus() == 1) {
            String linkUrl = this.getLinkUrl((ContractVO)BeanMapper.map((Object)entity, ContractVO.class));
            ExecutionVO executionVO = this.targetCost(entity, linkUrl, entity.getContractType());
            this.logger.info("\u624b\u52a8\uff1a\u5408\u540c\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e---:{}", (Object)JSONObject.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            this.logger.info("\u624b\u52a8\uff1a\u5408\u540c\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a8\u9001\u7ed3\u679c---:{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                return response;
            }
        } else {
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(entity.getChangeId()));
            ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class);
            String linkUrl = this.changeService.getLinkUrl(changeVO);
            ExecutionVO executionVO = this.changeService.targetCost(changeVO, linkUrl, changeVO.getContractType(), false);
            this.logger.info("\u624b\u52a8\uff1a\u5408\u540c\u53d8\u66f4\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e---:{}", (Object)JSONObject.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            this.logger.info("\u624b\u52a8\uff1a\u5408\u540c\u53d8\u66f4\u76ee\u6807\u6210\u672c\u63a8\u9001\u7ed3\u679c---:{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                return response;
            }
        }
        if (PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(entity.getPerformanceStatus())) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ContractRelieveEntity::getContractId, (Object)entity.getId());
            wrapper.in(ContractRelieveEntity::getBillState, list);
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List relieveList = this.relieveService.list((Wrapper)wrapper);
            ContractRelieveVO relieveVO = (ContractRelieveVO)BeanMapper.map(relieveList.get(0), ContractRelieveVO.class);
            String linkUrl = this.BaseHost + "ejc-proother-frontend/#/contractRelieve/Card?id=" + relieveVO.getId();
            ExecutionVO executionVO = this.relieveService.targetCost(relieveVO, linkUrl);
            this.logger.info("\u624b\u52a8\uff1a\u5408\u540c\u89e3\u9664\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e{}", (Object)JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            this.logger.info("\u624b\u52a8\uff1a\u5408\u540c\u89e3\u9664\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a8\u9001\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                return response;
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u76ee\u6807\u6210\u672c\u6210\u529f");
    }
}

