/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.service.ISignatureService;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="signatureService")
public class SignatureServiceImpl
implements ISignatureService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${contract.mainContract}")
    private String mainContarct;
    @Value(value="${contract.changeContract}")
    private String changeContract;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        this.logger.info("\u8fdb\u5165\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6d41\u7a0b------------->");
        if (this.mainContarct.equals(refCode)) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
            if (contractEntity == null) return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
            if (signatureStatus == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
                contractEntity.setFilingRef(0);
                contractEntity.setEffectiveDate(new Date());
            } else {
                contractEntity.setSignatureStatus(String.valueOf(signatureStatus));
            }
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            return CommonResponse.success((String)"\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
        } else {
            if (!this.changeContract.equals(refCode)) return CommonResponse.error((String)"\u8bf7\u68c0\u67e5refCode\u503c\u662f\u5426\u6b63\u786e\uff01");
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(id));
            if (changeEntity == null) return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
            if (signatureStatus == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                return this.changeService.effectiveSaveWriteContract(id, changeEntity.getBillCode(), false, true);
            }
            changeEntity.setSignatureStatus(String.valueOf(signatureStatus));
            this.changeService.saveOrUpdate((Object)changeEntity);
            this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
            this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
        }
        return CommonResponse.success((String)"\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }
}

