/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.proother.settle.bean.SettleDetailEntity;
import com.ejianc.business.proother.settle.bean.SettleEntity;
import com.ejianc.business.proother.settle.bean.SettleOtherEntity;
import com.ejianc.business.proother.settle.enums.SettleTypeEnum;
import com.ejianc.business.proother.settle.mapper.SettleMapper;
import com.ejianc.business.proother.settle.service.ISettleService;
import com.ejianc.business.proother.settle.vo.SettleRecordVO;
import com.ejianc.business.proother.settle.vo.SettleVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractService contractService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ISettleService settleService;
    private static final String PRO_OTHER_CHECK_PARAM_NAME = "P-C4JSb946";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "OTH_SET";

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)contractId);
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
        }
        QueryWrapper contractQuery = new QueryWrapper();
        contractQuery.eq((Object)"contract_id", (Object)contractId);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
            changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
            changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
            int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01");
            }
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)contractId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = super.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode((Integer)((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002"));
        }
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"settle_type", (Object)settleType);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        if (list.size() > 0) {
            settleVO.setSettleScale(((SettleEntity)((Object)list.get(0))).getTotalSettleScale() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalSettleScale());
            settleVO.setLastTaxMny(((SettleEntity)((Object)list.get(0))).getTotalTaxMny() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalTaxMny());
            settleVO.setLastMny(((SettleEntity)((Object)list.get(0))).getTotalMny() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalTaxMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List settleEntityList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)settleEntityList)) {
            settleVO.setSettleTimes(Integer.valueOf(settleEntityList.size()));
        } else {
            settleVO.setSettleTimes(Integer.valueOf(0));
        }
        return CommonResponse.success((String)"\u5f53\u524d\u5408\u540c\u53ef\u7528\uff01", (Object)settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleEntity lastSettleRecord;
        SettleRecordVO settleRecordVO = new SettleRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        List settleVOS = BeanMapper.mapList((Iterable)list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("\u5b8c\u5de5\u7ed3\u7b97");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("\u8fc7\u7a0b\u7ed3\u7b97");
            }
            if (vo.getTotalSettleScale() != null) {
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring + '%');
            }
        });
        settleRecordVO.setSettleList(settleVOS);
        SettleEntity settleEntity = lastSettleRecord = CollectionUtils.isNotEmpty((Collection)list) ? (SettleEntity)((Object)list.get(0)) : null;
        if (lastSettleRecord != null) {
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
        } else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank((CharSequence)this.beforeNewSettleCheck(contractId, settleType)));
        return settleRecordVO;
    }

    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        ((QueryWrapper)((QueryWrapper)query.and(q -> (QueryWrapper)((QueryWrapper)q.in((Object)"settle_type", new Object[]{SettleTypeEnum.\u8282\u70b9.getCode(), SettleTypeEnum.\u8fc7\u7a0b.getCode()})).in((Object)"bill_state", new Object[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}))).or()).and(q -> (QueryWrapper)q.eq((Object)"settle_type", (Object)SettleTypeEnum.\u5b8c\u5de5));
        List billList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billList)) {
            if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
                return "\u5408\u540c\u5df2\u7ecf\u751f\u6210\u4e86\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c " + SettleTypeEnum.getDescriptionByCode((Integer)settleType) + "\u7ed3\u7b97";
            }
            return "\u6709\u672a\u751f\u6548\u7684\u8fc7" + SettleTypeEnum.getDescriptionByCode((Integer)SettleTypeEnum.\u8282\u70b9.getCode()) + "\u7b97\u5355\u636e\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c" + SettleTypeEnum.getDescriptionByCode((Integer)settleType) + "\u7ed3\u7b97";
        }
        if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("bill_state", new Parameter("eq", (Object)BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper contractQuery = new QueryWrapper();
            contractQuery.eq((Object)"contract_id", (Object)contractId);
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
                changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
                changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
                int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
                if (changeResultCount > 0) {
                    return "\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01";
                }
            }
        }
        return null;
    }

    @Override
    public boolean pushSettleToPool(SettleVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)settleVO, (Object)poolVO);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(settleVO, poolVO);
            poolVO.setBillCodeUrl("/ejc-proother-frontend/#/settleList/card?id=" + settleVO.getId());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)settleVO.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)settleVO.getId(), (Object)JSONObject.toJSONString((Object)res));
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)settleVO.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode());
        poolVO.setSourceTypeName(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getName() : SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getName());
        poolVO.setSettleProperty(Integer.valueOf(0));
        poolVO.setUltimateFlag(Integer.valueOf(settleVO.getSettleType() == 1 ? 1 : 0));
        poolVO.setLastTaxMny(settleVO.getLastTaxMny());
        poolVO.setLastMny(settleVO.getLastMny());
        poolVO.setLastTax(this.getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));
        poolVO.setContractType(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
        poolVO.setContractTypeName(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeName());
        ContractEntity ce = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}", (Object)settleVO.getContractId());
        if (ce == null) {
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff0c\u6545\u7ed3\u7b97\u5355\u7684 \u4e3b\u5408\u540c/\u7532\u65b9/\u4e59\u65b9/\u7b7e\u8ba2\u65e5\u671f/\u521b\u5efa\u65f6\u95f4\u548c\u4eba\u5458/\u66f4\u65b0\u65f6\u95f4\u548c\u4eba\u5458 \u7b49\u4fe1\u606f\u65e0\u6cd5\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)settleVO.getContractId());
            return;
        }
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        poolVO.setPartyaId(ce.getFirstPartyId());
        poolVO.setPartyaName(ce.getFirstPartyName());
        poolVO.setSignDate(ce.getSignDate());
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        poolVO.setHandleType(Integer.valueOf(0));
        poolVO.setContractFlag(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCode());
        poolVO.setContractTypeName(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCodeName());
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    @Override
    public String delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return null;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return StringUtils.isNotBlank((CharSequence)res.getMsg()) ? res.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u5220\u9664\u5931\u8d25\uff01";
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setProjectId(settleVO.getProjectId());
        totalVO.setBillType("BT220317000000001");
        totalVO.setBussinessType(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(SettleEntity::getBillState, list);
        wrapper.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        List settleList = this.settleService.list((Wrapper)wrapper);
        BigDecimal totalMny = settleList.stream().map(SettleEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTaxMny = settleList.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)contract.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalTaxMny, (BigDecimal)contract.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(PRO_OTHER_CHECK_PARAM_NAME);
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
        BigDecimal roleValue = billParamVO.getRoleValue();
        if (1 == billParamVO.getControlType()) {
            paramsCheckVO.setWarnType(paramsArray[1]);
        } else {
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        }
        if (!"none".equals(paramsCheckVO.getWarnType())) {
            BigDecimal contractTaxMny;
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
            if (null == contract) {
                this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BigDecimal taxMny = settleVO.getTaxMny();
            BigDecimal totalTaxMny = this.getLastTaxMny(settleVO.getContractId(), taxMny, flag);
            if (totalTaxMny.compareTo(contractTaxMny = this.getContractTaxMny(contract.getContractTaxMny(), roleValue)) > 0) {
                BigDecimal overTaxMny = this.getOverTaxMny(totalTaxMny, contractTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(taxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheckVO.setDataSource(checkDsVOS);
            } else {
                paramsCheckVO.setWarnType(paramsArray[0]);
            }
        }
        return paramsCheckVO;
    }

    @Override
    public BigDecimal getLastTaxMny(Long contractId, BigDecimal taxMny, Boolean flag) {
        Assert.notNull((Object)contractId, (String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)taxMny, (String)"\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"contract_id", (Object)contractId);
        qw.in((Object)"bill_state", billState);
        List settles = super.list((Wrapper)qw);
        if (CollectionUtils.isEmpty((Collection)settles)) {
            return taxMny;
        }
        if (Boolean.TRUE.equals(flag)) {
            taxMny = BigDecimal.ZERO;
        }
        return settles.stream().map(SettleEntity::getTaxMny).reduce(taxMny, BigDecimal::add);
    }

    @Override
    public BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny) {
        Assert.notNull((Object)totalTaxMny, (String)"\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractTaxMny, (String)"\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        return totalTaxMny.subtract(contractTaxMny);
    }

    @Override
    public BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue) {
        Assert.notNull((Object)contractTaxMny, (String)"\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)roleValue, (String)"\u63a7\u5236\u89c4\u5219\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        return contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        String newRelationFlag = this.associatedFlag(settleEntity);
        this.logger.info("\u5f00\u59cbcostPush newRelationFlag:" + newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = settleEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(settleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)settleEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(settleEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(settleEntity);
        }
    }

    @Override
    public void costDeletePush(SettleEntity settleEntity) {
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u7ed3\u7b97\u5355Id---{}", (Object)settleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(settleEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity settleEntity = (SettleEntity)((Object)((SettleMapper)this.baseMapper).selectById(settleVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getDetailList())) {
            List storeSubEntityList = BeanMapper.mapList((Iterable)settleVO.getDetailList(), SettleDetailEntity.class);
            settleEntity.setDetailList(storeSubEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getOtherList())) {
            List otherEntities = BeanMapper.mapList((Iterable)settleVO.getOtherList(), SettleOtherEntity.class);
            settleEntity.setOtherList(otherEntities);
        }
        super.saveOrUpdate((Object)settleEntity, false);
        this.costPush(settleEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SettleVO saveOrUpdateSettle(SettleVO saveOrUpdateVO) {
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        SettleEntity oldSettleEntity = null;
        if (entity.getId() == null) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)saveOrUpdateVO.getContractId()));
            List settleEntityList = super.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)settleEntityList)) {
                entity.setSettleTimes(settleEntityList.size());
            } else {
                entity.setSettleTimes(0);
            }
        } else {
            oldSettleEntity = (SettleEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(oldSettleEntity.getBillCode());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        if ((saveOrUpdateVO.getId() != null || saveOrUpdateVO.getSettleType() != 1) && (saveOrUpdateVO.getId() == null || !saveOrUpdateVO.getSettleType().equals(oldSettleEntity.getSettleType()))) return (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        this.contractService.changeContractPerformanceState(saveOrUpdateVO.getSettleType().equals(1) ? ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode() : ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), entity.getContractId());
        return (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
    }

    @Override
    public String delBatch(List<SettleVO> vos) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", (Collection)vos.stream().map(SettleVO::getId).collect(Collectors.toList()));
        List settleList = super.list((Wrapper)query);
        StringBuilder sp = new StringBuilder();
        if (ListUtil.isNotEmpty((List)settleList)) {
            for (SettleEntity vo : settleList) {
                if (vo.getSettleType().equals(1)) {
                    boolean result = this.contractService.changeContractPerformanceState(vo.getSettleType().equals(1) ? ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode() : ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), vo.getContractId());
                    if (result) {
                        super.removeById((Serializable)vo.getId());
                        continue;
                    }
                    sp.append(vo.getContractName()).append("\u3001[").append(vo.getContractCode()).append("]");
                    continue;
                }
                super.removeById((Serializable)vo.getId());
            }
        }
        if (sp.toString().length() > 0) {
            return sp.substring(1);
        }
        return null;
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private String associatedFlag(SettleEntity settleEntity) {
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (null != detailEntity.getDetailWbsId() && null != detailEntity.getDetailSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                if (null != otherEntity.getOtherWbsId() && null != otherEntity.getOtherSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isEmpty(otherList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(detailList)) {
            newRelationFlag = "0";
        }
        return newRelationFlag;
    }

    private void saveCost(SettleEntity settleEntity) {
        CostDetailVO costDetailVO;
        this.logger.info("\u63a8\u9001\u7ed3\u7b97\u5b9e\u4f53\uff1a" + JSONObject.toJSONString((Object)((Object)settleEntity)));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (detailEntity.getSettleNum() == null) continue;
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detailEntity.getDetailSubjectId());
                costDetailVO.setSubjectCode(detailEntity.getDetailSubjectCode());
                costDetailVO.setSubjectName(detailEntity.getDetailSubjectName());
                costDetailVO.setWbsId(detailEntity.getDetailWbsId());
                costDetailVO.setWbsCode(detailEntity.getDetailWbsCode());
                costDetailVO.setWbsName(detailEntity.getDetailWbsName());
                costDetailVO.setSourceId(detailEntity.getSettleId());
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                costDetailVO.setHappenMny(detailEntity.getSettleMny());
                costDetailVO.setSourceTabType("SET_OTHER_DETAIL");
                if (settleEntity.getSettleType() == 1) {
                    costDetailVO.setSourceType("FIN_OTHER_DE");
                }
                if (settleEntity.getSettleType() == 0) {
                    costDetailVO.setSourceType("PRO_OTHER_DE");
                }
                costDetailVO.setHappenDate(detailEntity.getSettleDate());
                costDetailVO.setCreateUserName(detailEntity.getCreateUserCode());
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setSourceBillUrl("/ejc-proother-frontend/#/settleList/costCard?id=" + settleEntity.getId());
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u7ed3\u7b97.getTypeName());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getOtherSubjectId());
                costDetailVO.setSubjectCode(otherEntity.getOtherSubjectCode());
                costDetailVO.setSubjectName(otherEntity.getOtherSubjectName());
                costDetailVO.setWbsId(otherEntity.getOtherWbsId());
                costDetailVO.setWbsCode(otherEntity.getOtherWbsCode());
                costDetailVO.setWbsName(otherEntity.getOtherWbsName());
                costDetailVO.setSourceId(otherEntity.getSettleId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMny());
                costDetailVO.setHappenMny(otherEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getCreateTime());
                costDetailVO.setCreateUserName(otherEntity.getCreateUserCode());
                if (settleEntity.getSettleType() == 1) {
                    costDetailVO.setSourceType("FIN_OTHER_OT");
                }
                if (settleEntity.getSettleType() == 0) {
                    costDetailVO.setSourceType("PRO_OTHER_OT");
                }
                costDetailVO.setSourceBillUrl("/ejc-proother-frontend/#/settleList/costCard?id=" + settleEntity.getId());
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u7ed3\u7b97.getTypeName());
                costDetailVO.setSourceTabType("SET_OTHER_OTHER");
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------\uff1a{}", (Object)JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------: {}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

