package com.ejianc.business.proother.contract.service;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 分包合同实体
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

ContractVO insertOrUpdate(ContractVO saveorUpdateVO, String authority, Boolean isControl);

    String getLinkUrl(ContractVO cv);
    // 校验  劳务/专业分包合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    List<ParamsCheckVO> supplementMnyCtrl(ContractVO contractVO, Boolean flag);

    Map<String, Object> countContractAmount(QueryParam param);

    ContractVO queryDetail(Long id);

    /**
     * 推送目标成本
     * @param contractVO
     * @param linkUrl
     * @param contractType
     * @return
     */
    ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType);



    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    ContractVO querySupplementRecord(Long id);
    /**
     * 新增或者修改补充协议
     *
     * @param saveorUpdateVO
     * @return
     */
    ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO, Boolean isControl);

    ContractVO addConvertByConId(Long contractId);

    Boolean addSupplementFlag(Long id);

    /**
     * 删除附件
     * @param fileId
     * @param authority
     * @return
     */
    Boolean delContractFile(Long fileId, String authority);

    /**
     * 批量删除
     * @param vos
     * @return
     */
    CommonResponse<String> deleteByIds(List<ContractVO> vos);

    /**
     * 合同推送合同池
     *
     * @param contract
     * @return
     */
    boolean pushContract(ContractVO contract);

    /**
     * 将合同从合同池删除
     *
     * @param id
     * @return
     */
    String delContractFromPool(Long id);

    /**
     * 删除当前合同的合同附件
     * @param id
     * @return
     */
    Integer deleteContractFileById(Long id);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    CommonResponse<ContractPaymentResultVO> queryPaymentApplyList(Long id);

    /**
     * 其他合同 明细用子表导入信息校验
     *
     * @param request
     * @param response
     * @return
     */
    JSONObject excelImportInfo(HttpServletRequest request, HttpServletResponse response);

    /**
     * 其他合同 其他费表导入信息校验
     *
     * @param request
     * @param response
     * @return
     */
    JSONObject excelImportOtherInfo(HttpServletRequest request, HttpServletResponse response);

    /**
     * 更新合同履约状态
     *
     * @param performanceStatus
     * @param contractId
     */
    boolean changeContractPerformanceState(String performanceStatus, Long contractId);

    CommonResponse<String> pushTargetCost(ContractVO contractVO);

    /**
     * 归档参数 filingTypeConfig 为
     *             o: 不做控制
     *             1,2: 合同未归档，不允变更、补充协议、结算；
     * @return
     */
    String getFilingTypeConfig();

    List<ParamsCheckVO> checkParamsConstruction(ContractVO contractVO);
}
