package com.ejianc.business.proother.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.proother.contract.bean.*;
import com.ejianc.business.proother.contract.mapper.ChangeMapper;
import com.ejianc.business.proother.contract.service.*;
import com.ejianc.business.proother.contract.vo.*;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 分包变更实体
 * 
 * @author generator
 * 
 */
@Service("changeService")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService {


    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IRecordService recordService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractClauseService contractClauseService;

    @Autowired
    private IContractPaymentService contractPaymentService;

    @Autowired
    private ChangeMapper changeMapper;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IProjectSetApi projectSetApi;

    // 其他支出合同-变更  【合同金额】控【变更金额】
    private final String OTHER_OUT_CHANGE_PARAM_CODE = "P-P7Ir1v95";
    private static final String CHECK_PARAM_CODE = "P-434f5499";

    /**
     * @Description saveOrUpdate 查询当前合同下变更列表
     * @param id
     */
    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        param.getParams().put("performance_status", new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.履约中.getStateCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), ChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        changeVO.setContractType(contractEntity.getContractType());

        //判断能否新增变更
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已终止.getStateCode().equals(contractEntity.getPerformanceStatus()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getPerformanceStatus())))){
            //归档参数控制校验
            String filingTypeFlag = contractService.getFilingTypeConfig();
            if ("0".equals(filingTypeFlag)){//不控制
                changeVO.setEditFlag(this.editChangeFlag(id));
            }else {
                if (this.editChangeFlag(id) && 1 == contractEntity.getFilingStatus()){//已归档
                    changeVO.setEditFlag(true);
                }else {
                    changeVO.setEditFlag(false);
                }
            }
        }else {
            changeVO.setEditFlag(false);
        }
        return changeVO;
    }

    /**
     * 查询能否变更
     * @param contractId
     * @return
     */
    @Override
    public Boolean editChangeFlag(Long contractId) {
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
            自由态也不能新增
         */
        LambdaQueryWrapper<ChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ChangeEntity> changeList = super.list(lambda);
        if (changeList.size() > 0){
            return false;
        }
        return true;
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更合同需要的主合同字段
     * @param contractId
     */
    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = contractService.selectById(contractId, orderMap);
        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            return queryDetail(contractEntity.getChangeId());
        }
        ChangeVO changeVO = BeanMapper.map(contractEntity, ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        //changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        //变更合同的起草方式使用主合同的起草方式
        if(contractEntity.getDraftType() != null && ("1".equals(contractEntity.getDraftType()) || "2".equals(contractEntity.getDraftType()))){
            //双方签
            changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        }else if(contractEntity.getDraftType() != null && ("3".equals(contractEntity.getDraftType()) || "4".equals(contractEntity.getDraftType()))){
            //单方签
            changeVO.setChangeDraftType(DraftTypeEnum.线下签订.getCode().toString());
        }

        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setSignatureStatus(SignatureStatusEnum.待签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        //设置明细表字段
        resetSub(changeVO);

        return changeVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ChangeVO insertOrUpdate(ChangeVO changeVO, Boolean isControl) {
        //成本关门后 不允许变更
        if (!isControl){
            //成本关门后 不允许变更
            CommonResponse<ProjectPoolSetVO> projectRes = projectSetApi.getProjectId(changeVO.getProjectId());
            if(projectRes.isSuccess()&&("16").equals(projectRes.getData().getCapitalStatus())){
                throw new BusinessException("该项目资金管控状态为【成本关门】，不允许此操作!");
            }
        }
        //获取主合同当前合同文件Id
        ContractEntity contract = contractService.selectById(changeVO.getContractId());
        //将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(CollectionUtils.isNotEmpty(changeVO.getAttachIds()) &&  null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }

        ChangeEntity changeEntity = BeanMapper.map(changeVO, ChangeEntity.class);

        //变更合同只能存在一条未生效的
        //查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null) {
            lambdachange.ne(ChangeEntity::getId,changeVO.getId());
        }
        lambdachange.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if (changeEntity.getId() == null){
            // 初始化变更合同主键id
            changeEntity.setId(IdWorker.getId());
            changeEntity.setSignatureStatus(SignatureStatusEnum.待签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setPerformanceStatus(ContractPerformanceStateEnum.未签订.getStateCode());

            if(changeEntity.getChangeVersion() < 10){
                changeEntity.setBillCode(changeEntity.getBillCode() + "-1-0" + changeEntity.getChangeVersion());
            }else{
                changeEntity.setBillCode(changeEntity.getBillCode() + "-1-" + changeEntity.getChangeVersion());
            }

        }
        if (changeEntity.getChangeFilingStatus()==FilingStatusEnum.已归档.getTypeCode()){
            changeEntity.setFilingRef(0);
        }else {
            changeEntity.setFilingRef(null);
        }

        //保存前清空主键和父主键，重新生成
        List<ChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails)){
            Map<String, Long> idMap = new HashMap<>();
            for(ChangeDetailEntity detail : beforeDetails){
                if(null == changeVO.getId() || null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ChangeDetailEntity detail : beforeDetails) {
                if (StringUtils.isNotEmpty(detail.getTpid())) {
                    detail.setParentId(idMap.get(detail.getTpid()));
                }
            }
        }


        //变更保存 删除原有数据,推送变更数据
        //目标成本推送  历史版本主键 changeRecordId
        ContractVO contractVO = contractService.queryDetail(changeVO.getContractId());
        if (Boolean.FALSE.equals(isControl)) {
            if(contractVO != null) {
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionVO = getLastExecutionVO(changeEntity.getContractId());
                totalExecutionVOList.add(executionVO.getTotalVO());
                logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败,"+response.getMsg());
                }
            }
        }

        if(Boolean.FALSE.equals(isControl)){
            super.saveOrUpdate(changeEntity, false);
            //变更信息回写主合同
            saveWriteContract(changeEntity);

            //目标成本推送
            String linkUrl = this.getLinkUrl(BeanMapper.map(changeEntity, ChangeVO.class));
            ExecutionVO executionVO = targetCost(BeanMapper.map(changeEntity, ChangeVO.class),linkUrl,changeEntity.getContractType(), false);
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }

            return queryDetail(changeEntity.getId());
        }

        return BeanMapper.map(changeEntity, ChangeVO.class);
    }

    private ExecutionVO getLastExecutionVO(Long contractId) {
        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId).orderByDesc("create_time");
        List<ChangeEntity> list = super.list(wrapper);

        //判断是否有过变更
        if (!list.isEmpty()){
            return targetCost(BeanMapper.map(list.get(0), ChangeVO.class), "", list.get(0).getContractType(), false);
        }else {
            ContractEntity contractEntity = contractService.selectById(contractId);
            return contractService.targetCost(BeanMapper.map(contractEntity, ContractVO.class), "", contractEntity.getContractType());
        }
    }


    @Override
    public String getLinkUrl(ChangeVO cv) {
        String linkUrl;
        // 合同和补充协议变更地址一样
        if (0 == cv.getAddType()){
            // 参照定标结果新增
            linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&cid=" + cv.getId() + "&cardType=otherSubCard";
        } else {
            // 直接新增
            linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&cid=" + cv.getId() + "&cardType=otherSubDirectCard";
        }
        return linkUrl;
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ChangeEntity changeEntity = super.selectById(id, orderMap);
        ChangeVO changeVO = new ChangeVO();
        if (null != changeEntity){
            changeVO =  BeanMapper.map(changeEntity, ChangeVO.class);
        }

        List<Long> srcTblIdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            //判断清单是否被下游数据引用
//            List<ChangeDetailVO> usefulDetailList = selectUsefulByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
//
//            Map<Long, Integer> usefulDetailMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(usefulDetailList)){
//                for (ChangeDetailVO c : usefulDetailList){
//                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
//                }
//            }
//            for (ChangeDetailVO c : changeVO.getDetailList()){
//                if (null != usefulDetailMap.get(c.getSrcTblId())){
//                    c.setUseNum(1);
//                }else {
//                    c.setUseNum(null);
//                }
//            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree(changeVO.getDetailList()));
        }

        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangeEntity entity = super.selectById(changeBillId);
        //合同变更只有详情页有删除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<ChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion()-1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<ContractEntity>().eq("id",contractEntity.getId()),false);

        super.removeById(changeBillId,false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询变更对比
     * @param id
     * @param
     * @return
     */
    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<>();
        orderByParams.put("treeIndex", QueryParam.ASC);
        Map<String, LinkedHashMap<String, String>> orders = new HashMap<>();
        orders.put("detailList", orderByParams);
        ChangeEntity changeEntity = super.selectById(id, orders);
        ChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ChangeCompareVO.class);
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());

        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            //若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<RecordEntity> lambda = Wrappers.<RecordEntity>lambdaQuery();
            lambda.eq(RecordEntity::getChangeId, id)
                    .eq(RecordEntity::getContractId, changeEntity.getContractId())
                    .orderByDesc(RecordEntity::getCreateTime);
            List<RecordEntity> recordList = recordService.list(lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null){
                beforeChangeVO = BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, ChangeCompareVO.class);
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null){
            //设置明细内容
            if (CollectionUtils.isNotEmpty(changeCompareVO.getDetailList())) {
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> StringUtils.isNotBlank(detail.getChangeType())).collect(Collectors.toList())));
            }

            //设置其他花费内容
            if (CollectionUtils.isNotEmpty(changeCompareVO.getOtherCostList())){
                changeCompareVO.setOtherCostList(
                        changeCompareVO.getOtherCostList().stream().filter(cost -> null != cost.getChangeType()).collect(Collectors.toList())
                );
            }

            if (CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())){
                changeCompareVO.setClauseList(
                        changeCompareVO.getClauseList().stream().filter(clause -> null == clause.getBeforeClauseContent() || !clause.getBeforeClauseContent().equals(clause.getClauseContent())).collect(Collectors.toList())
                );
            }

            if (CollectionUtils.isNotEmpty(changeCompareVO.getPaymentList())){
                changeCompareVO.setPaymentList(//前付款比例为空证明是新增项
                        changeCompareVO.getPaymentList().stream().filter(payment -> null == payment.getBeforePaymentScale() || !payment.getBeforePaymentScale().equals(payment.getPaymentScale())).collect(Collectors.toList())
                );
            }


            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }


    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWriteContract(ChangeEntity changeEntity){
        /*
            回写主合同，两个金额六个变更
         */
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()){
            updateWrapper.set(ContractEntity::getChangingMny, changeEntity.getChangeMny().subtract(changeEntity.getChangeTax()));
        }
        updateWrapper.set(ContractEntity::getChangingTaxMny, changeEntity.getChangeMny());

        updateWrapper.set(ContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, changeEntity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeFileId, changeEntity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, changeEntity.getContractName());

        updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());

        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }



    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = contractService.selectById(contractId);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, changeId));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RecordEntity> recordList = recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty(recordList)){
            changeVO = BeanMapper.map(recordList.get(0), ChangeVO.class);
        }

        if (changeVO !=null){
            resetSub(changeVO);
        }

        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        //设置明细表字段
        List<ChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            List<Long> srcTblIdList = new ArrayList<>();
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("edit");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });

//            //判断清单是否被下游数据引用（零工登记，零工申请，分包计量，过程结算）
//            List<ChangeDetailVO> usefulDetailList = selectUsefulByIds(changeDetailList.stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
//
//            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
//            if (CollectionUtils.isNotEmpty(usefulDetailList)){
//                for (ChangeDetailVO c : usefulDetailList){
//                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
//                }
//            }
//            for (ChangeDetailVO c : changeDetailList){
//                if (null != usefulDetailMap.get(c.getSrcTblId())){
//                    c.setUseNum(1);
//                }else {
//                    c.setUseNum(null);
//                }
//            }
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        //其他费用
        List<ChangeOtherCostVO> changeOtherCostVOList = changeVO.getOtherCostList();
        if(CollectionUtils.isNotEmpty(changeOtherCostVOList)){
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setRowState("add");
            });
        }
        //清单
        List<ChangeClauseVO> changeClauseList = changeVO.getClauseList();
        if(CollectionUtils.isNotEmpty(changeClauseList)){
            changeClauseList.forEach(changeClauseVO ->{
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }

        //付款阶段
        List<ChangePaymentVO> payList = changeVO.getPaymentList();
        if(CollectionUtils.isNotEmpty(payList)){
            payList.forEach(item ->{
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }


    /**
     * 变更单据生效创建记录文件并回写主合同
     * @param changeBillId
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState,boolean filingFlag) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        ChangeEntity changeEntity = super.selectById(changeBillId);
        if (commitState){
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        }

        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制合同表数据到记录表 begin */
        ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
        //获取当前合同记录数
        QueryWrapper<RecordEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("contract_id", contractVO.getId());
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int curRecordVersion = recordService.count(countQuery);

        Map<Long, Integer> contIdVersionMap =  new HashMap<>();
        RecordEntity recordEntity = BeanMapper.map(contractVO, RecordEntity.class);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion+1);
        recordEntity.setId(null);
        logger.info("变更前主合同数据: {}", JSONObject.toJSONString(contractVO));
        logger.info("变更前主合同子表detail数据: {}", JSONObject.toJSONString(contractVO.getDetailList()));
        logger.info("记录表从主合同表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主合同表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getDetailList()));

        if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getClauseList())){
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())){
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getPaymentList())){
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");

        //原合同附件、起草附件同步到记录单据中
        resp = copyFile(contractVO.getId().toString(), ProotherBillTypeEnum.其他支出合同.getBillTypeCode(),
                recordEntity.getId().toString(), ProotherBillTypeEnum.其他支出合同记录.getBillTypeCode(), CONTRACT_ATTACH_SOURCE_TYPE, true);
        if(resp != null) {
            logger.error("同步原合同附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
        }
        /**复制合同表数据到记录表 end */

        /**更新变更表主表数据到原合同 begin */
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setTargetResultType(changeEntity.getTargetResultType());

        //劳务分包人资质
        contractEntity.setQualifyId(changeEntity.getQualifyId());
        contractEntity.setQualifyName(changeEntity.getQualifyName());
        contractEntity.setQualifyCertifyNo(changeEntity.getQualifyCertifyNo());
        contractEntity.setQualifyLicenceIssuingAuthority(changeEntity.getQualifyLicenceIssuingAuthority());
        contractEntity.setQualifyGrantDate(changeEntity.getQualifyGrantDate());
        contractEntity.setQualifyValidTillDate(changeEntity.getQualifyValidTillDate());
        contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
        contractEntity.setSafetyCertifyGrantDate(changeEntity.getSafetyCertifyGrantDate());
        contractEntity.setSafetyCertifyValidTillDate(changeEntity.getSafetyCertifyValidTillDate());
        //合同工期
        contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
        contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
        //项目经理代表人
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
        contractEntity.setSupplierProjectManagerId(changeEntity.getSupplierProjectManagerId());
        contractEntity.setSupplierProjectManagerIdCard(changeEntity.getSupplierProjectManagerIdCard());
        contractEntity.setSupplierProjectManagerLink(changeEntity.getSupplierProjectManagerLink());
        contractEntity.setSupplierProjectManagerName(changeEntity.getSupplierProjectManagerName());
        contractEntity.setSupplierProjectManagerPost(changeEntity.getSupplierProjectManagerPost());
        //分包款项
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setSubContractTaxMny(changeEntity.getSubContractTaxMny());
        contractEntity.setSubContractMny(changeEntity.getSubContractMny());
        contractEntity.setSubContractTax(changeEntity.getSubContractTax());
        contractEntity.setOtherCostMny(changeEntity.getOtherCostMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        //清空变更单信息
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);

        logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
        //设置变更合同生效状态
        changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        changeEntity.setPerformanceStatus(ContractPerformanceStateEnum.履约中.getStateCode());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());
        //签章来的 可以修改 不然不修改
        if (filingFlag){
            changeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        //同步变更单附件（不包含变更变更附件）到原合同
        resp = copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), ProotherBillTypeEnum.其他支出合同.getBillTypeCode(), "subChangeContractFile", false);
        if(resp != null) {
            logger.error("同步变更附件到原合同失败，失败原因：{}", JSONObject.toJSONString(resp));
        }

        //变更单更新
        super.saveOrUpdate(changeEntity,false);
        logger.info("更新变更表合同状态和数据,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更表主表数据到原合同 end */

        /**更新变更子表数据到原合同子表 begin */
        logger.info("更新变更表数据到主合同开始----------->" + contractEntity.getChangeStatus());
        ContractEntity contractChangeEntity = BeanMapper.map(changeEntity, ContractEntity.class);
        List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        Map<Long,Long> changDetailIdMap = new HashMap<>();
		/*
			变更详情表和合同详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
			合同详情表里 变更子表主键 changeBid
		 */
		Map<Long, Long> changeParentIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailEntity -> {
                //设置id和来源子表主键对应map
                changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId());
            });
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null){
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }

        List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(contractDetailList)){
            Long contractBid = null;
            for(ContractDetailEntity contractDetailEntity : contractDetailList) {
                contractBid = changDetailIdMap.get(contractDetailEntity.getId());

                contractDetailEntity.setContractId(changeEntity.getContractId());
                //设置变更子表主键
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                //设置父级Id
                if(null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId(changDetailIdMap.get(contractDetailEntity.getParentId()));
                }

                //合同子表对应变更子表主键
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);

        //其他费用表
        List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
        Map<Long,Long> changOtherCostIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)){
            changeOtherCostList.forEach(changeOtherCostEntity -> {
                //设置id和来源子表主键对应map
                changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId());
            });
        }
        List<ContractOtherCostEntity> contractOtherCostList = contractChangeEntity.getOtherCostList();
        if(CollectionUtils.isNotEmpty(contractOtherCostList)){
            Long contractBid = null;
            for(ContractOtherCostEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = changOtherCostIdMap.get(contractOtherCostEntity.getId());
                //设置变更子表主键
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                //合同子表对应变更子表主键
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion(contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);

        //先删除合同条款表
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if(CollectionUtils.isNotEmpty(contractClauseList)){
            logger.info("删除合同条款子表数据: {}", JSONObject.toJSONString(contractClauseList));
            contractClauseService.deleteByIds(contractClauseList.stream().map(ContractClauseEntity::getId).collect(Collectors.toList()));

            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);

        //合同付款阶段
        List<ContractPaymentEntity> contractPayList = contractEntity.getPaymentList();
        List<ContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if(CollectionUtils.isNotEmpty(contractPayList)){
            logger.info("删除合同付款阶段子表数据: {}", JSONObject.toJSONString(contractPayList));
            contractPaymentService.deleteByIds(contractPayList.stream().map(ContractPaymentEntity::getId).collect(Collectors.toList()));

            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);

        contractService.saveOrUpdate(contractEntity, false);
        contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
        logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

    @Override
    public List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList) {
        return changeMapper.selectUsefulByIds(srcTblIdList);
    }


    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        if(copyContractFile) {
            //同步合同文件
            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE,
                    targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE);
            if (!copyContractFileResp.isSuccess()){
                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                        ,srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, copyContractFileResp.getMsg());
                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
            }
        }

        return null;
    }

    @Override
    public ExecutionVO targetCost(ChangeVO changeVO, String linkUrl, Integer contractType, boolean lastSourceId){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getBillCode());
        // totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setBillType(ProotherBillTypeEnum.其他支出合同.getBillTypeCode());
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());

        //新增变更且为成本控制时，传递上一版本业务单据Id
        if(lastSourceId) {
            if(null == changeVO.getId()) {
                totalVO.setLastSourceId(getLastExecutionVO(changeVO.getContractId()).getTotalVO().getSourceId());
            } else {
                ChangeEntity change = super.selectById(changeVO.getId());
                if(null == change) {
                    totalVO.setLastSourceId(getLastExecutionVO(changeVO.getContractId()).getTotalVO().getSourceId());
                }
            }
        }

        if (changeVO.getProjectId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(changeVO.getProjectId());
        }
        if (changeVO.getOrgId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(changeVO.getOrgId());
        }
        totalVO.setMoney(changeVO.getContractMny()); //总计划金额无税
        totalVO.setTaxMoney(changeVO.getContractTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public Collection<? extends ParamsCheckVO> checkParamsConstruction(ChangeVO vo) {
        // 1、获取施工合同金额信息
        CommonResponse<BigDecimal> contractionData = contractPoolApi.queryContractionTaxMny(vo.getProjectId());
        if (!(contractionData.isSuccess() && null != contractionData.getData())) {
            logger.info(contractionData.getMsg());
            throw new BusinessException("获取施工合同信息失败！");
        }
        // 施工合同总金额
        BigDecimal contractionTaxMny = new BigDecimal(String.valueOf(contractionData.getData()));
        logger.info("获取项目：{}下，施工合同总金额：{}", vo.getProjectId(), contractionTaxMny);

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        if (BigDecimal.ZERO.compareTo(contractionTaxMny) == 0){
            // 该项目无施工合同直接赋值为不控制
            return paramsCheckVOList;
        }
        // 2、获取参数控制规则
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){

                CommonResponse<BigDecimal> projectData = executionApi.queryTotalContMny(vo.getProjectId());
                if (!(projectData.isSuccess() && null != projectData.getData())) {
                    logger.info(projectData.getMsg());
                    throw new BusinessException("获取目标成本项目信息失败！");
                }

                // 支出合同总金额
                BigDecimal allExpenseContractTaxMny = new BigDecimal(String.valueOf(projectData.getData()));
                logger.info("获取目标成本项目：{}下，所有支出合同总金额：{}", vo.getProjectId(), allExpenseContractTaxMny);

                // 本次变动金额（首次金额或修改后金额）
                BigDecimal thisTimeChangeTaxMny = vo.getChangeMny();
                logger.info("本次变动金额：{}", thisTimeChangeTaxMny);

                ChangeEntity oldChangeEntity = super.selectById(vo.getId());
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();

                    // 比例
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    // 施工合同总金额 乘 比例后金额
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractionTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    logger.info("施工合同金额*比例后金额：{}", comMny);
                    // 含本次合同金额
                    BigDecimal sumPayContractTaxMny = ComputeUtil.safeAdd(allExpenseContractTaxMny, thisTimeChangeTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);;
                    if (null != oldChangeEntity){
                        logger.info("上次变更金额：{}", oldChangeEntity.getChangeMny());
                        //修改保存，需要减掉旧的变更金额
                        sumPayContractTaxMny = ComputeUtil.safeAdd(ComputeUtil.safeSub(allExpenseContractTaxMny, oldChangeEntity.getChangeMny()).setScale(2,BigDecimal.ROUND_HALF_UP), thisTimeChangeTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);
                    }
                    logger.info("含本次合同金额：{}", sumPayContractTaxMny);


                    if (sumPayContractTaxMny.compareTo(comMny) > 0) {
                        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);

                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem("支出超施工合同");
                        paramsCheckDsVO.setWarnName("累计支出合同金额大于施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(vo.getContractTaxMny())
                                .append("元，含本次合同金额：").append(sumPayContractTaxMny)
                                .append("元，施工合同金额*").append(roleValue).append("% = ").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(sumPayContractTaxMny, comMny).setScale(2,BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                        logger.info("paramsCheckDsVO:{}", JSONObject.toJSONString(paramsCheckDsVO));
                    }else{
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }


    // 校验  其他支出合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public List<ParamsCheckVO> changeMnyCtrl(ChangeVO changeVO, Boolean flag) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> checkList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> paramListResp = paramConfigApi.getBillParamByCodeAndOrgId(OTHER_OUT_CHANGE_PARAM_CODE, changeVO.getOrgId());
        if (!paramListResp.isSuccess()) {
            logger.error("获取 其他支出合同-变更 参数控制规则失败， {}", JSONObject.toJSONString(paramListResp));
            return checkList;
        }

        // 控制规则值  百分比
        BigDecimal roleValue = null;
        ParamsCheckVO paramsCheckVO = null;
        List<ParamsCheckDsVO> dataSource = null;
        for(BillParamVO billParamVO : paramListResp.getData()) {
            dataSource = new ArrayList<>();
            roleValue  = billParamVO.getRoleValue();
            paramsCheckVO = new ParamsCheckVO();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 为none时不需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                // 合同初始版本金额
                BigDecimal baseTaxMny = changeVO.getBaseTaxMny();
                // 当前变更单的合同金额
                BigDecimal contractTaxMny = changeVO.getContractTaxMny();
                // 计算 累计合同变更金额
                BigDecimal changeTaxMny = contractTaxMny.subtract(baseTaxMny);
                // 计算 本次变更金额
                BigDecimal changeTaxMnyTime = contractTaxMny.subtract(changeVO.getBeforeChangeTaxMny());
                // 计算 合同初始金额 * X%
                BigDecimal conTaxMny = baseTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                // 控制金额：变更金额 > 合同金额*X%
                if (changeTaxMny.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = changeTaxMny.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("变更超合同金额");
                    paramsCheckDsVO.setWarnName("累计变更金额大于合同金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次变更金额：").append(changeTaxMnyTime.setScale(2, RoundingMode.DOWN))
                            .append("，含本次累计变更金额：").append(changeTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(conTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            checkList.add(paramsCheckVO);

        }

        return checkList;
    }

}
