package com.ejianc.business.proother.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/contractFileUpdate/")
public class ContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISignatureManageApi signatureManageApi;

    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IChangeService changeService;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));

        //将合同文件同步状态设置为已同步
        contract.setContractFileSyncFlag(true);

        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }

    @GetMapping(value = "getBillDataJson")
    public CommonResponse<com.ejianc.business.proother.contract.vo.ContractVO> getBillDataJson(@RequestParam Long id) {
        ContractEntity contract = contractService.selectById(id);
        com.ejianc.business.proother.contract.vo.ContractVO vo = BeanMapper.map(contract, com.ejianc.business.proother.contract.vo.ContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if(CollectionUtils.isNotEmpty(vo.getDetailList())) {
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(null != item.getDetailPrice() ? priceFmt.format(item.getDetailPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailTaxPriceStr(null != item.getDetailTaxPrice() ? priceFmt.format(item.getDetailTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailMnyStr(null != item.getDetailMny() ? mnyFmt.format(item.getDetailMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxMnyStr(null != item.getDetailTaxMny() ? mnyFmt.format(item.getDetailTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxStr(null != item.getDetailTax() ? mnyFmt.format(item.getDetailTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxRateStr(null != item.getDetailTaxRate() ? mnyFmt.format(item.getDetailTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailNumStr(null != item.getDetailNum() ? priceFmt.format(item.getDetailNum()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherCostList())) {
            vo.getOtherCostList().forEach(item -> {
                item.setCostPriceStr(null != item.getCostPrice() ? priceFmt.format(item.getCostPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostTaxPriceStr(null != item.getCostTaxPrice() ? priceFmt.format(item.getCostTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostMnyStr(null != item.getCostMny() ? mnyFmt.format(item.getCostMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCostTaxMnyStr(null != item.getCostTaxMny() ? mnyFmt.format(item.getCostTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCostTaxStr(null != item.getCostTax() ? mnyFmt.format(item.getCostTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCostNumStr(null != item.getCostNum() ? priceFmt.format(item.getCostNum()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostTaxRateStr(null != item.getCostTaxRate() ? mnyFmt.format(item.getCostTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }

        return CommonResponse.success(vo);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        JSONObject resp = new JSONObject();
        ArrayList<ContractVO> cvs = new ArrayList<>();
        ContractVO cv = new ContractVO();
        // 查询合同详情
        if("contract".equals(billType)) {
            ContractEntity entity = contractService.selectById(billId);
            Assert.notNull(entity, "查询不到合同详情");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setBillType(ProotherBillTypeEnum.其他支出合同.getBillTypeCode());
            cv.setSourceType("proOtherContract");
            cvs.add(cv);
        }else {
            ChangeEntity changeEntity = changeService.selectById(billId);
            Assert.notNull(changeEntity, "查询不到变更合同详情");
            cv.setContractId(changeEntity.getId());
            cv.setContractName(changeEntity.getContractName());
            cv.setBillType(ProotherBillTypeEnum.其他合同变更.getBillTypeCode());
            cv.setSourceType("proOtherContractChange");
            cvs.add(cv);
        }

        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            return CommonResponse.error("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            return CommonResponse.error("为获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        if("contract".equals(billType)) {
            ContractEntity contract = contractService.selectById(billId);
            contract.setSignedFileId(signedFileInfo.getFileId());
            contractService.saveOrUpdate(contract, false);
        } else {
            ChangeEntity contractChange = changeService.selectById(billId);
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            changeService.saveOrUpdate(contractChange, false);
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return CommonResponse.success("查询成功！", resp);
    }
}
