/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.contract.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class OtherContractApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;

    @GetMapping(value={"/api/contract/queryContractByTargetResultId"})
    @ResponseBody
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value="targetResultIdList") List<String> targetResultIdList) {
        if (CollectionUtils.isNotEmpty(targetResultIdList)) {
            this.logger.info("\u63a5\u6536\u5b9a\u6807id\u96c6\u5408\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(targetResultIdList));
            ArrayList resp = new ArrayList();
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"target_result_id", targetResultIdList);
            List entities = this.contractService.list((Wrapper)query);
            entities.forEach(contractEntity -> {
                SignContractVo signContractVo = new SignContractVo();
                signContractVo.setBillCode(contractEntity.getBillCode());
                signContractVo.setBillState(contractEntity.getBillState());
                signContractVo.setContractId(contractEntity.getId());
                signContractVo.setContractTaxMny(contractEntity.getContractTaxMny());
                signContractVo.setContractMny(contractEntity.getContractMny());
                signContractVo.setContractName(contractEntity.getContractName());
                signContractVo.setSignDate(contractEntity.getSignDate());
                signContractVo.setSupplierId(contractEntity.getSupplierId());
                signContractVo.setSupplierName(contractEntity.getSupplierName());
                signContractVo.setLinkUrl(this.contractService.getLinkUrl((ContractVO)BeanMapper.map((Object)contractEntity, ContractVO.class)));
                resp.add(signContractVo);
            });
            return CommonResponse.success((String)"\u6839\u636e\u62db\u6807id\u67e5\u8be2\u5408\u540c\u96c6\u5408\u6210\u529f\uff01", resp);
        }
        return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b9a\u6807id\u96c6\u53c2\u6570\uff01");
    }
}

