package com.ejianc.business.pro.ownrmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.ownrmat.vo.HandleDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周转材处置
 * 
 * @author generator
 * 
 */
public class HandleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long orgId; // 所属组织
    private String orgName; // 所属组织名称
    private Long storeId; // 仓库
    private String storeName; // 仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 处置日期
    private Long handleOutStoreId; // 处置单对应出库单据Id
    private Integer handleType; // 处置类型 1消耗材 2周转材
    private String materialTypes; // 物料分类
    private BigDecimal handleMny; // 处置金额
    private BigDecimal netWorthTaxMny; // 材料净值
    private BigDecimal handleSubMny; // 处置差额
    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    private String handleReason; // 处置原因
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String billStateName;//单据状态
    private BigDecimal handleTaxMny; // 处置金额
    private BigDecimal handleSubTaxMny; // 处置差额
    private String relationFlag; // 关联状态(1:是，0：否)
    private String proportionFlag; // 分摊状态(1:是，0：否)

    private List<HandleDetailVO> handleSubList = new ArrayList<>(); // 周转材处置明细表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="store-store")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public Long getHandleOutStoreId() {
        return handleOutStoreId;
    }

    public void setHandleOutStoreId(Long handleOutStoreId) {
        this.handleOutStoreId = handleOutStoreId;
    }
    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    public String getMaterialTypes() {
        return materialTypes;
    }

    public void setMaterialTypes(String materialTypes) {
        this.materialTypes = materialTypes;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getHandleReason() {
        return handleReason;
    }

    public void setHandleReason(String handleReason) {
        this.handleReason = handleReason;
    }
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }

    public BigDecimal getNetWorthTaxMny() {
        return netWorthTaxMny;
    }

    public void setNetWorthTaxMny(BigDecimal netWorthTaxMny) {
        this.netWorthTaxMny = netWorthTaxMny;
    }

    public BigDecimal getHandleSubMny() {
        return handleSubMny;
    }

    public void setHandleSubMny(BigDecimal handleSubMny) {
        this.handleSubMny = handleSubMny;
    }

    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public BigDecimal getHandleSubTaxMny() {
        return handleSubTaxMny;
    }

    public void setHandleSubTaxMny(BigDecimal handleSubTaxMny) {
        this.handleSubTaxMny = handleSubTaxMny;
    }

    public List<HandleDetailVO> getHandleSubList() {
        return handleSubList;
    }

    public void setHandleSubList(List<HandleDetailVO> handleSubList) {
        this.handleSubList = handleSubList;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
}
