package com.ejianc.business.pro.rmat.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ContractFilingTypeEnum {

    /**
     * 租赁合同补充协议
     */
    租赁合同补充协议("contract_supplement", "租赁合同补充协议"),
    /**
     * 租赁合同变更
     */
    租赁合同变更("contract_change", "租赁合同变更"),
    /**
     * 租赁合同月度结算
     */
    租赁合同结算("contract_settle", "租赁合同结算"),
    /**
     * 合同付款申请
     */
    合同付款申请("contract_payment", "合同付款申请");

    ContractFilingTypeEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    //合同烈性
    private String typeCode;
    //合同业务类型名称
    private String typeName;
    private static Map<String, ContractFilingTypeEnum> enumMap = new HashMap<>();


    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(ContractFilingTypeEnum.class).stream().collect(Collectors.toMap(ContractFilingTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractFilingTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }

    public static ContractFilingTypeEnum getEnumByCode(String typeCode) {
        return enumMap.get(typeCode);
    }
}
