package com.ejianc.business.pro.rmat.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 物料台账流水明细
 * 
 * @author generator
 * 
 */
@ApiModel("物料台账流水明细")
public class MaterialFlowVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键")
    private String parameterId;
    @ApiModelProperty("操作日期（启用/停用/租金计算日期）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date operationDate;
    @ApiModelProperty("物料状态:1--进场,2--启用,3--停用,4--退场")
    private Integer materialState;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("来源类型（0-启用单，1-停用单，2-租金计算，3-退场）")
    private String sourceType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    private BigDecimal startedNum; // 在场已启用数量
    private BigDecimal stopedNum; // 在场已停用数量
    private String useStatus; // 使用状态：0-停用，1-启用

    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }

    public BigDecimal getStartedNum() {
        return startedNum;
    }

    public void setStartedNum(BigDecimal startedNum) {
        this.startedNum = startedNum;
    }

    public BigDecimal getStopedNum() {
        return stopedNum;
    }

    public void setStopedNum(BigDecimal stopedNum) {
        this.stopedNum = stopedNum;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public String getParameterId() {
        return parameterId;
    }

    public void setParameterId(String parameterId) {
        this.parameterId = parameterId;
    }

    /**
     * 操作日期（启用/停用/租金计算日期）
     */
    public Date getOperationDate() {
        return operationDate;
    }

    /**
     * 操作日期（启用/停用/租金计算日期）
     */
    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }

    public Integer getMaterialState() {
        return materialState;
    }

    public void setMaterialState(Integer materialState) {
        this.materialState = materialState;
    }

    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源类型（0-启用单，1-停用单，2-租金计算，3-退场）
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型（0-启用单，1-停用单，2-租金计算，3-退场）
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    
}
