package com.ejianc.business.pro.rmat.vo.record;

import com.ejianc.business.pro.rmat.vo.ChangeVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ChangeRecordVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;
    
    /**
     * 初始版本金额(不含税)
     */
    private BigDecimal baseMny; 

    /**
     * 初始版本金额
     */
    private BigDecimal baseTaxMny; 
    
    /**
     * 主合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 主合同金额(无税)
     */
    private BigDecimal contractMny;

    /**
     * 累计变更金额(无税)
     */
    private BigDecimal totalChangeMny;

    /**
     * 累计变更金额(含税)
     */
    private BigDecimal totalChangeTaxMny;

    /**
     * 累计变更次数
     */
    private Integer totalChangeNum;
    
    /**
     * 累计变更比例
     */
    private BigDecimal totalChangeRate;
    
    /**
     * 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结
     */
    private String performanceStatus;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;

    private boolean canAddNewChangeFlag; //是否可以创建新的结算单
    private String rentType; // 租赁方式：0-外租，1-内租
    
    private List<ChangeVO> detailList = new ArrayList<>();


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTotalChangeMny() {
        return totalChangeMny;
    }

    public void setTotalChangeMny(BigDecimal totalChangeMny) {
        this.totalChangeMny = totalChangeMny;
    }

    public BigDecimal getTotalChangeTaxMny() {
        return totalChangeTaxMny;
    }

    public void setTotalChangeTaxMny(BigDecimal totalChangeTaxMny) {
        this.totalChangeTaxMny = totalChangeTaxMny;
    }

    public Integer getTotalChangeNum() {
        return totalChangeNum;
    }

    public void setTotalChangeNum(Integer totalChangeNum) {
        this.totalChangeNum = totalChangeNum;
    }

    public BigDecimal getTotalChangeRate() {
        return totalChangeRate;
    }

    public void setTotalChangeRate(BigDecimal totalChangeRate) {
        this.totalChangeRate = totalChangeRate;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public List<ChangeVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ChangeVO> detailList) {
        this.detailList = detailList;
    }

    public boolean isCanAddNewChangeFlag() {
        return canAddNewChangeFlag;
    }

    public void setCanAddNewChangeFlag(boolean canAddNewChangeFlag) {
        this.canAddNewChangeFlag = canAddNewChangeFlag;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
}
