package com.ejianc.business.pro.rmat.vo.record;

import com.ejianc.business.pro.rmat.vo.ContractVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SupplementRecordVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;

    /**
     * 主合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 主合同金额(无税)
     */
    private BigDecimal contractMny;
    
    /**
     * 补充协议合同总金额(含税)
     */
    private BigDecimal supplementToalTaxMny;

    /**
     * 补充协议合同总金额(无税)
     */
    private BigDecimal supplementToalMny;
    
    /**
     * 补充协议次数
     */
    private Integer supplementNum;

    /**
     * 补充协议比例
     */
    private BigDecimal supplementMnyRate;
    
    /**
     * 合同履约状态：0-未签订，1-履约中，2-已终止，3-已作废，4-已冻结
     */
    private String performanceStatus;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;

    private boolean editFlag;

    private String rentType; // 租赁方式：0-外租，1-内租
    
    private List<ContractVO> detailList = new ArrayList<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSupplementToalTaxMny() {
        return supplementToalTaxMny;
    }

    public void setSupplementToalTaxMny(BigDecimal supplementToalTaxMny) {
        this.supplementToalTaxMny = supplementToalTaxMny;
    }

    public BigDecimal getSupplementToalMny() {
        return supplementToalMny;
    }

    public void setSupplementToalMny(BigDecimal supplementToalMny) {
        this.supplementToalMny = supplementToalMny;
    }

    public Integer getSupplementNum() {
        return supplementNum;
    }

    public void setSupplementNum(Integer supplementNum) {
        this.supplementNum = supplementNum;
    }

    public BigDecimal getSupplementMnyRate() {
        return supplementMnyRate;
    }

    public void setSupplementMnyRate(BigDecimal supplementMnyRate) {
        this.supplementMnyRate = supplementMnyRate;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public List<ContractVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractVO> detailList) {
        this.detailList = detailList;
    }

    public boolean isEditFlag() {
        return editFlag;
    }

    public void setEditFlag(boolean editFlag) {
        this.editFlag = editFlag;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
}
