package com.ejianc.business.pro.rmat.vo.record;


import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.List;


/**
 * 分包合同
 * 
 * @author generator
 * 
 */
public class ContractPaymentRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额(无税)
     */
    private BigDecimal contractMny;

     /**
     * 累计付款金额
     */
    private BigDecimal totalApplyMny;

     /**
     * 累计批复金额
     */
    private BigDecimal totalApprovalMny;

     /**
     * 累计实付金额
     */
    private BigDecimal totalActualMny;

     /**
     * 付款比例
     */
    private BigDecimal paymentRate;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 合同履约状态：0-未签订，1-履约中，2-已终止，3-已作废，4-已冻结
     */
    private String performanceStatus;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;

    /**
     * 合同新增方式：参照定标结果新增-0，直接新增-1
     */
    private Integer addType;

    /**
     * 是否能新增付款申请单（不入库）
     */
    private Boolean addFlag = false;

    private String rentType; // 租赁方式：0-外租，1-内租

    /**
     * 付款申请单集合
     */
    private List<PaymentApplyVO> paymentApplyList;


    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTotalApplyMny() {
        return totalApplyMny;
    }

    public void setTotalApplyMny(BigDecimal totalApplyMny) {
        this.totalApplyMny = totalApplyMny;
    }

    public BigDecimal getTotalApprovalMny() {
        return totalApprovalMny;
    }

    public void setTotalApprovalMny(BigDecimal totalApprovalMny) {
        this.totalApprovalMny = totalApprovalMny;
    }

    public BigDecimal getTotalActualMny() {
        return totalActualMny;
    }

    public void setTotalActualMny(BigDecimal totalActualMny) {
        this.totalActualMny = totalActualMny;
    }

    public BigDecimal getPaymentRate() {
        return paymentRate;
    }

    public void setPaymentRate(BigDecimal paymentRate) {
        this.paymentRate = paymentRate;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public Boolean getAddFlag() {
        return addFlag;
    }

    public void setAddFlag(Boolean addFlag) {
        this.addFlag = addFlag;
    }

    public List<PaymentApplyVO> getPaymentApplyList() {
        return paymentApplyList;
    }

    public void setPaymentApplyList(List<PaymentApplyVO> paymentApplyList) {
        this.paymentApplyList = paymentApplyList;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
}
