package com.ejianc.business.pro.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 周转材租赁合同-工程量租明细
 *
 * @author generator
 */
public class ContractNumRentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同id
    private Long sourceId; // 来源数据Id
    private String sourceType; // 来源类型：0-定标结果带入，1-总计划，2-材料档案，3-批次计划
    private Long changeId; // 变更表主键
    private Long changeBid; // 变更子表主键
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private String materialName; // 材料名称
    private String spec; // 规格/型号
    private BigDecimal count; // 数量
    private BigDecimal unitPrice; // 单价(无税)
    private BigDecimal unitTaxPrice; // 单价
    private BigDecimal taxRate; // 税率
    private BigDecimal tax; // 税额
    private BigDecimal loseUnitPrice; // 遗失单价(无税)
    private BigDecimal loseUnitTaxPrice; // 遗失单价
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 计划进场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 计划出场时间
    private String memo; // 备注
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称

    private BigDecimal surplusCount; // 剩余数量
    private BigDecimal quantities; // 工程量
    private BigDecimal rentTaxMny; // 租赁金额
    private BigDecimal rentMny; // 租赁金额(无税)
    private BigDecimal rentTax; // 租赁税额

    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    private BigDecimal targetCount; // 定标数量
    private BigDecimal targetUnitTaxPrice; // 定标单价

    //模板导出使用
    private String countStr; // 数量
    private String unitPriceStr; // 单价(无税)
    private String unitTaxPriceStr; // 单价
    private String taxRateStr; // 税率
    private String taxStr; // 税额
    private String loseUnitPriceStr; // 遗失单价(无税)
    private String loseUnitTaxPriceStr; // 遗失单价
    private String startDateStr; // 计划进场时间
    private String endDateStr; // 计划出场时间
    private String surplusCountStr; // 剩余数量
    private String quantitiesStr; // 工程量
    private String rentTaxMnyStr; // 租赁金额
    private String rentMnyStr; // 租赁金额(无税)
    private String rentTaxStr; // 租赁税额

    public String getCountStr() {
        return countStr;
    }

    public void setCountStr(String countStr) {
        this.countStr = countStr;
    }

    public String getUnitPriceStr() {
        return unitPriceStr;
    }

    public void setUnitPriceStr(String unitPriceStr) {
        this.unitPriceStr = unitPriceStr;
    }

    public String getUnitTaxPriceStr() {
        return unitTaxPriceStr;
    }

    public void setUnitTaxPriceStr(String unitTaxPriceStr) {
        this.unitTaxPriceStr = unitTaxPriceStr;
    }

    public String getTaxRateStr() {
        return taxRateStr;
    }

    public void setTaxRateStr(String taxRateStr) {
        this.taxRateStr = taxRateStr;
    }

    public String getTaxStr() {
        return taxStr;
    }

    public void setTaxStr(String taxStr) {
        this.taxStr = taxStr;
    }

    public String getLoseUnitPriceStr() {
        return loseUnitPriceStr;
    }

    public void setLoseUnitPriceStr(String loseUnitPriceStr) {
        this.loseUnitPriceStr = loseUnitPriceStr;
    }

    public String getLoseUnitTaxPriceStr() {
        return loseUnitTaxPriceStr;
    }

    public void setLoseUnitTaxPriceStr(String loseUnitTaxPriceStr) {
        this.loseUnitTaxPriceStr = loseUnitTaxPriceStr;
    }

    public String getStartDateStr() {
        return startDateStr;
    }

    public void setStartDateStr(String startDateStr) {
        this.startDateStr = startDateStr;
    }

    public String getEndDateStr() {
        return endDateStr;
    }

    public void setEndDateStr(String endDateStr) {
        this.endDateStr = endDateStr;
    }

    public String getSurplusCountStr() {
        return surplusCountStr;
    }

    public void setSurplusCountStr(String surplusCountStr) {
        this.surplusCountStr = surplusCountStr;
    }

    public String getQuantitiesStr() {
        return quantitiesStr;
    }

    public void setQuantitiesStr(String quantitiesStr) {
        this.quantitiesStr = quantitiesStr;
    }

    public String getRentTaxMnyStr() {
        return rentTaxMnyStr;
    }

    public void setRentTaxMnyStr(String rentTaxMnyStr) {
        this.rentTaxMnyStr = rentTaxMnyStr;
    }

    public String getRentMnyStr() {
        return rentMnyStr;
    }

    public void setRentMnyStr(String rentMnyStr) {
        this.rentMnyStr = rentMnyStr;
    }

    public String getRentTaxStr() {
        return rentTaxStr;
    }

    public void setRentTaxStr(String rentTaxStr) {
        this.rentTaxStr = rentTaxStr;
    }

    public BigDecimal getTargetCount() {
        return targetCount;
    }

    public void setTargetCount(BigDecimal targetCount) {
        this.targetCount = targetCount;
    }

    public BigDecimal getTargetUnitTaxPrice() {
        return targetUnitTaxPrice;
    }

    public void setTargetUnitTaxPrice(BigDecimal targetUnitTaxPrice) {
        this.targetUnitTaxPrice = targetUnitTaxPrice;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getLoseUnitPrice() {
        return loseUnitPrice;
    }

    public void setLoseUnitPrice(BigDecimal loseUnitPrice) {
        this.loseUnitPrice = loseUnitPrice;
    }

    public BigDecimal getLoseUnitTaxPrice() {
        return loseUnitTaxPrice;
    }

    public void setLoseUnitTaxPrice(BigDecimal loseUnitTaxPrice) {
        this.loseUnitTaxPrice = loseUnitTaxPrice;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getSurplusCount() {
        return surplusCount;
    }

    public void setSurplusCount(BigDecimal surplusCount) {
        this.surplusCount = surplusCount;
    }

    public BigDecimal getQuantities() {
        return quantities;
    }

    public void setQuantities(BigDecimal quantities) {
        this.quantities = quantities;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


}
