package com.ejianc.business.pro.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.rmat.vo.TotalPlanDetailChangeVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周转材总计划变更
 * 
 * @author generator
 * 
 */
public class TotalPlanChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long totalId; // 总计划主键
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String billCode; // 单据编号
    private BigDecimal estimatedMny; // 暂估金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private BigDecimal baseMny; // 初始版本金额
    private BigDecimal beforeChangeMny; // 变更前金额
    private Integer changeVersion; // 变更版本
    private String changeReason; // 变更原因
    private Integer billState; // 单据状态
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime; // 生效时间
    private String historyBillCode;



    public String getHistoryBillCode() {
        return historyBillCode;
    }

    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    private List<TotalPlanDetailChangeVO> detailList = new ArrayList<>(); // 周转材总计划-清单变更

    public Long getTotalId() {
        return totalId;
    }

    public void setTotalId(Long totalId) {
        this.totalId = totalId;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getEstimatedMny() {
        return estimatedMny;
    }

    public void setEstimatedMny(BigDecimal estimatedMny) {
        this.estimatedMny = estimatedMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<TotalPlanDetailChangeVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TotalPlanDetailChangeVO> detailList) {
        this.detailList = detailList;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
}
