/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.api.IAssistRmatInContractApi;
import com.ejianc.business.assist.rmat.enums.RmatPriceSourceTypeEnum;
import com.ejianc.business.outrmat.api.IAssistRmatOutContractApi;
import com.ejianc.business.pro.pricelib.bean.PriceContractEntity;
import com.ejianc.business.pro.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.pro.pricelib.enums.OutFlagEnum;
import com.ejianc.business.pro.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.pro.pricelib.service.IPriceContractService;
import com.ejianc.business.pro.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.pro.pricelib.utils.DateUtils;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.business.pro.pricelib.vo.PriceLibVO;
import com.ejianc.business.pro.pricelib.vo.PriceTrendVo;
import com.ejianc.business.pro.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceContractService")
public class PriceContractServiceImpl
extends BaseServiceImpl<PriceContractMapper, PriceContractEntity>
implements IPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private ISettleService settlementService;
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAssistRmatInContractApi assistRmatInContractApi;
    @Autowired
    private IAssistRmatOutContractApi assistRmatOutContractApi;

    @Override
    public void savePriceContractByTiming(Date date) {
        List contractEntityList;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            contractEntityList = ((PriceContractMapper)this.baseMapper).getContractListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            queryParam.getParams().put("rent_type", new Parameter("ne", (Object)1));
            contractEntityList = this.contractService.queryList(queryParam, false);
        }
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (CollectionUtils.isEmpty((Collection)contractEntityList)) {
            return;
        }
        List<Long> contractIdList = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<ContractDailyRentEntity> dailyRentList = ((PriceContractMapper)this.baseMapper).getContractDayDetailListByContractId(contractIdList);
        List<ContractMonthRentEntity> monthRentList = ((PriceContractMapper)this.baseMapper).getContractMonDetailListByContractId(contractIdList);
        List<ContractNumRentEntity> numRentList = ((PriceContractMapper)this.baseMapper).getContractNumDetailListByContractId(contractIdList);
        if (CollectionUtils.isEmpty(dailyRentList) && CollectionUtils.isEmpty(monthRentList) && CollectionUtils.isEmpty(numRentList)) {
            return;
        }
        ArrayList materialTypeIdList = new ArrayList();
        if (CollectionUtils.isNotEmpty(dailyRentList)) {
            materialTypeIdList.addAll(dailyRentList.stream().map(ContractDailyRentEntity::getMaterialTypeId).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(monthRentList)) {
            materialTypeIdList.addAll(monthRentList.stream().map(ContractMonthRentEntity::getMaterialTypeId).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(numRentList)) {
            materialTypeIdList.addAll(numRentList.stream().map(ContractNumRentEntity::getMaterialTypeId).distinct().collect(Collectors.toList()));
        }
        CommonResponse materialResponse = this.materialApi.queryCategoryListByIds(materialTypeIdList);
        Map<Object, Object> materialCategoryMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)materialResponse));
        if (materialResponse.isSuccess()) {
            List materialCategoryVOList = (List)materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        }
        List projectIdList = contractEntityList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter("in", contractIdList));
        settleParam.getParams().put("settle_type", new Parameter("eq", (Object)1));
        settleParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List settlementEntityList = this.settlementService.queryList(settleParam, false);
        Map<Object, Object> settlementDateMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settlementEntityList)) {
            settlementDateMap = settlementEntityList.stream().collect(Collectors.toMap(SettleEntity::getContractId, SettleEntity::getSettleDate, (key1, key2) -> key2));
        }
        Map<Long, List<ContractDailyRentEntity>> detailDayMap = dailyRentList.stream().collect(Collectors.groupingBy(ContractDailyRentEntity::getContractId));
        Map<Long, List<ContractMonthRentEntity>> detailMonMap = monthRentList.stream().collect(Collectors.groupingBy(ContractMonthRentEntity::getContractId));
        Map<Long, List<ContractNumRentEntity>> detailNumMap = numRentList.stream().collect(Collectors.groupingBy(ContractNumRentEntity::getContractId));
        ArrayList<PriceContractEntity> saveEntityList = new ArrayList<PriceContractEntity>();
        for (ContractEntity entity : contractEntityList) {
            PriceContractEntity priceContractEntity;
            List<ContractDailyRentEntity> dayDetailList = detailDayMap.get(entity.getId());
            List<ContractMonthRentEntity> monDetailList = detailMonMap.get(entity.getId());
            List<ContractNumRentEntity> numDetailList = detailNumMap.get(entity.getId());
            if (CollectionUtils.isEmpty(dayDetailList) && CollectionUtils.isEmpty(monDetailList) && CollectionUtils.isEmpty(numDetailList)) continue;
            if (CollectionUtils.isNotEmpty(dayDetailList)) {
                for (ContractDailyRentEntity contractDailyRentEntity : dayDetailList) {
                    if (contractDailyRentEntity.getMaterialId() == null) continue;
                    priceContractEntity = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                    priceContractEntity = this.ChangeContractDay(priceContractEntity, contractDailyRentEntity);
                    priceContractEntity.setRentCalculationType("0");
                    priceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                    priceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                    priceContractEntity.setSourceId(entity.getId());
                    priceContractEntity.setSourceType(RmatPriceSourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
                    priceContractEntity.setTargetResultId(entity.getTargetResultId());
                    priceContractEntity.setMaterialInnerCode((String)materialCategoryMap.get(contractDailyRentEntity.getMaterialTypeId()));
                    priceContractEntity.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                    saveEntityList.add(priceContractEntity);
                }
            }
            if (CollectionUtils.isNotEmpty(monDetailList)) {
                for (ContractMonthRentEntity contractMonthRentEntity : monDetailList) {
                    if (contractMonthRentEntity.getMaterialId() == null) continue;
                    priceContractEntity = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                    priceContractEntity = this.ChangeContractMon(priceContractEntity, contractMonthRentEntity);
                    priceContractEntity.setRentCalculationType("1");
                    priceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                    priceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                    priceContractEntity.setSourceId(entity.getId());
                    priceContractEntity.setSourceType(RmatPriceSourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
                    priceContractEntity.setTargetResultId(entity.getTargetResultId());
                    priceContractEntity.setMaterialInnerCode((String)materialCategoryMap.get(contractMonthRentEntity.getMaterialTypeId()));
                    priceContractEntity.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                    saveEntityList.add(priceContractEntity);
                }
            }
            if (!CollectionUtils.isNotEmpty(numDetailList)) continue;
            for (ContractNumRentEntity contractNumRentEntity : numDetailList) {
                if (contractNumRentEntity.getMaterialId() == null) continue;
                priceContractEntity = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                priceContractEntity = this.ChangeContractNum(priceContractEntity, contractNumRentEntity);
                priceContractEntity.setRentCalculationType("2");
                priceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceContractEntity.setSourceId(entity.getId());
                priceContractEntity.setSourceType(RmatPriceSourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                priceContractEntity.setMaterialInnerCode((String)materialCategoryMap.get(contractNumRentEntity.getMaterialTypeId()));
                priceContractEntity.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                saveEntityList.add(priceContractEntity);
            }
        }
        this.logger.info("\u83b7\u53d6\u8bbe\u5907\u516c\u53f8\u6570\u636e\u524d\u6570\u636e\u6761\u6570\uff1a" + saveEntityList.size());
        CommonResponse corpRentResponse = this.assistRmatInContractApi.getPriceContractDataByAssistRmatIn(date != null ? "1" : "0");
        this.logger.info("\u83b7\u53d6\u8f85\u6599\u5468\u8f6c\u6750\u79df\u5165\u5408\u540c\u6570\u636e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)corpRentResponse));
        if (corpRentResponse.isSuccess()) {
            List corpRentContractList = (List)corpRentResponse.getData();
            saveEntityList.addAll(BeanMapper.mapList((Iterable)corpRentContractList, PriceContractEntity.class));
        }
        CommonResponse corpOutResponse = this.assistRmatOutContractApi.getPriceContractDataByAssistRmatOut(date != null ? "1" : "0");
        this.logger.info("\u83b7\u53d6\u8f85\u6599\u5468\u8f6c\u6750\u79df\u51fa\u5408\u540c\u6570\u636e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)corpOutResponse));
        if (corpOutResponse.isSuccess()) {
            List corpOutContractList = (List)corpOutResponse.getData();
            saveEntityList.addAll(BeanMapper.mapList((Iterable)corpOutContractList, PriceContractEntity.class));
        }
        this.logger.info("\u83b7\u53d6\u8f85\u6599\u5468\u8f6c\u6750\u6570\u636e\u540e\u6570\u636e\u6761\u6570\uff1a" + saveEntityList.size());
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(PriceContractEntity::getSourceDetailId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceDetailId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(PriceContractEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveEntityList) {
                PriceContractEntity queryEntity = (PriceContractEntity)((Object)queryPriceMap.get(entity.getSourceDetailId()));
                if (queryEntity == null) continue;
                entity.setId(queryEntity.getId());
                entity.setOutFlag(queryEntity.getOutFlag());
                entity.setCreateTime(queryEntity.getCreateTime());
                entity.setCreateUserCode(queryEntity.getCreateUserCode());
            }
        }
        this.logger.info("\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(saveEntityList));
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove((Wrapper)wrapper, false);
        List list = saveEntityList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        this.logger.info("\u5220\u9664\u6570\u636eid\uff1a{}", (Object)JSONObject.toJSONString(list));
        if (CollectionUtils.isNotEmpty(list)) {
            super.removeByIds(list, false);
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString(priceLibList));
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceLibList.size());
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList;
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        List<Long> orgIdList;
        Date endDate;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate = checkMap.get("endDate"), orgIdList = this.queryOrgIdList(), param);
        if (CollectionUtils.isEmpty(priceLibList)) {
            throw new BusinessException("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return priceLibList.get(0);
    }

    @Override
    public List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId) {
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)materialTypeId)) {
            String[] materialTypeIdList = materialTypeId.split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            for (String str : materialTypeIdList) {
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("material_innerCode", new Parameter("like_right", (Object)str));
                c1.getComplexParams().add(c2);
            }
            queryParam.getComplexParams().add(c1);
        }
        return this.queryPriceLibListAll(startDate, endDate, null, queryParam);
    }

    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate", "desc");
            param.getOrderMap().put("contractMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            boolean targetType = vo.getTargetResultId() == null;
            String url = "/ejc-prormat-frontend/#/contract/contractMultiCards?id=" + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag() + "&performanceStatus=" + vo.getPerformanceStatus() + "&cardType=addCard";
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setContractUrl(url);
        }
        for (PriceContractVO vo : voList) {
            vo.setRentCalculationName(this.getRentTypeName(vo.getRentCalculationType()));
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = (PriceContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        super.saveOrUpdate((Object)entity, false);
    }

    private List<Long> queryOrgIdList() {
        CommonResponse orgIdListResponse = this.priceDepotPowerSetApi.queryOrgList(InvocationInfoProxy.getOrgId());
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\u5931\u8d25:" + orgIdListResponse.getMsg());
        }
        return (List)orgIdListResponse.getData();
    }

    private List<Long> getMyOrgList() {
        CommonResponse orgVOResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgVOResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            return orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private Map<String, Date> checkQueryParam(QueryParam param) {
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        if (!paramMap.containsKey("materialId")) {
            throw new BusinessException("\u67e5\u8be2\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Date> rtnMap = new HashMap<String, Date>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        HashMap<Long, PriceLibVO> map = new HashMap<Long, PriceLibVO>();
        this.queryPriceContractGroupByMaterialId(map, startDate, orgIdList, param);
        this.logger.info("\u67e5\u8be2\u5408\u540c\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        this.queryPriceGuide(map);
        this.logger.info("\u67e5\u8be2\u6307\u5bfc\u4ef7\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        ArrayList<PriceLibVO> priceLibList = new ArrayList<PriceLibVO>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
            priceLibList.sort(Comparator.comparing(PriceLibVO::getMaterialCode, Comparator.nullsLast(String::compareTo)));
        }
        this.logger.info("\u67e5\u8be2\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(priceLibList));
        return priceLibList;
    }

    private void queryPriceContractGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, List<Long> orgIdList, QueryParam param) {
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) {
            return;
        }
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceContractEntity entity : value) {
                num = num.add(entity.getContractNum() == null ? BigDecimal.ZERO : entity.getContractNum());
                mny = mny.add(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setMaterialInnerCode(priceContract.getMaterialInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setRentCalculationType(priceContract.getRentCalculationType());
            priceLibVO.setRentCalculationName(this.getRentTypeName(priceContract.getRentCalculationType()));
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
        }
    }

    public String getRentTypeName(String RentType) {
        if ("0".equals(RentType)) {
            return "\u65e5\u79df";
        }
        if ("1".equals(RentType)) {
            return "\u6708\u79df";
        }
        return "\u5de5\u7a0b\u91cf\u79df";
    }

    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList, QueryParam param) {
        QueryParam contractParam = new QueryParam();
        List fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("performance_status", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("performance_status", new Parameter("in", Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter("ge", (Object)startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        this.logger.info("\u67e5\u8be2\u5408\u540c\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)contractParam));
        return super.queryList(contractParam, false);
    }

    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, 4).subtract(BigDecimal.ONE).multiply(b);
    }

    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (!guideMap.containsKey(materialId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(materialId));
            BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
            BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }

    public PriceContractEntity ChangeContractDay(PriceContractEntity priceContractEntity, ContractDailyRentEntity detailEntity) {
        priceContractEntity.setSourceDetailId(detailEntity.getId());
        priceContractEntity.setMaterialId(detailEntity.getMaterialId());
        priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
        priceContractEntity.setMaterialName(detailEntity.getMaterialName());
        priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractEntity.setSpec(detailEntity.getSpec());
        priceContractEntity.setUnitId(detailEntity.getUnitId());
        priceContractEntity.setUnitName(detailEntity.getUnitName());
        priceContractEntity.setContractNum(detailEntity.getCount());
        priceContractEntity.setContractPrice(detailEntity.getUnitPrice());
        priceContractEntity.setContractMny(detailEntity.getRentMny());
        priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
        priceContractEntity.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractEntity.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractEntity.setMemo(detailEntity.getMemo());
        priceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
        priceContractEntity.setId(null);
        priceContractEntity.setCreateTime(null);
        priceContractEntity.setCreateUserCode(null);
        priceContractEntity.setUpdateTime(null);
        priceContractEntity.setUpdateUserCode(null);
        priceContractEntity.setDr(detailEntity.getDr());
        return priceContractEntity;
    }

    public PriceContractEntity ChangeContractMon(PriceContractEntity priceContractEntity, ContractMonthRentEntity detailEntity) {
        priceContractEntity.setSourceDetailId(detailEntity.getId());
        priceContractEntity.setMaterialId(detailEntity.getMaterialId());
        priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
        priceContractEntity.setMaterialName(detailEntity.getMaterialName());
        priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractEntity.setSpec(detailEntity.getSpec());
        priceContractEntity.setUnitId(detailEntity.getUnitId());
        priceContractEntity.setUnitName(detailEntity.getUnitName());
        priceContractEntity.setContractNum(detailEntity.getCount());
        priceContractEntity.setContractPrice(detailEntity.getUnitPrice());
        priceContractEntity.setContractMny(detailEntity.getRentMny());
        priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
        priceContractEntity.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractEntity.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractEntity.setMemo(detailEntity.getMemo());
        priceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
        priceContractEntity.setId(null);
        priceContractEntity.setCreateTime(null);
        priceContractEntity.setCreateUserCode(null);
        priceContractEntity.setUpdateTime(null);
        priceContractEntity.setUpdateUserCode(null);
        priceContractEntity.setDr(detailEntity.getDr());
        return priceContractEntity;
    }

    public PriceContractEntity ChangeContractNum(PriceContractEntity priceContractEntity, ContractNumRentEntity detailEntity) {
        priceContractEntity.setSourceDetailId(detailEntity.getId());
        priceContractEntity.setMaterialId(detailEntity.getMaterialId());
        priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
        priceContractEntity.setMaterialName(detailEntity.getMaterialName());
        priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractEntity.setSpec(detailEntity.getSpec());
        priceContractEntity.setUnitId(detailEntity.getUnitId());
        priceContractEntity.setUnitName(detailEntity.getUnitName());
        priceContractEntity.setContractNum(detailEntity.getCount());
        priceContractEntity.setContractPrice(detailEntity.getUnitPrice());
        priceContractEntity.setContractMny(detailEntity.getRentMny());
        priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
        priceContractEntity.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractEntity.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractEntity.setMemo(detailEntity.getMemo());
        priceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
        priceContractEntity.setId(null);
        priceContractEntity.setCreateTime(null);
        priceContractEntity.setCreateUserCode(null);
        priceContractEntity.setUpdateTime(null);
        priceContractEntity.setUpdateUserCode(null);
        priceContractEntity.setDr(detailEntity.getDr());
        return priceContractEntity;
    }
}

