/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.outrmat.api.IOutRmatApi;
import com.ejianc.business.outrmat.contract.enums.StatusTypeEnum;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.pro.rmat.bean.CheckDetailEntity;
import com.ejianc.business.pro.rmat.bean.CheckEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.LoseEntity;
import com.ejianc.business.pro.rmat.bean.OrderDetailEntity;
import com.ejianc.business.pro.rmat.bean.OrderEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateEntity;
import com.ejianc.business.pro.rmat.bean.RestituteEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.bean.StartEntity;
import com.ejianc.business.pro.rmat.bean.StopEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.business.pro.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.pro.rmat.mapper.OrderMapper;
import com.ejianc.business.pro.rmat.service.ICheckService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ILoseService;
import com.ejianc.business.pro.rmat.service.IOrderService;
import com.ejianc.business.pro.rmat.service.IRentCalculateService;
import com.ejianc.business.pro.rmat.service.IRestituteService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.service.IStartService;
import com.ejianc.business.pro.rmat.service.IStopService;
import com.ejianc.business.pro.rmat.service.impl.CheckServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.LoseServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.OrderServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.RentCalculateServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.RestituteServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.SettleBpmServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.SettleServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.StartServiceImpl;
import com.ejianc.business.pro.rmat.service.impl.StopServiceImpl;
import com.ejianc.business.pro.rmat.utils.EntityUtil;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prormat/"})
public class ReceiptsApi {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService service;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IStartService startService;
    @Autowired
    private IStopService stopService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private ILoseService loseService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private SettleBpmServiceImpl settleBpmService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private OrderMapper mapper;
    @Autowired
    private IOutRmatApi outRmatApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IRentCalculateService rentCalculateService;

    @PostMapping(value={"/receiptsSync"})
    public CommonResponse<String> receiptsSync(@RequestBody JSONObject json, @RequestParam(value="type") String type) {
        String msg = "\u5355\u636e\u5df2\u7ecf\u8fdb\u884c\u8fc7\u540c\u6b65\u64cd\u4f5c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
        switch (ReceiptsEnum.getEnumByName((String)type)) {
            case \u79df\u8d41\u8ba2\u5355: {
                this.orderSync(json);
                break;
            }
            case \u9a8c\u6536\u5355: {
                OutRmatDeliveryVO orderVO = (OutRmatDeliveryVO)JSON.parseObject((String)json.toJSONString(), OutRmatDeliveryVO.class);
                CheckEntity checkEntity = (CheckEntity)((Object)BeanMapper.map((Object)orderVO, CheckEntity.class));
                checkEntity.setCheckDetailList(BeanMapper.mapList((Iterable)orderVO.getOutRmatDeliveryDetailList(), CheckDetailEntity.class));
                CheckEntity data = (CheckEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)checkEntity.getId(), CheckServiceImpl.class));
                if (null != data) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.checkService.delById(checkEntity.getId());
                }
                checkEntity.setRmatDate(orderVO.getRentDate());
                checkEntity.setEmployeeId(orderVO.getProxyEmployeeId());
                checkEntity.setEmployeeName(orderVO.getProxyEmployeeName());
                checkEntity.setCheckDate(orderVO.getOutstoreDate());
                checkEntity.setSupplementRecord("0");
                checkEntity.setCheckSource("2");
                checkEntity.setCheckSourceName("\u8f85\u6599\u4e2d\u5fc3");
                checkEntity.getCheckDetailList().forEach(e -> orderVO.getOutRmatDeliveryDetailList().forEach(t -> {
                    if (e.getId().equals(t.getId())) {
                        e.setUnitId(t.getRentUnitId());
                        e.setUnitName(t.getRentUnitName());
                        e.setCheckId(t.getDeliveryId());
                        e.setDeliverNumsSum(t.getRentNum());
                        e.setCheckNumsSum(t.getRentNum());
                        e.setRmatDate(t.getRentDetailDate());
                    }
                }));
                this.checkService.saveOrUpdate((Object)checkEntity, false);
                break;
            }
            case \u542f\u7528\u5355: {
                StartEntity startEntity = (StartEntity)((Object)JSON.parseObject((String)json.toJSONString(), StartEntity.class));
                StartEntity startData = (StartEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)startEntity.getId(), StartServiceImpl.class));
                if (null != startData) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.startService.delById(startEntity.getId());
                }
                this.startService.saveOrUpdate((Object)startEntity, false);
                break;
            }
            case \u505c\u7528\u5355: {
                StopEntity stopEntity = (StopEntity)((Object)JSON.parseObject((String)json.toJSONString(), StopEntity.class));
                StopEntity stopData = (StopEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)stopEntity.getId(), StopServiceImpl.class));
                if (null != stopData) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.stopService.delById(stopEntity.getId());
                }
                this.stopService.saveOrUpdate((Object)stopEntity, false);
                break;
            }
            case \u9000\u8d54\u5355: {
                RestituteEntity restituteEntity = (RestituteEntity)((Object)JSON.parseObject((String)json.toJSONString(), RestituteEntity.class));
                RestituteEntity resdata = (RestituteEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)restituteEntity.getId(), RestituteServiceImpl.class));
                if (null != resdata) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.restituteService.delById(restituteEntity.getId());
                }
                this.restituteService.saveOrUpdate((Object)restituteEntity, false);
                break;
            }
            case \u9057\u5931\u5355: {
                LoseEntity loseEntity = (LoseEntity)((Object)JSON.parseObject((String)json.toJSONString(), LoseEntity.class));
                LoseEntity loseData = (LoseEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)loseEntity.getId(), LoseServiceImpl.class));
                if (null != loseData) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.loseService.delById(loseEntity.getId());
                }
                this.loseService.saveOrUpdate((Object)loseEntity, false);
                break;
            }
            case \u79df\u91d1\u8ba1\u7b97\u5355: {
                RentCalculateEntity rentCalculateEntity = (RentCalculateEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentCalculateEntity.class));
                this.logger.info("\u63a5\u6536\u5230\u79df\u91d1\u8ba1\u7b97\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)rentCalculateEntity)));
                RentCalculateEntity rentCalculateData = (RentCalculateEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)rentCalculateEntity.getId(), RentCalculateServiceImpl.class));
                if (null != rentCalculateData) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.rentCalculateService.delById(rentCalculateEntity.getId());
                    return CommonResponse.error((String)msg);
                }
                this.rentCalculateService.saveOrUpdate((Object)rentCalculateEntity, false);
                this.logger.info("\u79df\u91d1\u8ba1\u7b97\u63a8\u9001\u5b9e\u9645\u6210\u672c---");
                this.rentCalculateService.costPush(rentCalculateEntity);
                break;
            }
            default: {
                SettleEntity settleEntity = (SettleEntity)((Object)JSON.parseObject((String)json.toJSONString(), SettleEntity.class));
                SettleEntity settleData = (SettleEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)settleEntity.getId(), SettleServiceImpl.class));
                if (null != settleData) {
                    this.logger.info("\u5df2\u6709\u6570\u636e\uff01");
                    this.settleService.delById(settleEntity.getId());
                }
                UserContext userContext = this.sessionManager.getUserContext();
                settleEntity.setCommitDate(new Date());
                settleEntity.setCommitUserCode(userContext.getUserCode());
                settleEntity.setCommitUserName(userContext.getUserName());
                settleEntity.setCostTaxMny(ComputeUtil.safeSub((BigDecimal)settleEntity.getSettleTaxMny(), (BigDecimal)settleEntity.getRentTaxMny()));
                settleEntity.setCostMny(ComputeUtil.safeSub((BigDecimal)settleEntity.getSettleMny(), (BigDecimal)settleEntity.getRentMny()));
                settleEntity.setCostTax(ComputeUtil.safeSub((BigDecimal)settleEntity.getCostTaxMny(), (BigDecimal)settleEntity.getCostMny()));
                settleEntity.setProportionFlag("0");
                Boolean poolRes = this.settleService.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class));
                if (Boolean.TRUE.equals(poolRes)) {
                    settleEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    settleEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
                Boolean poolPushResult = this.settleService.pushContract((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode(), true);
                if (Boolean.TRUE.equals(poolPushResult)) {
                    settleEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    settleEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
                this.settleService.saveOrUpdate((Object)settleEntity, false);
                if (Objects.equals(settleEntity.getSettleType(), "1")) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.set(ContractEntity::getPerformanceStatus, (Object)PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                    updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
                    this.service.update((Wrapper)updateWrapper);
                    ExecutionVO executionVO = this.settleService.targetCost(settleEntity);
                    CommonResponse response = this.executionApi.aggPush(executionVO);
                    if (!response.isSuccess()) {
                        this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                        throw new BusinessException(response.getMsg());
                    }
                }
                this.logger.info("\u63a8\u9001\u5b9e\u9645\u6210\u672c---");
                this.settleService.costPush(settleEntity);
                this.settleBpmService.writeSettleFlag(settleEntity, 1);
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"/delReceipts"})
    public CommonResponse<String> delReceipts(@RequestParam(value="id") Long id, @RequestParam(value="type") String type) {
        String msg = "\u64cd\u4f5c\u5931\u8d25,\u672a\u67e5\u5230\u5355\u636e!";
        switch (ReceiptsEnum.getEnumByName((String)type)) {
            case \u9a8c\u6536\u5355: {
                CheckEntity data = (CheckEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, CheckServiceImpl.class));
                if (null == data) break;
                this.checkService.delById(id);
                break;
            }
            case \u542f\u7528\u5355: {
                StartEntity startData = (StartEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, StartServiceImpl.class));
                if (null == startData) break;
                this.startService.delById(id);
                break;
            }
            case \u505c\u7528\u5355: {
                StopEntity stopData = (StopEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, StopServiceImpl.class));
                if (null == stopData) break;
                this.stopService.delById(id);
                break;
            }
            case \u9000\u8d54\u5355: {
                RestituteEntity resData = (RestituteEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, RestituteServiceImpl.class));
                if (null == resData) break;
                this.restituteService.delById(id);
                break;
            }
            case \u9057\u5931\u5355: {
                LoseEntity loseData = (LoseEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, LoseServiceImpl.class));
                if (null == loseData) break;
                this.loseService.delById(id);
                break;
            }
            case \u79df\u91d1\u8ba1\u7b97\u5355: {
                RentCalculateEntity rentCalculateData = (RentCalculateEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, RentCalculateServiceImpl.class));
                if (null == rentCalculateData) break;
                this.rentCalculateService.pullCost(id);
                this.logger.info("\u5220\u9664\u79df\u91d1\u8ba1\u7b97\u5355---");
                this.rentCalculateService.delById(id);
                break;
            }
            default: {
                SettleEntity settleData = (SettleEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)id, SettleServiceImpl.class));
                if (null == settleData) break;
                Boolean unPushRes = this.settleService.delSettleFromPool(settleData.getId());
                if (!Boolean.TRUE.equals(unPushRes)) {
                    throw new BusinessException("\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25!");
                }
                settleData.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(ContractEntity::getPerformanceStatus, (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                updateWrapper.eq(BaseEntity::getId, (Object)settleData.getContractId());
                this.service.update((Wrapper)updateWrapper);
                Boolean poolPushResult = this.settleService.pushContract((SettleVO)BeanMapper.map((Object)((Object)settleData), SettleVO.class), UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode(), false);
                if (Boolean.FALSE.equals(poolPushResult)) {
                    throw new BusinessException("\u7ed3\u7b97\u5355\u66f4\u65b0\u5408\u540c\u6c60\u5931\u8d25!");
                }
                this.settleBpmService.writeSettleFlag(settleData, 0);
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO = this.settleService.targetCost(settleData);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
                }
                this.logger.info("\u5220\u9664\u5b9e\u9645\u6210\u672c---");
                this.settleService.pullCost(settleData.getId());
                this.settleService.delById(id);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f!");
    }

    private void orderSync(JSONObject json) {
        OrderEntity orderEntity = (OrderEntity)((Object)JSON.parseObject((String)json.toJSONString(), OrderEntity.class));
        OrderEntity orderData = (OrderEntity)((Object)EntityUtil.selectOneService((String)"id", (Object)orderEntity.getId(), OrderServiceImpl.class));
        if (null != orderData) {
            List<OrderDetailEntity> list = orderEntity.getOrderDetailList();
            if ("1".equals(orderEntity.getReceiveState()) || "2".equals(orderEntity.getReceiveState())) {
                orderData.setReceiveState(orderEntity.getReceiveState());
                if (CollectionUtils.isNotEmpty(orderData.getOrderDetailList())) {
                    Map collect = list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (k1, k2) -> k2));
                    for (OrderDetailEntity detailEntity : orderData.getOrderDetailList()) {
                        if (collect.get(detailEntity.getId()) == null) continue;
                        OrderDetailEntity detail = (OrderDetailEntity)((Object)collect.get(detailEntity.getId()));
                        detailEntity.setReceiveNumsSum(detail.getReceiveNumsSum());
                    }
                }
            } else {
                orderData.setDenialReason(orderEntity.getDenialReason());
                orderData.setReceiveState(orderEntity.getReceiveState());
            }
            this.orderService.saveOrUpdate((Object)orderData, false);
        }
    }

    @PostMapping(value={"/orderChangeStatus"})
    public CommonResponse<String> orderChangeStatus(@RequestBody JSONArray jsonArray) {
        List list = jsonArray.toJavaList(OutRmatOrderVO.class);
        this.mapper.updateBatch(list);
        ArrayList<OutRmatOrderDetailVO> outList = new ArrayList<OutRmatOrderDetailVO>();
        for (OutRmatOrderVO orderVO : list) {
            outList.addAll(orderVO.getOrderDetailList());
        }
        this.mapper.updateBatchByDetail(outList);
        return CommonResponse.success((String)"\u56de\u5199\u6210\u529f");
    }

    @GetMapping(value={"/writeBackSign"})
    public CommonResponse<String> writeBackSign(@RequestParam(value="id") String id, @RequestParam(value="type") String type) {
        CommonResponse userResp = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!userResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237id-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)InvocationInfoProxy.getUserid(), (Object)userResp.getMsg());
            throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25!");
        }
        UserVO user = (UserVO)userResp.getData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billId", id);
        map.put("supOperatorName", user.getUserName());
        map.put("supOperatorPhone", user.getUserMobile());
        map.put("supOperatorUserCode", user.getUserCode());
        map.put("supOperateTime", Long.toString(System.currentTimeMillis()));
        Boolean flag = this.outRmatApi.updateBillSupSignSyncInfo(map, type).isSuccess();
        if (Boolean.FALSE.equals(flag)) {
            return CommonResponse.error((String)"\u56de\u5199\u5931\u8d25!");
        }
        switch (ReceiptsEnum.getEnumBySourceName((String)type)) {
            case \u9a8c\u6536\u5355: {
                CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById((Serializable)((Object)id)));
                entity.setSupOperateTime(new Date());
                entity.setSupOperatorPhone(user.getUserMobile());
                entity.setSupOperatorName(user.getUserName());
                entity.setSupOperatorUserCode(user.getUserCode());
                entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.checkService.saveOrUpdate((Object)entity, false);
                break;
            }
            case \u542f\u7528\u5355: {
                StartEntity startEntity = (StartEntity)((Object)this.startService.selectById((Serializable)((Object)id)));
                startEntity.setSupOperateTime(new Date());
                startEntity.setSupOperatorPhone(user.getUserMobile());
                startEntity.setSupOperatorName(user.getUserName());
                startEntity.setSupOperatorUserCode(user.getUserCode());
                startEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.startService.saveOrUpdate((Object)startEntity, false);
                break;
            }
            case \u505c\u7528\u5355: {
                StopEntity stopEntity = (StopEntity)((Object)this.stopService.selectById((Serializable)((Object)id)));
                stopEntity.setSupOperateTime(new Date());
                stopEntity.setSupOperatorPhone(user.getUserMobile());
                stopEntity.setSupOperatorName(user.getUserName());
                stopEntity.setSupOperatorUserCode(user.getUserCode());
                stopEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.stopService.saveOrUpdate((Object)stopEntity, false);
                break;
            }
            case \u9000\u8d54\u5355: {
                RestituteEntity restituteEntity = (RestituteEntity)((Object)this.restituteService.selectById((Serializable)((Object)id)));
                restituteEntity.setSupOperateTime(new Date());
                restituteEntity.setSupOperatorPhone(user.getUserMobile());
                restituteEntity.setSupOperatorName(user.getUserName());
                restituteEntity.setSupOperatorUserCode(user.getUserCode());
                restituteEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.restituteService.saveOrUpdate((Object)restituteEntity, false);
                break;
            }
            case \u9057\u5931\u5355: {
                LoseEntity loseEntity = (LoseEntity)((Object)this.loseService.selectById((Serializable)((Object)id)));
                loseEntity.setSupOperateTime(new Date());
                loseEntity.setSupOperatorPhone(user.getUserMobile());
                loseEntity.setSupOperatorName(user.getUserName());
                loseEntity.setSupOperatorUserCode(user.getUserCode());
                loseEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.loseService.saveOrUpdate((Object)loseEntity, false);
                break;
            }
            default: {
                SettleEntity settleEntity = (SettleEntity)((Object)this.settleService.selectById((Serializable)((Object)id)));
                settleEntity.setSupOperateTime(new Date());
                settleEntity.setSupOperatorPhone(user.getUserMobile());
                settleEntity.setSupOperatorName(user.getUserName());
                settleEntity.setSupOperatorUserCode(user.getUserCode());
                settleEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.settleService.saveOrUpdate((Object)settleEntity, false);
            }
        }
        this.signSync(id, ReceiptsEnum.getEnumBySourceName((String)type).getCode(), ReceiptsEnum.getEnumBySourceName((String)type).getFileType(), StatusTypeEnum.getEnumByName((String)type).getCode(), StatusTypeEnum.getEnumByName((String)type).getFileType());
        return CommonResponse.success((String)"\u56de\u5199\u6210\u529f!");
    }

    private void signSync(String id, String sourceBillType, String sourceBillSourceType, String targetBillType, String targetBillSourceType) {
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(id, sourceBillType, sourceBillSourceType, id, targetBillType, targetBillSourceType);
        if (!response.isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5355\u636e\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }
}

