/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.ownrmat.bean.HandleDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.HandleEntity;
import com.ejianc.business.pro.ownrmat.mapper.HandleMapper;
import com.ejianc.business.pro.ownrmat.service.IHandleService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.vo.HandleVO;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="handleService")
public class HandleServiceImpl
extends BaseServiceImpl<HandleMapper, HandleEntity>
implements IHandleService {
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IStoreManageApi storeManageApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRO_RMAT_HANDLE";
    @Autowired
    private IValidateService validateService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_NAME = "\u5468\u8f6c\u6750\u5904\u7f6e";

    @Override
    public CommonResponse<HandleVO> saveOrUpdate(HandleVO handleVO) {
        this.validateService.validateProject(handleVO.getProjectId(), BILL_NAME, handleVO.getId(), "\u4fdd\u5b58");
        this.validateTime(handleVO, "\u4fdd\u5b58");
        HandleEntity entity = (HandleEntity)((Object)BeanMapper.map((Object)handleVO, HandleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)handleVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ArrayList<HandleDetailEntity> subList = new ArrayList<HandleDetailEntity>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        String names = "";
        for (HandleDetailEntity detailEntity : handleSubList) {
            if (detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0) {
                subList.add(detailEntity);
            }
            names = names + detailEntity.getMaterialCategoryName() + ",";
        }
        if (handleSubList.size() > 0) {
            names = names.substring(0, names.length() - 1);
        }
        entity.setMaterialTypes(names);
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        entity.setStoreId(entity.getProjectId());
        super.saveOrUpdate((Object)entity, false);
        if (handleVO.getHandleSubList().size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(handleVO.getProjectId());
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            ArrayList flowVOS = new ArrayList();
            handleVO.getHandleSubList().forEach(t -> {
                if ("del".equals(t.getRowState())) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)0);
                    flowVO.setStoreId(handleVO.getStoreId());
                    flowVO.setStoreName(handleVO.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(handleVO.getEmployeeId());
                    flowVO.setEmployeeName(handleVO.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialSpec(t.getSpec());
                    flowVO.setMaterialUnitId(t.getUnit());
                    flowVO.setMaterialUnitName(t.getUnitName());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getHandleTaxPrice());
                    flowVO.setPrice(t.getHandlePrice());
                    flowVO.setNum(t.getHandleNum());
                    flowVO.setTaxMny(t.getHandleTaxMny());
                    flowVO.setMny(t.getHandleMny());
                    flowVO.setTax(t.getTax());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getHandleDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getHandleReason());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                }
            });
            entity.getHandleSubList().forEach(t -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnit());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getHandleTaxPrice());
                flowVO.setPrice(t.getHandlePrice());
                flowVO.setNum(t.getHandleNum());
                flowVO.setTaxMny(t.getHandleTaxMny());
                flowVO.setMny(t.getHandleMny());
                flowVO.setTax(t.getTax());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillRemark(entity.getHandleReason());
                flowVO.setPurchasePrice(t.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            this.logger.debug("\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        HandleVO vo = (HandleVO)BeanMapper.map((Object)((Object)entity), HandleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public String validateTime(HandleVO handleVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", handleVO.getProjectId());
        if (handleVO.getId() != null) {
            params.put("billType", "\u9057\u5931\u5355");
            params.put("billId", handleVO.getId());
        }
        Date lastDate = this.validateService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.validateService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)handleVO.getHandleDate(), (Date)lastDate, maxTimeMap, (Date)handleVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)handleVO.getHandleDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.handleInOut(ids, false);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids, Boolean outEffectiveON) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            HandleEntity entity = (HandleEntity)((Object)super.selectById((Serializable)item));
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t : handleSubList) {
                if (t.getHandleNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                checkFlag = true;
                break;
            }
            if (!checkFlag.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<HandleVO> pushCost(HandleVO vo) {
        HandleEntity entity = (HandleEntity)((Object)((HandleMapper)this.baseMapper).selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)vo.getHandleSubList())) {
            List dailyList = BeanMapper.mapList((Iterable)vo.getHandleSubList(), HandleDetailEntity.class);
            entity.setHandleSubList(dailyList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), HandleVO.class));
    }

    @Override
    public void costPush(HandleEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<HandleDetailEntity> dailyList = entity.getHandleSubList();
        String relationFlag = "1";
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (HandleDetailEntity detail : dailyList) {
                if (null != detail.getSubjectId() && null != detail.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isEmpty(dailyList)) {
            relationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)relationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = entity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(relationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(relationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-{}Id---{}", (Object)BILL_NAME, (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(relationFlag)) {
            this.saveCost(entity);
        }
    }

    private void saveCost(HandleEntity entity) {
        ArrayList<CostDetailVO> costVOList = new ArrayList<CostDetailVO>();
        List<HandleDetailEntity> dailyList = entity.getHandleSubList();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (HandleDetailEntity detail : dailyList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getHandleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getHandleSubTaxMny());
                costVO.setHappenMny(detail.getHandleSubMny());
                costVO.setHappenDate(entity.getHandleDate());
                costVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costVO.setSourceType(BILL_CODE);
                costVO.setSourceTabType("PRO_RMAT_HANDLE_DETAIL");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(BILL_NAME);
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/storeHandle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        if (ListUtil.isNotEmpty(costVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costVOList));
            CommonResponse response = this.costDetailApi.saveSubject(costVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }
}

