/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.rmat.bean.DeliveryEntity;
import com.ejianc.business.pro.rmat.service.IDeliveryService;
import com.ejianc.business.pro.rmat.utils.EntityUtil;
import com.ejianc.business.pro.rmat.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"delivery"})
public class DeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDeliveryService service;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"billSync"})
    @ResponseBody
    public CommonResponse<String> billSync(HttpServletRequest request) {
        String msg = this.service.saveSyncBill(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"billDel"})
    @ResponseBody
    public CommonResponse<String> billDel(@RequestBody DeliveryVO vo) {
        DeliveryEntity entity = (DeliveryEntity)((Object)EntityUtil.selectOne((String)"source_id", (Object)vo.getSourceId(), DeliveryEntity.class));
        if (entity == null) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u67e5\u5230\u8be5\u5355\u636e\uff01");
        }
        if (!entity.getSourceSystemId().equals(entity.getSourceSystemId())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u6765\u6e90\u7cfb\u7edf\u4fe1\u606f\u4e0d\u5339\u914d\uff01");
        }
        String msg = this.service.billDel(entity);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.service.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("firstPartyName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("orgId") == null || ((Parameter)param.getParams().get("orgId")).getValue() == null) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/closeDelivery"})
    @ResponseBody
    public CommonResponse<String> closeDelivery(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.service.selectById(id));
        if ("2".equals(entity.getAcceptanceState())) {
            return CommonResponse.error((String)"\u9001\u8d27\u5355\u5df2\u5168\u90e8\u9a8c\u6536\uff0c\u4e0d\u80fd\u5173\u95ed\uff01");
        }
        String msg = this.service.changeCloseState(entity);
        if (null != msg) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u9001\u8d27\u5355\u5173\u95ed\u6210\u529f\uff01");
    }
}

