/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.LoseEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateEntity;
import com.ejianc.business.pro.rmat.bean.RestituteEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.bean.SettleLeaseEntity;
import com.ejianc.business.pro.rmat.bean.SettleLoseEntity;
import com.ejianc.business.pro.rmat.bean.SettleRepairEntity;
import com.ejianc.business.pro.rmat.bean.SettleScrapEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ILoseService;
import com.ejianc.business.pro.rmat.service.IRentCalculateService;
import com.ejianc.business.pro.rmat.service.IRestituteService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentCalculateService calculateService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private ILoseService loseService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IExecutionApi executionApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Boolean poolPushResult;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(SettleEntity::getCommitDate, (Object)new Date());
        wrapper.set(SettleEntity::getCommitUserCode, (Object)userContext.getUserCode());
        wrapper.set(SettleEntity::getCommitUserName, (Object)userContext.getUserName());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        if (Objects.equals(settleEntity.getSettleType(), "1")) {
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
        }
        this.writeSettleFlag(settleEntity, 1);
        Boolean poolRes = this.service.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class));
        wrapper.set(SettleEntity::getPushPoolFlag, (Object)(poolRes != false ? BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus() : BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus()));
        if (Objects.equals(SettleEnum.\u6700\u7ec8\u7ed3\u7b97.getCode(), settleEntity.getSettleType())) {
            ExecutionVO executionVO = this.service.targetCost(settleEntity);
            CommonResponse response = this.executionApi.aggPush(executionVO);
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
            if (!response.isSuccess()) {
                this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        if ((poolPushResult = this.service.pushContract((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode(), true)).booleanValue()) {
            wrapper.eq(SettleEntity::getPushPoolFlag, (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            wrapper.eq(SettleEntity::getPushPoolFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        Boolean pushResult = this.service.pushBillToSupCenter(settleEntity);
        if (pushResult.booleanValue()) {
            wrapper.set(SettleEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u5e94\u5546\u670d\u52a1\u5931\u8d25", (Object)BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getName(), (Object)billId);
            wrapper.set(SettleEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.logger.info("\u63a8\u9001\u6210\u672c---");
        this.service.costPush(settleEntity);
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)entity.getContractId());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)wrapper);
        long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
        if (count > 0L) {
            throw new BusinessException("\u5f53\u524d\u5355\u636e\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        if (ListUtil.isNotEmpty((List)list) && !Objects.equals(((SettleEntity)((Object)list.get(0))).getId(), billId)) {
            throw new BusinessException("\u53ea\u80fd\u64a4\u56de/\u5f03\u5ba1\u6700\u65b0\u4e00\u671f\u7684\u7ed3\u7b97\u5355\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getPerformanceStatus, (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        this.writeSettleFlag(entity, 0);
        boolean unPushRes = this.service.delSettleFromPool(entity.getId());
        if (unPushRes) {
            entity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355-{}\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff01", (Object)entity);
        }
        Boolean poolPushResult = this.service.pushContract((SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class), UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode(), false);
        if (poolPushResult.booleanValue()) {
            entity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            entity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.service.targetCost(entity);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            boolean pushResult = this.service.delPushBill(entity);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u4f5c\u5e9f\u534f\u540c\u670d\u52a1\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.logger.info("\u5220\u9664\u6210\u672c---");
        this.service.pullCost(billId);
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public void writeSettleFlag(SettleEntity entity, Integer settleFlag) {
        List<SettleScrapEntity> scrapList;
        ArrayList leaseIdsList = new ArrayList();
        List<SettleLeaseEntity> leaseList = entity.getLeaseList();
        if (ListUtil.isNotEmpty(leaseList)) {
            leaseIdsList.addAll(leaseList.stream().map(SettleLeaseEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(leaseIdsList)) {
            LambdaUpdateWrapper leaseWrapper = new LambdaUpdateWrapper();
            leaseWrapper.set(RentCalculateEntity::getSettleFlag, (Object)settleFlag);
            leaseWrapper.in(BaseEntity::getId, leaseIdsList);
            this.calculateService.update((Wrapper)leaseWrapper);
        }
        ArrayList restituteIdsList = new ArrayList();
        List<SettleRepairEntity> repairList = entity.getRepairList();
        if (ListUtil.isNotEmpty(repairList)) {
            restituteIdsList.addAll(repairList.stream().map(SettleRepairEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(scrapList = entity.getScrapList())) {
            restituteIdsList.addAll(scrapList.stream().map(SettleScrapEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(restituteIdsList)) {
            LambdaUpdateWrapper restituteWrapper = new LambdaUpdateWrapper();
            restituteWrapper.set(RestituteEntity::getSettleFlag, (Object)settleFlag);
            restituteWrapper.in(BaseEntity::getId, restituteIdsList);
            this.restituteService.update((Wrapper)restituteWrapper);
        }
        List<SettleLoseEntity> loseList = entity.getLoseList();
        ArrayList loseIdsList = new ArrayList();
        if (ListUtil.isNotEmpty(loseList)) {
            loseIdsList.addAll(loseList.stream().map(SettleLoseEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(loseIdsList)) {
            LambdaUpdateWrapper loseWrapper = new LambdaUpdateWrapper();
            loseWrapper.set(LoseEntity::getSettleFlag, (Object)settleFlag);
            loseWrapper.in(BaseEntity::getId, loseIdsList);
            this.loseService.update((Wrapper)loseWrapper);
        }
    }
}

