/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.LoseEntity;
import com.ejianc.business.pro.rmat.bean.RentCalculateEntity;
import com.ejianc.business.pro.rmat.bean.RestituteEntity;
import com.ejianc.business.pro.rmat.bean.SettleDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.bean.SettleLoseEntity;
import com.ejianc.business.pro.rmat.bean.SettleMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.SettleNumRentEntity;
import com.ejianc.business.pro.rmat.bean.SettleOtherEntity;
import com.ejianc.business.pro.rmat.bean.SettleRepairEntity;
import com.ejianc.business.pro.rmat.bean.SettleScrapEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.ContractFilingTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.mapper.SettleMapper;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ILoseService;
import com.ejianc.business.pro.rmat.service.IRentCalculateService;
import com.ejianc.business.pro.rmat.service.IRestituteService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.vo.LoseVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateVO;
import com.ejianc.business.pro.rmat.vo.RestituteVO;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.pro.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    private static final String PRO_RMAT_SETTLE = "PRO_RMAT_SETTLE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OPERATE = "SETTLE_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/settle/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/settle/billDel";
    private static final String CHECK_PARAM_CODE_GC = "P-8916ww47";
    private static final String CHECK_PARAM_CODE_ZZ = "P-75u0y60160";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentCalculateService calculateService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private ILoseService loseService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {
        int compareDate;
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)PRO_RMAT_SETTLE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSupplierSignStatus(0);
        }
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        this.validateContract(entity.getContractId(), entity.getId());
        SettleVO lastVo = this.queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null && (compareDate = DateUtil.compareDate((Date)lastVo.getSettleDate(), (Date)entity.getSettleDate())) > 0) {
            throw new BusinessException("\u672c\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate((Date)entity.getSettleDate()) + "\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate((Date)lastVo.getSettleDate()));
        }
        entity.setCostTaxMny(ComputeUtil.safeSub((BigDecimal)entity.getSettleTaxMny(), (BigDecimal)entity.getRentTaxMny()));
        entity.setCostMny(ComputeUtil.safeSub((BigDecimal)entity.getSettleMny(), (BigDecimal)entity.getRentMny()));
        entity.setCostTax(ComputeUtil.safeSub((BigDecimal)entity.getCostTaxMny(), (BigDecimal)entity.getCostMny()));
        this.saveOrUpdate((Object)entity, false);
        return (SettleVO)BeanMapper.map((Object)this.selectById(entity.getId()), SettleVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public List<RentCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentCalculateEntity::getContractId, (Object)contractId);
        wrapper.eq(RentCalculateEntity::getSettleFlag, (Object)0);
        wrapper.in(RentCalculateEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(RentCalculateEntity::getRentDate, (Object)settleDate);
        } else {
            wrapper.between(RentCalculateEntity::getRentDate, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.calculateService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<RentCalculateVO>();
        }
        return BeanMapper.mapList((Iterable)list, RentCalculateVO.class);
    }

    @Override
    public List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RestituteEntity::getContractId, (Object)contractId);
        wrapper.eq(RestituteEntity::getSettleFlag, (Object)0);
        wrapper.in(RestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(RestituteEntity::getRestituteDate, (Object)settleDate);
        } else {
            wrapper.between(RestituteEntity::getRestituteDate, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.restituteService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<RestituteVO>();
        }
        return BeanMapper.mapList((Iterable)list, RestituteVO.class);
    }

    @Override
    public List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LoseEntity::getContractId, (Object)contractId);
        wrapper.eq(LoseEntity::getSettleFlag, (Object)0);
        wrapper.in(LoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(LoseEntity::getBillDate, (Object)settleDate);
        } else {
            wrapper.between(LoseEntity::getBillDate, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.loseService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<LoseVO>();
        }
        return BeanMapper.mapList((Iterable)list, LoseVO.class);
    }

    @Override
    public SettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)contractId);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        if (billId != null) {
            wrapper.ne(BaseEntity::getId, (Object)billId);
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new SettleVO();
        }
        return (SettleVO)BeanMapper.map(list.get(0), SettleVO.class);
    }

    @Override
    public SettleRecordVO querySettleRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        SettleRecordVO vo = new SettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List settleList = super.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)settleList)) {
            vo.setTotalSettleTaxMny(((SettleEntity)((Object)settleList.get(0))).getTotalSettleTaxMny());
            vo.setTotalSettleMny(((SettleEntity)((Object)settleList.get(0))).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalSettleTaxMny(), (BigDecimal)vo.getTotalSettleMny()), (BigDecimal)new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList((Iterable)settleList, SettleVO.class));
        Boolean contractFilingFlag = this.contractService.checkFilingType(id, ContractFilingTypeEnum.\u79df\u8d41\u5408\u540c\u7ed3\u7b97.getTypeCode());
        if (contractFilingFlag.booleanValue()) {
            vo.setCanAddNewSettleFlag(true);
        } else {
            vo.setCanAddNewSettleFlag(false);
        }
        return vo;
    }

    @Override
    public Boolean pushSettleToPool(SettleVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)vo, (Object)poolVO);
            poolVO.setSourceId(vo.getId());
            poolVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            poolVO.setSourceType(SettleSourceTypeEnum.\u5468\u8f6c\u6750\u79df\u5165\u7ed3\u7b97.getCode());
            poolVO.setSourceTypeName(SettleSourceTypeEnum.\u5468\u8f6c\u6750\u79df\u5165\u7ed3\u7b97.getName());
            poolVO.setSettleProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            poolVO.setSettlePropertyName(SettleEnum.\u652f\u51fa.getName());
            poolVO.setUltimateFlag(Integer.valueOf(vo.getSettleType()));
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            poolVO.setSupplementFlag(contractEntity.getSupplementFlag());
            poolVO.setMaiContractId(contractEntity.getId());
            poolVO.setMaiContractCode(contractEntity.getBillCode());
            poolVO.setMaiContractName(contractEntity.getContractName());
            poolVO.setSignDate(contractEntity.getSignDate());
            poolVO.setContractType(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            poolVO.setContractTypeName(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeName());
            poolVO.setContractFlag(Integer.valueOf(1));
            poolVO.setCreateTime(vo.getCreateTime());
            poolVO.setCreateUserCode(vo.getCreateUserCode());
            poolVO.setUpdateTime(vo.getUpdateTime());
            poolVO.setUpdateUserCode(vo.getUpdateUserCode());
            poolVO.setBillCodeUrl("/ejc-prormat-frontend/#/settle/card?id=" + vo.getId());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public Boolean delSettleFromPool(Long id) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(poolVO);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return false;
    }

    @Override
    public ExecutionVO targetCost(SettleEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)entity.getContractId());
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        List list = this.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettleTaxMny() != null).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettleMny() != null).map(SettleEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(this.baseHost + "ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public Boolean pushContract(SettleVO vo, String updateLevel, Boolean type) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            CommonResponse transDataResp;
            data.setUpdateLevel(UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode());
            data.setSourceId(vo.getContractId());
            if (Boolean.TRUE.equals(type)) {
                data.setTotalSettleTaxMny(vo.getTotalSettleTaxMny());
                data.setTotalSettleMny(vo.getTotalSettleMny());
                data.setTotalSettleTax(vo.getTotalSettleTax());
            } else {
                data.setTotalSettleTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getTotalSettleTaxMny(), (BigDecimal)vo.getLastSettleTaxMny()));
                data.setTotalSettleMny(ComputeUtil.safeSub((BigDecimal)vo.getTotalSettleMny(), (BigDecimal)vo.getLastSettleMny()));
                data.setTotalSettleTax(ComputeUtil.safeSub((BigDecimal)data.getTotalSettleTaxMny(), (BigDecimal)data.getTotalSettleMny()));
            }
            if ("1".equals(vo.getSettleType())) {
                if (Boolean.TRUE.equals(type)) {
                    data.setFinishSettleDate(vo.getCommitDate());
                    data.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                } else {
                    data.setFinishSettleDate(null);
                    data.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            if ((transDataResp = this.contractPoolApi.saveOrUpdateContract(data)).isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    @Override
    public Boolean pushBillToSupCenter(SettleEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public Boolean delPushBill(SettleEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        SettleEntity entity = (SettleEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), SettleEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        this.logger.info("\u8fd4\u56de\u6d88\u606fmsg" + msg);
        return msg;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal contractTaxMny, BigDecimal settleTaxMny, BigDecimal totalSettleTaxMny, Long orgId, Integer settleType) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        paramsCheckVOS.addAll(this.checkParamsMny(purchaseType, contractTaxMny, settleTaxMny, totalSettleTaxMny, orgId, settleType));
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsMny(Integer purchaseType, BigDecimal contractTaxMny, BigDecimal settleTaxMny, BigDecimal totalSettleTaxMny, Long orgId, Integer settleType) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        String CHECK_PARAM_CODE = "";
        CHECK_PARAM_CODE = settleType == 0 ? CHECK_PARAM_CODE_GC : CHECK_PARAM_CODE_ZZ;
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    if (2 == purchaseType) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    settleTaxMny = settleTaxMny != null ? settleTaxMny.setScale(2, 4) : BigDecimal.ZERO;
                    BigDecimal bigDecimal = totalSettleTaxMny = totalSettleTaxMny != null ? totalSettleTaxMny.setScale(2, 4) : BigDecimal.ZERO;
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalSettleTaxMny).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)comMny)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO vo) {
        SettleEntity entity = (SettleEntity)((Object)((SettleMapper)this.baseMapper).selectById(vo.getId()));
        if (ListUtil.isNotEmpty((List)vo.getDailyRentList())) {
            List dailyList = BeanMapper.mapList((Iterable)vo.getDailyRentList(), SettleDailyRentEntity.class);
            entity.setDailyRentList(dailyList);
        }
        if (ListUtil.isNotEmpty((List)vo.getMonthRentList())) {
            List monthList = BeanMapper.mapList((Iterable)vo.getMonthRentList(), SettleMonthRentEntity.class);
            entity.setMonthRentList(monthList);
        }
        if (ListUtil.isNotEmpty((List)vo.getNumRentList())) {
            List numList = BeanMapper.mapList((Iterable)vo.getNumRentList(), SettleNumRentEntity.class);
            entity.setNumRentList(numList);
        }
        if (ListUtil.isNotEmpty((List)vo.getRepairList())) {
            List repairList = BeanMapper.mapList((Iterable)vo.getRepairList(), SettleRepairEntity.class);
            entity.setRepairList(repairList);
        }
        if (ListUtil.isNotEmpty((List)vo.getScrapList())) {
            List scrapList = BeanMapper.mapList((Iterable)vo.getScrapList(), SettleScrapEntity.class);
            entity.setScrapList(scrapList);
        }
        if (ListUtil.isNotEmpty((List)vo.getLoseList())) {
            List loseList = BeanMapper.mapList((Iterable)vo.getLoseList(), SettleLoseEntity.class);
            entity.setLoseList(loseList);
        }
        if (ListUtil.isNotEmpty((List)vo.getOtherList())) {
            List otherList = BeanMapper.mapList((Iterable)vo.getOtherList(), SettleOtherEntity.class);
            entity.setOtherList(otherList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SettleVO.class));
    }

    @Override
    public void costPush(SettleEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<SettleDailyRentEntity> dailyList = entity.getDailyRentList();
        List<SettleMonthRentEntity> monthList = entity.getMonthRentList();
        List<SettleNumRentEntity> numList = entity.getNumRentList();
        List<SettleRepairEntity> repairList = entity.getRepairList();
        List<SettleScrapEntity> scrapList = entity.getScrapList();
        List<SettleLoseEntity> loseList = entity.getLoseList();
        List<SettleOtherEntity> otherList = entity.getOtherList();
        String relationFlag = "1";
        if (ListUtil.isNotEmpty(dailyList)) {
            for (SettleDailyRentEntity settleDailyRentEntity : dailyList) {
                if (null != settleDailyRentEntity.getSubjectId() && null != settleDailyRentEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isNotEmpty(monthList)) {
            for (SettleMonthRentEntity settleMonthRentEntity : monthList) {
                if (null != settleMonthRentEntity.getSubjectId() && null != settleMonthRentEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isNotEmpty(numList)) {
            for (SettleNumRentEntity settleNumRentEntity : numList) {
                if (null != settleNumRentEntity.getSubjectId() && null != settleNumRentEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isNotEmpty(repairList)) {
            for (SettleRepairEntity settleRepairEntity : repairList) {
                if (null != settleRepairEntity.getSubjectId() && null != settleRepairEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isNotEmpty(scrapList)) {
            for (SettleScrapEntity settleScrapEntity : scrapList) {
                if (null != settleScrapEntity.getSubjectId() && null != settleScrapEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isNotEmpty(loseList)) {
            for (SettleLoseEntity settleLoseEntity : loseList) {
                if (null != settleLoseEntity.getSubjectId() && null != settleLoseEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isNotEmpty(otherList)) {
            for (SettleOtherEntity settleOtherEntity : otherList) {
                if (null != settleOtherEntity.getSubjectId() && null != settleOtherEntity.getWbsId()) continue;
                relationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(dailyList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(numList) && ListUtil.isEmpty(repairList) && ListUtil.isEmpty(scrapList) && ListUtil.isEmpty(loseList) && ListUtil.isEmpty(otherList)) {
            relationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)relationFlag);
        super.update((Wrapper)updateWrapper);
        String string = entity.getRelationFlag();
        if ("1".equals(string)) {
            if ("1".equals(relationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(relationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-{}Id---{}", (Object)BILL_NAME, (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(string) && "1".equals(relationFlag)) {
            this.saveCost(entity);
        }
    }

    private void saveCost(SettleEntity entity) {
        List<SettleOtherEntity> list;
        List<SettleLoseEntity> list2;
        List<SettleScrapEntity> list3;
        List<SettleRepairEntity> list4;
        List<SettleNumRentEntity> list5;
        List<SettleMonthRentEntity> monthList;
        ArrayList<CostDetailVO> costVOList = new ArrayList<CostDetailVO>();
        List<SettleDailyRentEntity> dailyList = entity.getDailyRentList();
        if (ListUtil.isNotEmpty(dailyList)) {
            for (SettleDailyRentEntity settleDailyRentEntity : dailyList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleDailyRentEntity.getSubjectId());
                costDetailVO.setSubjectCode(settleDailyRentEntity.getSubjectCode());
                costDetailVO.setSubjectName(settleDailyRentEntity.getSubjectName());
                costDetailVO.setWbsId(settleDailyRentEntity.getWbsId());
                costDetailVO.setWbsCode(settleDailyRentEntity.getWbsCode());
                costDetailVO.setWbsName(settleDailyRentEntity.getWbsName());
                costDetailVO.setSourceId(settleDailyRentEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleDailyRentEntity.getId());
                costDetailVO.setHappenTaxMny(settleDailyRentEntity.getDailyRentTaxMny());
                costDetailVO.setHappenMny(settleDailyRentEntity.getDailyRentMny());
                costDetailVO.setHappenDate(entity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(PRO_RMAT_SETTLE);
                costDetailVO.setSourceTabType("PRO_RMAT_SETTLE_DAILY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(monthList = entity.getMonthRentList())) {
            for (SettleMonthRentEntity settleMonthRentEntity : monthList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleMonthRentEntity.getSubjectId());
                costDetailVO.setSubjectCode(settleMonthRentEntity.getSubjectCode());
                costDetailVO.setSubjectName(settleMonthRentEntity.getSubjectName());
                costDetailVO.setWbsId(settleMonthRentEntity.getWbsId());
                costDetailVO.setWbsCode(settleMonthRentEntity.getWbsCode());
                costDetailVO.setWbsName(settleMonthRentEntity.getWbsName());
                costDetailVO.setSourceId(settleMonthRentEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleMonthRentEntity.getId());
                costDetailVO.setHappenTaxMny(settleMonthRentEntity.getMonthRentTaxMny());
                costDetailVO.setHappenMny(settleMonthRentEntity.getMonthRentMny());
                costDetailVO.setHappenDate(entity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(PRO_RMAT_SETTLE);
                costDetailVO.setSourceTabType("PRO_RMAT_SETTLE_MONTH");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(list5 = entity.getNumRentList())) {
            for (SettleNumRentEntity settleNumRentEntity : list5) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleNumRentEntity.getSubjectId());
                costDetailVO.setSubjectCode(settleNumRentEntity.getSubjectCode());
                costDetailVO.setSubjectName(settleNumRentEntity.getSubjectName());
                costDetailVO.setWbsId(settleNumRentEntity.getWbsId());
                costDetailVO.setWbsCode(settleNumRentEntity.getWbsCode());
                costDetailVO.setWbsName(settleNumRentEntity.getWbsName());
                costDetailVO.setSourceId(settleNumRentEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleNumRentEntity.getId());
                costDetailVO.setHappenTaxMny(settleNumRentEntity.getNumRentTaxMny());
                costDetailVO.setHappenMny(settleNumRentEntity.getNumRentMny());
                costDetailVO.setHappenDate(entity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(PRO_RMAT_SETTLE);
                costDetailVO.setSourceTabType("PRO_RMAT_SETTLE_NUM");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(list4 = entity.getRepairList())) {
            for (SettleRepairEntity settleRepairEntity : list4) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleRepairEntity.getSubjectId());
                costDetailVO.setSubjectCode(settleRepairEntity.getSubjectCode());
                costDetailVO.setSubjectName(settleRepairEntity.getSubjectName());
                costDetailVO.setWbsId(settleRepairEntity.getWbsId());
                costDetailVO.setWbsCode(settleRepairEntity.getWbsCode());
                costDetailVO.setWbsName(settleRepairEntity.getWbsName());
                costDetailVO.setSourceId(settleRepairEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleRepairEntity.getId());
                costDetailVO.setHappenTaxMny(settleRepairEntity.getRepairTaxMny());
                costDetailVO.setHappenMny(settleRepairEntity.getRepairMny());
                costDetailVO.setHappenDate(entity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(PRO_RMAT_SETTLE);
                costDetailVO.setSourceTabType("PRO_RMAT_SETTLE_REPAIR");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list3 = entity.getScrapList())) {
            for (SettleScrapEntity settleScrapEntity : list3) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleScrapEntity.getSubjectId());
                costDetailVO.setSubjectCode(settleScrapEntity.getSubjectCode());
                costDetailVO.setSubjectName(settleScrapEntity.getSubjectName());
                costDetailVO.setWbsId(settleScrapEntity.getWbsId());
                costDetailVO.setWbsCode(settleScrapEntity.getWbsCode());
                costDetailVO.setWbsName(settleScrapEntity.getWbsName());
                costDetailVO.setSourceId(settleScrapEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleScrapEntity.getId());
                costDetailVO.setHappenTaxMny(settleScrapEntity.getCompensateTaxMny());
                costDetailVO.setHappenMny(settleScrapEntity.getCompensateMny());
                costDetailVO.setHappenDate(entity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(PRO_RMAT_SETTLE);
                costDetailVO.setSourceTabType("PRO_RMAT_SETTLE_SCRAP");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = entity.getLoseList())) {
            for (SettleLoseEntity settleLoseEntity : list2) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(settleLoseEntity.getSubjectId());
                costVO.setSubjectCode(settleLoseEntity.getSubjectCode());
                costVO.setSubjectName(settleLoseEntity.getSubjectName());
                costVO.setWbsId(settleLoseEntity.getWbsId());
                costVO.setWbsCode(settleLoseEntity.getWbsCode());
                costVO.setWbsName(settleLoseEntity.getWbsName());
                costVO.setSourceId(settleLoseEntity.getSettleId());
                costVO.setSourceDetailId(settleLoseEntity.getId());
                costVO.setHappenTaxMny(settleLoseEntity.getCompensateTaxMny());
                costVO.setHappenMny(settleLoseEntity.getCompensateMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costVO.setSourceType(PRO_RMAT_SETTLE);
                costVO.setSourceTabType("PRO_RMAT_SETTLE_LOSE");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list = entity.getOtherList())) {
            for (SettleOtherEntity detail : list) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(detail.getSettleId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getSettleTaxMny());
                costVO.setHappenMny(detail.getSettleMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costVO.setSourceType(PRO_RMAT_SETTLE);
                costVO.setSourceTabType("PRO_RMAT_SETTLE_OTHER");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVOList.add(costVO);
            }
        }
        if (ListUtil.isNotEmpty(costVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costVOList));
            CommonResponse commonResponse = this.costDetailApi.saveSubject(costVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        ExecutionVO executionVO = this.targetCost((SettleEntity)((Object)this.selectById(id)));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        if (!response.isSuccess()) {
            this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = ((SettleMapper)this.baseMapper).delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25!");
        }
    }
}

