/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.pro.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.pro.ownrmat.bean.HandleEntity;
import com.ejianc.business.pro.ownrmat.bean.OwnDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.OwnEntity;
import com.ejianc.business.pro.ownrmat.mapper.OwnMapper;
import com.ejianc.business.pro.ownrmat.service.IAllotOutService;
import com.ejianc.business.pro.ownrmat.service.IAmortizationService;
import com.ejianc.business.pro.ownrmat.service.IHandleService;
import com.ejianc.business.pro.ownrmat.service.IOwnDetailService;
import com.ejianc.business.pro.ownrmat.service.IOwnService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.vo.OwnDetailVO;
import com.ejianc.business.pro.ownrmat.vo.OwnVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ownService")
public class OwnServiceImpl
extends BaseServiceImpl<OwnMapper, OwnEntity>
implements IOwnService {
    private static final String BILL_CODE = "PRO_OWNRMAT_OWN";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOwnDetailService ownDetailService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAmortizationService amortizationService;
    @Autowired
    private IAllotOutService allotOutService;
    @Autowired
    private IHandleService handleService;
    @Autowired
    private IValidateService validateContract;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Override
    public OwnVO saveOrUpdate(OwnVO saveorUpdateVO) {
        List detailEntityList;
        this.validateContract.validateProject(saveorUpdateVO.getProjectId(), "\u81ea\u6709\u6750\u6599\u644a\u9500", saveorUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveorUpdateVO, "\u4fdd\u5b58");
        Long tenantId = InvocationInfoProxy.getTenantid();
        OwnEntity entity = null;
        String operateType = null;
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(OwnEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        lambd.notIn(OwnEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (OwnEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OwnEntity.class));
            operateType = "edit";
            lambd.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)tenantId, (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OwnEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OwnEntity.class));
            operateType = "add";
        }
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        List list = super.list((Wrapper)lambd);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u4e0a\u4e0b\u6587\u7ec4\u7ec7\u6709\u672a\u751f\u6548\u7684\u644a\u9500\u5355\uff0c\u4e0d\u80fd\u65b0\u589e\u644a\u9500\u5355");
        }
        List detailList = saveorUpdateVO.getOwnDetailList();
        String categoryName = "";
        ArrayList<String> nameList = new ArrayList<String>();
        for (OwnDetailVO detailVO : detailList) {
            if (nameList.contains(detailVO.getMaterialTypeName())) continue;
            categoryName = categoryName.length() > 0 ? categoryName + "," + detailVO.getMaterialTypeName() : detailVO.getMaterialTypeName();
            nameList.add(detailVO.getMaterialTypeName());
            if (categoryName.length() <= 100) continue;
            break;
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((OwnMapper)this.baseMapper).delByBatchId(entity.getId());
        }
        if ((detailEntityList = BeanMapper.mapList((Iterable)detailList, OwnDetailEntity.class)).size() > 0) {
            for (OwnDetailEntity detailEntity : detailEntityList) {
                detailEntity.setOwnId(entity.getId());
            }
            this.ownDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return this.queryDetail(entity.getId());
    }

    private Boolean allotOutCheck(Long projectId) {
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(AllotOutEntity::getProjectId, (Object)projectId);
        lambd.notIn(AllotOutEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.allotOutService.list((Wrapper)lambd);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    private Boolean handleCheck(Long projectId) {
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(HandleEntity::getProjectId, (Object)projectId);
        lambd.notIn(HandleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.handleService.list((Wrapper)lambd);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public String validateTime(OwnVO startVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", startVO.getProjectId());
        if (startVO.getId() != null) {
            params.put("billType", "\u81ea\u6709\u6750\u6599\u644a\u9500");
            params.put("billId", startVO.getId());
        }
        Date lastDate = this.validateContract.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.validateContract.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)startVO.getProcessingDate(), (Date)lastDate, maxTimeMap, (Date)startVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)startVO.getProcessingDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public void costPush(OwnVO ownVO) {
        this.logger.info("\u5f00\u59cbcostPush");
        String oldRelationFlag = ownVO.getRelationFlag();
        List ownDetailList = ownVO.getOwnDetailList();
        String newRelationFlag = "1";
        if (ownDetailList != null && ownDetailList.size() > 0) {
            for (OwnDetailVO detailVO : ownDetailList) {
                if (null != detailVO.getSubjectId() && null != detailVO.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        } else {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{ownVO.getId()});
        updateWrapper.set(OwnEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(ownVO);
            } else {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)ownVO.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(ownVO.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        } else if ("1".equals(newRelationFlag)) {
            this.saveCost(ownVO);
        }
    }

    @Override
    public OwnVO pushCost(OwnVO vo) {
        OwnEntity entity = (OwnEntity)((Object)((OwnMapper)this.baseMapper).selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)vo.getOwnDetailList())) {
            List storeSubEntityList = BeanMapper.mapList((Iterable)vo.getOwnDetailList(), OwnDetailEntity.class);
            entity.setOwnDetailList(storeSubEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(vo);
        return (OwnVO)BeanMapper.map((Object)((Object)entity), OwnVO.class);
    }

    private void saveCost(OwnVO vo) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List ownDetailList = vo.getOwnDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)ownDetailList)) {
            for (OwnDetailVO detailVO : ownDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detailVO.getSubjectId());
                costDetailVO.setSubjectCode(detailVO.getSubjectCode());
                costDetailVO.setSubjectName(detailVO.getSubjectName());
                costDetailVO.setWbsId(detailVO.getWbsId());
                costDetailVO.setWbsCode(detailVO.getWbsCode());
                costDetailVO.setWbsName(detailVO.getWbsName());
                costDetailVO.setSourceId(detailVO.getOwnId());
                costDetailVO.setSourceDetailId(detailVO.getId());
                costDetailVO.setHappenTaxMny(detailVO.getAmortizationMnyTax());
                costDetailVO.setHappenMny(detailVO.getAmortizationMny());
                costDetailVO.setHappenDate(vo.getProcessingDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("PRORMAT_OWN");
                costDetailVO.setSourceTabType("PRORMAT_OWN_DETAIL");
                costDetailVO.setProjectId(vo.getProjectId());
                costDetailVO.setSourceBillCode(vo.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u81ea\u6709\u5468\u8f6c\u6750\u644a\u9500.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-prormat-frontend/#/own/card?id=" + vo.getId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public OwnVO queryDetail(Long id) {
        OwnEntity batchPlanEntity = (OwnEntity)((Object)super.selectById((Serializable)id));
        OwnVO vo = (OwnVO)BeanMapper.map((Object)((Object)batchPlanEntity), OwnVO.class);
        return vo;
    }

    @Override
    public List<OwnDetailVO> refAmortizationList(QueryParam param, Long orgId, String amortizationCycle) {
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        ArrayList<Integer> inOutType = new ArrayList<Integer>();
        inOutType.add(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutType());
        inOutType.add(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u5165\u5e93.getInOutType());
        param.getParams().put("inOutType", new Parameter("in", inOutType));
        param.getParams().put("inOutFlag", new Parameter("eq", (Object)InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutFlag()));
        CommonResponse flowListResponse = this.storeFlowApi.getFlowList(param);
        List flowList = new ArrayList();
        if (!flowListResponse.isSuccess()) {
            throw new BusinessException(flowListResponse.getMsg());
        }
        flowList = (List)flowListResponse.getData();
        ArrayList<OwnDetailVO> res = new ArrayList<OwnDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (FlowVO vo : flowList) {
            BigDecimal num = ComputeUtil.safeAdd((BigDecimal)vo.getOutLockNum(), (BigDecimal)vo.getSurplusNum());
            if (num == null) {
                num = BigDecimal.ZERO;
            }
            if (num.compareTo(BigDecimal.ZERO) <= 0 || vo.getNetTaxMny() == null || vo.getNetTaxMny().compareTo(BigDecimal.ZERO) <= 0 || (vo.getLastShareDate() != null || DateUtil.compareDateStr((String)amortizationCycle, (String)sdf.format(vo.getSourceBillDate())) < 0) && (vo.getLastShareDate() == null || DateUtil.compareDateStr((String)amortizationCycle, (String)sdf.format(vo.getLastShareDate())) <= 0)) continue;
            BigDecimal purchasePrice = vo.getPurchasePrice() == null ? BigDecimal.ZERO : vo.getPurchasePrice();
            BigDecimal purchaseTaxPrice = vo.getPurchaseTaxPrice() == null ? BigDecimal.ZERO : vo.getPurchaseTaxPrice();
            OwnDetailVO detailVO = new OwnDetailVO();
            detailVO.setId(vo.getId());
            detailVO.setSourceCode(vo.getSourceBillCode());
            detailVO.setMaterialTypeId(vo.getMaterialCategoryId());
            detailVO.setMaterialTypeCode(vo.getMaterialCategoryCode());
            detailVO.setMaterialTypeName(vo.getMaterialCategoryName());
            detailVO.setMaterialId(vo.getMaterialId());
            detailVO.setMaterialCode(vo.getMaterialCode());
            detailVO.setMaterialName(vo.getMaterialName());
            detailVO.setSpec(vo.getMaterialSpec());
            detailVO.setUnitId(vo.getMaterialUnitId());
            detailVO.setUnit(vo.getMaterialUnitName());
            detailVO.setOriginalValue(ComputeUtil.safeMultiply((BigDecimal)vo.getSurplusNum(), (BigDecimal)purchasePrice));
            detailVO.setOriginalValueTax(ComputeUtil.safeMultiply((BigDecimal)vo.getSurplusNum(), (BigDecimal)purchaseTaxPrice));
            detailVO.setNetWorth(vo.getNetMny() == null ? BigDecimal.ZERO : vo.getNetMny());
            detailVO.setNetWorthTax(vo.getNetTaxMny() == null ? BigDecimal.ZERO : vo.getNetTaxMny());
            detailVO.setResidualValue(null);
            detailVO.setResidualValueTax(null);
            detailVO.setOriginalValuePrice(purchasePrice);
            detailVO.setOriginalValuePriceTax(purchaseTaxPrice);
            BigDecimal taxRate = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)detailVO.getOriginalValue()), (BigDecimal)BigDecimal.ONE);
            taxRate = taxRate.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : ComputeUtil.safeMultiply((BigDecimal)taxRate, (BigDecimal)new BigDecimal(100));
            detailVO.setTaxRate(taxRate);
            detailVO.setNum(vo.getSurplusNum());
            detailVO.setLastAmortizationCycle(vo.getLastShareDate() == null ? null : sdf.format(vo.getLastShareDate()));
            detailVO.setAmortizationRate(null);
            detailVO.setAmortizationMny(null);
            detailVO.setAmortizationMnyTax(null);
            detailVO.setMemo(vo.getSourceBillDetailRemark());
            detailVO.setSourceId(vo.getId());
            int amortizationNum = 0;
            int usedAmortizationNum = 0;
            if (vo.getLastShareDate() != null) {
                amortizationNum = DateUtil.subMonth((String)sdf.format(vo.getLastShareDate()), (String)amortizationCycle, (SimpleDateFormat)sdf);
                usedAmortizationNum = DateUtil.subMonth((String)sdf.format(vo.getSourceBillDate()), (String)sdf.format(vo.getLastShareDate()), (SimpleDateFormat)sdf) + 1;
            } else {
                amortizationNum = DateUtil.subMonth((String)sdf.format(vo.getSourceBillDate()), (String)amortizationCycle, (SimpleDateFormat)sdf) + 1;
            }
            detailVO.setAmortizationNum(Integer.valueOf(amortizationNum));
            detailVO.setUsedAmortizationNum(Integer.valueOf(usedAmortizationNum));
            detailVO.setFlowSourceId(vo.getSourceId());
            detailVO.setFlowSourceDetailId(vo.getSourceDetailId());
            res.add(detailVO);
            materialIds.add(vo.getMaterialId());
        }
        if (res.size() > 0) {
            CommonResponse listCommonResponse;
            FlowVO vo;
            List materialIds1 = (List)Utils.deepCopy(materialIds);
            vo = new ResidualVO();
            vo.setOrgId(orgId);
            vo.setMaterialIds(materialIds);
            Map<Long, AmortizationEntity> residualRate = this.amortizationService.getResidualRate((ResidualVO)vo);
            if (residualRate.size() > 0) {
                for (OwnDetailVO detailVO : res) {
                    if (residualRate.containsKey(detailVO.getMaterialId())) {
                        detailVO.setUsePeriod(residualRate.get(detailVO.getMaterialId()).getUsePeriod());
                        detailVO.setResidualValueRate(residualRate.get(detailVO.getMaterialId()).getResidualValueRate());
                        detailVO.setResidualValue(ComputeUtil.safeMultiply((BigDecimal)detailVO.getOriginalValue(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getResidualValueRate(), (BigDecimal)new BigDecimal(100))));
                        detailVO.setResidualValueTax(ComputeUtil.safeMultiply((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getResidualValueRate(), (BigDecimal)new BigDecimal(100))));
                        continue;
                    }
                    detailVO.setResidualValue(BigDecimal.ZERO);
                    detailVO.setResidualValueTax(BigDecimal.ZERO);
                }
            }
            if ((listCommonResponse = this.shareMaterialApi.queryMaterialItemByIds(materialIds1)).isSuccess()) {
                List data = (List)listCommonResponse.getData();
                HashMap<Long, MaterialVO> mmap = new HashMap<Long, MaterialVO>();
                for (MaterialVO mvo : data) {
                    mmap.put(mvo.getId(), mvo);
                }
                for (OwnDetailVO detailVO : res) {
                    if (!mmap.containsKey(detailVO.getMaterialId())) continue;
                    MaterialVO materialVO = (MaterialVO)mmap.get(detailVO.getMaterialId());
                    detailVO.setSubjectId(materialVO.getSubjectId());
                    detailVO.setSubjectName(materialVO.getSubjectName());
                }
            }
        }
        return res;
    }

    @Override
    public String getLastAmortizationCycle(Long projectId, Long id) {
        String lastAmortizationCycle = ((OwnMapper)this.baseMapper).getLastAmortizationCycle(projectId, id);
        return lastAmortizationCycle;
    }
}

