/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.mapper.ContractRelieveMapper;
import com.ejianc.business.pro.rmat.service.IContractRelieveService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.business.pro.rmat.vo.ContractRelieveVO;
import com.ejianc.business.pro.rmat.vo.record.RelieveRecordVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    private static final String PRORMAT_CONTRACT_RELIEVE = "PRORMAT_CONTRACT_RELIEVE";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISettleService settleService;

    @Override
    public ContractRelieveVO saveOrUpdate(ContractRelieveVO saveOrUpdateVO) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractRelieveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)PRORMAT_CONTRACT_RELIEVE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.contractService.validateContract(saveOrUpdateVO.getContractId(), "\u89e3\u9664\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity == null || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode()) || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()) || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode())) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u6216\u5408\u540c\u72b6\u6001\u4e3a\u672a\u7b7e\u8ba2\u6216\u5df2\u7ec8\u6b62\u6216\u5df2\u4f5c\u5e9f\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)entity.getContractId()));
        List list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u6709\u4e00\u4efd\u5408\u540c\u89e3\u9664\u534f\u8bae!");
        }
        entity.setSignatureStatus(0);
        this.saveOrUpdate((Object)entity, false);
        return (ContractRelieveVO)BeanMapper.map((Object)((Object)entity), ContractRelieveVO.class);
    }

    @Override
    public Boolean addRelieveFlag(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        List list = this.queryList(param);
        return ListUtil.isEmpty((List)list);
    }

    @Override
    public RelieveRecordVO queryRelieveRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        RelieveRecordVO vo = new RelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRelieveEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, ContractRelieveVO.class));
        return vo;
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)entity.getContractId());
        wrapper.eq(SettleEntity::getSettleType, (Object)SettleEnum.\u8fc7\u7a0b\u7ed3\u7b97.getCode());
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        List list = this.settleService.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettleTaxMny() != null).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettleMny() != null).map(SettleEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BillTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u89e3\u9664.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(this.baseHost + "ejc-prormat-frontend/#/contract/relieveCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public void delById(Long id) {
        ((ContractRelieveMapper)this.baseMapper).delById(id);
    }
}

