package com.ejianc.business.pro.pricelib.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.pro.pricelib.bean.PriceContractEntity;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.business.pro.pricelib.vo.PriceLibVO;
import com.ejianc.business.pro.pricelib.vo.PriceTrendVo;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 周转材合同价格数据
 * 
 * @author generator
 * 
 */
public interface IPriceContractService extends IBaseService<PriceContractEntity> {
    /**
     * 定时处理合同价格库明细
     * 如果传入日期为空，则为初始化，处理全部合同（已提交、审批通过）明细
     *
     * @param date 日期
     */
    void savePriceContractByTiming(Date date);

    /**
     * 查询价格库汇总信息(有权限控制)
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param);

    /**
     * 查询价格库汇总信息(有权限控制)
     *
     * @param param 查询参数
     * @return 查询结果
     */
    List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param);

    /**
     * 根据材料id查询价格库信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    PriceLibVO queryPriceLibDetail(QueryParam param);

    /**
     * 查询价格库信息（无权限）
     *
     * @param startDate      开始日期
     * @param endDate        结束日期
     * @param materialTypeId 材料分类id
     * @return 查询结果
     */
    List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId);

    /**
     * 根据材料id查询对应的价格库合同明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param);

    /**
     * 查询合同价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    List<PriceTrendVo> queryPriceTrendContractList(QueryParam param);

    /**
     * 移除合同明细
     *
     * @param id 明细id
     */
    void removePriceContractDetail(Long id);

}
