package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.enums.ContractFilingTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.mapper.SettleMapper;
import com.ejianc.business.pro.rmat.service.*;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.vo.*;
import com.ejianc.business.pro.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材租赁结算单
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {

    private static final String PRO_RMAT_SETTLE = "PRO_RMAT_SETTLE";//此处需要根据实际修改

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String OPERATE = "SETTLE_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.周转材租赁合同结算单.getCode();
    private static final String BILL_NAME = BillTypeEnum.周转材租赁合同结算单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/settle/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/settle/billDel";
    private static final String CHECK_PARAM_CODE_GC = "P-8916ww47";//过程结算
    private static final String CHECK_PARAM_CODE_ZZ = "P-75u0y60160";//最终结算

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IRentCalculateService calculateService;

    @Autowired
    private IRestituteService restituteService;

    @Autowired
    private ILoseService loseService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IRentCalculateDailyService calculateDailyService;
    @Autowired
    private IRentCalculateMonthService calculateMonthService;
    @Autowired
    private IRentCalculateNumService calculateNumService;
    @Autowired
    private ISettleDailyRentService dailyRentService;
    @Autowired
    private ISettleMonthRentService monthRentService;
    @Autowired
    private ISettleNumRentService numRentService;
    @Autowired
    private ISettleLeaseService leaseService;

    @Override
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(PRO_RMAT_SETTLE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            // 签字状态
            entity.setSupplierSignStatus(0);
        }
        entity.setRelationFlag("0");// 关联状态初始化
        entity.setProportionFlag("0");// 分摊状态初始化

        // 校验合同
        validateContract(entity.getContractId(), entity.getId());
        // 校验结算日期
        SettleVO lastVo = queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null) {
            int compareDate = DateUtil.compareDate(lastVo.getSettleDate(), entity.getSettleDate());
            if (compareDate > 0) {
                throw new BusinessException("本次结算日期" + DateUtil.formatDate(entity.getSettleDate()) + "不能小于上次结算日期" + DateUtil.formatDate(lastVo.getSettleDate()));
            }
        }

        // 计算成本归集的发生成本金额
        entity.setCostTaxMny(ComputeUtil.safeSub(entity.getSettleTaxMny(), entity.getRentTaxMny()));
        entity.setCostMny(ComputeUtil.safeSub(entity.getSettleMny(), entity.getRentMny()));
        entity.setCostTax(ComputeUtil.safeSub(entity.getCostTaxMny(), entity.getCostMny()));

        this.saveOrUpdate(entity, false);
        saveCost(entity,0);
        CommonResponse<String> response = executionApi.aggPush(targetCost(entity));
        logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(entity)));
        if (!response.isSuccess()) {
            logger.error("推送目标成本失败: , {}", response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return BeanMapper.map(selectById(entity.getId()), SettleVO.class);
    }
    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<SettleEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的结算单，不允许新增!");
        }
        return "校验通过！";
    }

    @Override
    public List<RentCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<RentCalculateEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentCalculateEntity::getContractId, contractId);
        wrapper.eq(RentCalculateEntity::getSettleFlag, 0);
        wrapper.in(RentCalculateEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(RentCalculateEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(RentCalculateEntity::getRentDate, settleDate);
        } else {
            wrapper.between(RentCalculateEntity::getRentDate, lastSettleDate, settleDate);
        }

        List<RentCalculateEntity> list = calculateService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        } else {
            return BeanMapper.mapList(list, RentCalculateVO.class);
        }
    }

    @Override
    public List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<RestituteEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RestituteEntity::getContractId, contractId);
        wrapper.eq(RestituteEntity::getSettleFlag, 0);
        wrapper.in(RestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(RestituteEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(RestituteEntity::getRestituteDate, settleDate);
        } else {
            wrapper.between(RestituteEntity::getRestituteDate, lastSettleDate, settleDate);
        }

        List<RestituteEntity> list = restituteService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        } else {
            return BeanMapper.mapList(list, RestituteVO.class);
        }
    }

    @Override
    public List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<LoseEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LoseEntity::getContractId, contractId);
        wrapper.eq(LoseEntity::getSettleFlag, 0);
        wrapper.in(LoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(LoseEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(LoseEntity::getBillDate, settleDate);
        } else {
            wrapper.between(LoseEntity::getBillDate, lastSettleDate, settleDate);
        }

        List<LoseEntity> list = loseService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        } else {
            return BeanMapper.mapList(list, LoseVO.class);
        }

    }

    @Override
    public SettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        SettleVO vo = new SettleVO();
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, contractId);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        if (billId != null) {
            wrapper.ne(SettleEntity::getId, billId);
        }
        wrapper.orderByDesc(SettleEntity::getCreateTime);

        List<SettleEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return vo;
        } else {
            vo = BeanMapper.map(list.get(0), SettleVO.class);
            BigDecimal currentTaxMny = list.stream().filter(e -> e.getSettleTaxMny() != null).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettleTaxMny(currentTaxMny);
            BigDecimal currentMny  = list.stream().filter(e -> e.getSettleMny() != null).map(SettleEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettleMny(currentMny);
            BigDecimal currentTax  = list.stream().filter(e -> e.getSettleTax() != null).map(SettleEntity::getSettleTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettleTax(currentTax);
            return vo;
        }

    }

    @Override
    public SettleRecordVO querySettleRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);

        SettleRecordVO vo = new SettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());

        // 查询变更记录
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, id);
        wrapper.orderByDesc(SettleEntity::getCreateTime);
        List<SettleEntity> settleList = super.list(wrapper);

        if (ListUtil.isNotEmpty(settleList)) {
            vo.setTotalSettleTaxMny(settleList.get(0).getTotalSettleTaxMny());
            vo.setTotalSettleMny(settleList.get(0).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalSettleTaxMny(), vo.getTotalSettleMny()), new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList(settleList, SettleVO.class));
        //检测是否可以创建新的结算单
        Boolean contractFilingFlag = contractService.checkFilingType(id, ContractFilingTypeEnum.租赁合同结算.getTypeCode());
        if (contractFilingFlag) {
            vo.setCanAddNewSettleFlag(true);
        } else {
            vo.setCanAddNewSettleFlag(false);
        }
        return vo;
    }

    /**
     * 推送结算池
     *
     * @param vo
     * @return
     */
    @Override
    public Boolean pushSettleToPool(SettleVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            // 对象自动转换
            BeanConvertorUtil.convert(vo, poolVO);

            // 个别字段需要手动封装
            poolVO.setSourceId(vo.getId());
            poolVO.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            poolVO.setSourceType(SettleSourceTypeEnum.周转材租入结算.getCode());
            poolVO.setSourceTypeName(SettleSourceTypeEnum.周转材租入结算.getName());
            poolVO.setSettleProperty(Integer.valueOf(SettleEnum.支出.getCode()));
            poolVO.setSettlePropertyName(SettleEnum.支出.getName());
            poolVO.setUltimateFlag(Integer.valueOf(vo.getSettleType()));

            // 查询合同
            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
            poolVO.setSupplementFlag(contractEntity.getSupplementFlag());
            poolVO.setMaiContractId(contractEntity.getId());
            poolVO.setMaiContractCode(contractEntity.getBillCode());
            poolVO.setMaiContractName(contractEntity.getContractName());
            poolVO.setSignDate(contractEntity.getSignDate());
            poolVO.setContractType(ContractTypeEnum.周转材合同.getTypeCode());
            poolVO.setContractTypeName(ContractTypeEnum.周转材合同.getTypeName());
            poolVO.setContractFlag(1);//合同标识

            poolVO.setCreateTime(vo.getCreateTime());
            poolVO.setCreateUserCode(vo.getCreateUserCode());
            poolVO.setUpdateTime(vo.getUpdateTime());
            poolVO.setUpdateUserCode(vo.getUpdateUserCode());

            poolVO.setBillCodeUrl("/ejc-prormat-frontend/#/settle/card?id=" + vo.getId());

            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", vo.getId());
                return true;
            } else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}", vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
        }
        return false;

    }

    /**
     * 删除结算池数据
     *
     * @param id
     * @return
     */
    @Override
    public Boolean delSettleFromPool(Long id) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(poolVO);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return true;
        }

        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        return false;
    }

    /**
     * 转换目标成本VO
     *
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(SettleEntity entity) {
        // 查询合同
        ContractEntity contractEntity = contractService.getById(entity.getContractId());
        Long id = entity.getId()==null?IdWorker.getId():entity.getId();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(id);
        totalVO.setContractId(entity.getContractId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setMemo(entity.getMemo());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,entity.getSettleDate()));
        totalVO.setBillType("BT220310000000002");
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁结算单.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(entity.getSettleMny());
        totalVO.setTaxMoney(entity.getSettleTaxMny());
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-prormat-frontend/#/settle/card?id=" + id);

        List<SettleDailyRentEntity> dailyRentList = entity.getDailyRentList();//日租明细
        if (dailyRentList != null) {
            for (SettleDailyRentEntity dailyRent : dailyRentList) {
                if ("del".equals(dailyRent.getRowState())) {
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId());
                detailExecutionVO.setSourceBillId(id);
                detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                //判断是否是分类
                if (dailyRent.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(dailyRent.getMaterialId());
                }
                detailExecutionVO.setCode(dailyRent.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                detailExecutionVO.setName(dailyRent.getMaterialName());
                detailExecutionVO.setUnitId(dailyRent.getUnitId());
                detailExecutionVO.setUnitName(dailyRent.getUnitName());
                detailExecutionVO.setNum(dailyRent.getNum());
                detailExecutionVO.setMoney(dailyRent.getDailyRentMny());
                detailExecutionVO.setSpec(dailyRent.getSpec());
                detailExecutionVO.setTaxMoney(dailyRent.getDailyRentTaxMny());
                detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(dailyRent.getTaxRate());
                detailExecutionVO.setContractId(entity.getContractId());
                detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());
                detailExecutionVO.setMemo(dailyRent.getMemo());
                detailExecutionVO.setContractDetailId(dailyRent.getSourceId());
                detailList.add(detailExecutionVO);

            }

        }
        List<SettleMonthRentEntity> monthRentList = entity.getMonthRentList();//月租明细

        if (monthRentList != null) {
            for (SettleMonthRentEntity monthRentVO : monthRentList) {
                if ("del".equals(monthRentVO.getRowState())) {
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();

                detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                detailExecutionVO.setSourceBillId(id);
                detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                //判断是否是分类
                if (monthRentVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                detailExecutionVO.setName(monthRentVO.getMaterialName());
                detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                detailExecutionVO.setNum(monthRentVO.getNum());
                detailExecutionVO.setMoney(monthRentVO.getMonthRentMny());
                detailExecutionVO.setSpec(monthRentVO.getSpec());
                detailExecutionVO.setTaxMoney(monthRentVO.getMonthRentTaxMny());
                detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(monthRentVO.getTaxRate());
                detailExecutionVO.setContractId(entity.getContractId());
                detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                detailExecutionVO.setMemo(monthRentVO.getMemo());
                detailExecutionVO.setContractDetailId(monthRentVO.getSourceId());
                detailList.add(detailExecutionVO);

            }
        }

        List<SettleNumRentEntity> numRentList = entity.getNumRentList();//工程量租明细
        if (monthRentList != null) {
            for (SettleNumRentEntity monthRentVO : numRentList) {
                if ("del".equals(monthRentVO.getRowState())) {
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                detailExecutionVO.setSourceBillId(id);
                detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                //判断是否是分类
                if (monthRentVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                detailExecutionVO.setName(monthRentVO.getMaterialName());
                detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                detailExecutionVO.setNum(monthRentVO.getNum());
                detailExecutionVO.setMoney(monthRentVO.getNumRentMny());
                detailExecutionVO.setSpec(monthRentVO.getSpec());
                detailExecutionVO.setTaxMoney(monthRentVO.getNumRentTaxMny());
                detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(monthRentVO.getTaxRate());
                detailExecutionVO.setContractId(entity.getContractId());
                detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                detailExecutionVO.setMemo(monthRentVO.getMemo());
                detailExecutionVO.setContractDetailId(monthRentVO.getSourceId());
                detailList.add(detailExecutionVO);

            }
        }

        List<SettleLeaseEntity> leaseList = entity.getLeaseList();
        if (leaseList != null) {
            List<Long> calculateIdList = leaseList.stream().filter(t -> !"del".equals(t.getRowState())).map(SettleLeaseEntity::getSourceId).collect(Collectors.toList());
            // 计算租赁金额 -- 日租
            if (!calculateIdList.isEmpty()){
                LambdaQueryWrapper<RentCalculateDailyEntity> calculateDailyWrapper = new LambdaQueryWrapper<>();
                calculateDailyWrapper.in(RentCalculateDailyEntity::getRentId, calculateIdList);
                List<RentCalculateDailyEntity> calculateDailyList = calculateDailyService.list(calculateDailyWrapper);
                if (calculateDailyList != null) {
                    for (RentCalculateDailyEntity dailyRent : calculateDailyList) {
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setSourceId(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId());
                        detailExecutionVO.setSourceBillId(id);
                        detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                        detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                        //判断是否是分类
                        if (dailyRent.getMaterialId() == null) {
                            detailExecutionVO.setCategoryFlag(true);
                            detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                        } else {
                            detailExecutionVO.setCategoryFlag(false);
                            detailExecutionVO.setDocId(dailyRent.getMaterialId());
                        }
                        detailExecutionVO.setCode(dailyRent.getMaterialCode());
                        detailExecutionVO.setCategoryContainFlag(false);
                        //根据分类ID查询物料分类信息
                        MaterialCategoryVO categoryVO = materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                        if (categoryVO == null) {
                            detailExecutionVO.setCategoryInnerCode(null);
                            detailExecutionVO.setCategoryCode(null);
                        } else {
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCode());
                        }
                        detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                        detailExecutionVO.setName(dailyRent.getMaterialName());
                        detailExecutionVO.setUnitId(dailyRent.getUnitId());
                        detailExecutionVO.setUnitName(dailyRent.getUnitName());
                        detailExecutionVO.setNum(dailyRent.getNum());
                        detailExecutionVO.setMoney(dailyRent.getDailyRentMny());
                        detailExecutionVO.setSpec(dailyRent.getSpec());
                        detailExecutionVO.setTaxMoney(dailyRent.getDailyRentTaxMny());
                        detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                        detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                        detailExecutionVO.setTaxRate(dailyRent.getTaxRate());
                        detailExecutionVO.setContractId(entity.getContractId());
                        detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());
                        detailExecutionVO.setMemo(dailyRent.getMemo());
                        detailExecutionVO.setContractDetailId(dailyRent.getSourceId());
                        detailList.add(detailExecutionVO);
                    }
                }
                //计算租赁金额 -- 月租
                LambdaQueryWrapper<RentCalculateMonthEntity> calculateMonthWrapper = new LambdaQueryWrapper<>();
                calculateMonthWrapper.in(RentCalculateMonthEntity::getRentId, calculateIdList);
                List<RentCalculateMonthEntity> calculateMonthList = calculateMonthService.list(calculateMonthWrapper);
                if (calculateMonthList != null) {
                    for (RentCalculateMonthEntity monthRentVO : calculateMonthList) {
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                        detailExecutionVO.setSourceBillId(id);
                        detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                        detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                        //判断是否是分类
                        if (monthRentVO.getMaterialId() == null) {
                            detailExecutionVO.setCategoryFlag(true);
                            detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                        } else {
                            detailExecutionVO.setCategoryFlag(false);
                            detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                        }
                        detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                        detailExecutionVO.setCategoryContainFlag(false);
                        //根据分类ID查询物料分类信息
                        MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                        if (categoryVO == null) {
                            detailExecutionVO.setCategoryInnerCode(null);
                            detailExecutionVO.setCategoryCode(null);
                        } else {
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCode());
                        }
                        detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                        detailExecutionVO.setName(monthRentVO.getMaterialName());
                        detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                        detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                        detailExecutionVO.setNum(monthRentVO.getNum());
                        detailExecutionVO.setMoney(monthRentVO.getMonthRentMny());
                        detailExecutionVO.setSpec(monthRentVO.getSpec());
                        detailExecutionVO.setTaxMoney(monthRentVO.getMonthRentTaxMny());
                        detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                        detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                        detailExecutionVO.setTaxRate(monthRentVO.getTaxRate());
                        detailExecutionVO.setContractId(entity.getContractId());
                        detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                        detailExecutionVO.setMemo(monthRentVO.getMemo());
                        detailExecutionVO.setContractDetailId(monthRentVO.getSourceId());
                        detailList.add(detailExecutionVO);

                    }

                }
                //计算租赁金额 -- 工程量
                LambdaQueryWrapper<RentCalculateNumEntity> numNumWrapper = new LambdaQueryWrapper<>();
                numNumWrapper.in(RentCalculateNumEntity::getRentId, calculateIdList);
                List<RentCalculateNumEntity> calculateNumList = calculateNumService.list(numNumWrapper);
                if (calculateNumList != null) {
                    for (RentCalculateNumEntity monthRentVO : calculateNumList) {
                        if ("del".equals(monthRentVO.getRowState())) {
                            continue;
                        }
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                        detailExecutionVO.setSourceBillId(id);
                        detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                        detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                        //判断是否是分类
                        if (monthRentVO.getMaterialId() == null) {
                            detailExecutionVO.setCategoryFlag(true);
                            detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                        } else {
                            detailExecutionVO.setCategoryFlag(false);
                            detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                        }
                        detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                        detailExecutionVO.setCategoryContainFlag(false);
                        //根据分类ID查询物料分类信息
                        MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                        if (categoryVO == null) {
                            detailExecutionVO.setCategoryInnerCode(null);
                            detailExecutionVO.setCategoryCode(null);
                        } else {
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCode());
                        }
                        detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                        detailExecutionVO.setName(monthRentVO.getMaterialName());
                        detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                        detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                        detailExecutionVO.setNum(monthRentVO.getNum());
                        detailExecutionVO.setMoney(monthRentVO.getNumRentMny());
                        detailExecutionVO.setSpec(monthRentVO.getSpec());
                        detailExecutionVO.setTaxMoney(monthRentVO.getNumRentTaxMny());
                        detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                        detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                        detailExecutionVO.setTaxRate(monthRentVO.getTaxRate());
                        detailExecutionVO.setContractId(entity.getContractId());
                        detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                        detailExecutionVO.setMemo(monthRentVO.getMemo());
                        detailExecutionVO.setContractDetailId(monthRentVO.getSourceId());
                        detailList.add(detailExecutionVO);
                    }
                }
            }

        }
        executionVO.setTotalVO(totalVO);
        if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> docIdList = detailList.stream().map(DetailExecutionVO::getDocId).collect(Collectors.toList());
            CommonResponse<List<com.ejianc.foundation.share.vo.MaterialVO>> listCommonResponse = materialApi.queryMaterialByIds(docIdList);
            logger.info("根据分类ID-{}，获取到档案信息：{}", JSONObject.toJSONString(docIdList), JSONObject.toJSONString(listCommonResponse));
            if (listCommonResponse.isSuccess()){
                List<com.ejianc.foundation.share.vo.MaterialVO> materialVOList = listCommonResponse.getData();
                logger.info("根据分类ID获取到档案信息：{}", JSONObject.toJSONString(materialVOList));
                if (CollectionUtils.isNotEmpty(materialVOList)){
                    Map<Long, com.ejianc.foundation.share.vo.MaterialVO> materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity(), (key1, key2) -> key2));
                    for (DetailExecutionVO detailExecutionVO : detailList) {
                        if (null != materialVOMap.get(detailExecutionVO.getDocId())){
                            detailExecutionVO.setCode(materialVOMap.get(detailExecutionVO.getDocId()).getCode());
                        }
                    }
                }
            }
        }
        executionVO.setDetailList(detailList);

        return executionVO;

    }

    @Override
    public Boolean pushContract(SettleVO vo, String updateLevel, Boolean type) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(vo.getContractId());
            if (Boolean.TRUE.equals(type)) {
                data.setTotalSettleTaxMny(vo.getTotalSettleTaxMny());
                data.setTotalSettleMny(vo.getTotalSettleMny());
                data.setTotalSettleTax(vo.getTotalSettleTax());
            } else {
                data.setTotalSettleTaxMny(ComputeUtil.safeSub(vo.getTotalSettleTaxMny(), vo.getLastSettleTaxMny()));
                data.setTotalSettleMny(ComputeUtil.safeSub(vo.getTotalSettleMny(), vo.getLastSettleMny()));
                data.setTotalSettleTax(ComputeUtil.safeSub(data.getTotalSettleTaxMny(), data.getTotalSettleMny()));
            }
            if ("1".equals(vo.getSettleType())) {
                if (Boolean.TRUE.equals(type)) {
                    data.setFinishSettleDate(vo.getCommitDate());
                    data.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());
                } else {
                    data.setFinishSettleDate(null);
                    data.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
                }
            }
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}", vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return null;
    }

    /**
     * 单据推送到供方协同服务
     *
     * @param entity
     * @return
     */
    @Override
    public Boolean pushBillToSupCenter(SettleEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;

    }

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    @Override
    public Boolean delPushBill(SettleEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;

    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        SettleEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                SettleEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        logger.info("返回消息msg" + msg);
        return msg;
    }

    /**
     * 单据管控-累计结算金额大于合同金额
     *
     * @return
     */
    @Override
    public ParamsCheckVO checkParams(SettleVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        paramsCheckVOS.addAll(checkParamsMny(1, vo.getContractTaxMny(), vo.getSettleTaxMny(),vo.getTotalSettleTaxMny(), vo.getOrgId(), vo.getSettleType()));//金额控制
        //--目标成本控制
//        List<SettleDailyRentVO> dailyRentList = vo.getDailyRentList();
//        vo.getMonthRentList();
//        vo.getNumRentList();


        ExecutionVO executionVO = this.targetCost(BeanMapper.map(vo, SettleEntity.class));
        logger.error("目标成本控制推送传参：" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO tarRes = response.getData();
        if(null!=tarRes){
            paramsCheckVOS.add(tarRes);
        }
        /*--end---目标成本控制*/
        //--成本科目控制
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }
        /*--end---成本科目控制*/
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if (costParams != null) {//目标成本价格库控制
            paramsCheckVOS.add(costParams);
        }


        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    public ParamsCheckVO costPriceCheckParams(SettleVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();


        if(CollectionUtil.isNotEmpty(vo.getDailyRentList())){
            for (SettleDailyRentVO detailVO : vo.getDailyRentList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(vo.getMonthRentList())){
            for (SettleMonthRentVO detailVO : vo.getMonthRentList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(vo.getNumRentList())){
            for (SettleNumRentVO detailVO : vo.getNumRentList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = contractService.costPriceParams(materialPriceHistoryApiVO,"P-95b4l30211","结算");
        return  paramsCheckVO;
    }

    public CostCtrlVO sjCost(SettleVO vo){
        Map<Long,CostCtrlDetailVO> map = new HashMap<>();
        List<SettleDailyRentVO> dailyRentList = vo.getDailyRentList();
        if(CollectionUtils.isNotEmpty(dailyRentList)){
            for(SettleDailyRentVO dailyRent:dailyRentList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal dailyRenMny = dailyRent.getDailyRentMny()==null?BigDecimal.ZERO:dailyRent.getDailyRentMny();
                    BigDecimal dailyRenTaxMny = dailyRent.getDailyRentTaxMny()==null?BigDecimal.ZERO:dailyRent.getDailyRentTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(dailyRenMny);
                        costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }
        List<SettleMonthRentVO> monthRentList = vo.getMonthRentList();
        if(CollectionUtils.isNotEmpty(monthRentList)){
            for(SettleMonthRentVO dailyRent:monthRentList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal dailyRenMny = dailyRent.getMonthRentMny()==null?BigDecimal.ZERO:dailyRent.getMonthRentMny();
                    BigDecimal dailyRenTaxMny = dailyRent.getMonthRentTaxMny()==null?BigDecimal.ZERO:dailyRent.getMonthRentTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(dailyRenMny);
                        costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }
        List<SettleNumRentVO> numRentList = vo.getNumRentList();
        if(CollectionUtils.isNotEmpty(numRentList)){
            for(SettleNumRentVO dailyRent:numRentList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal dailyRenMny = dailyRent.getNumRentMny()==null?BigDecimal.ZERO:dailyRent.getNumRentMny();
                    BigDecimal dailyRenTaxMny = dailyRent.getNumRentTaxMny()==null?BigDecimal.ZERO:dailyRent.getNumRentTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(dailyRenMny);
                        costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }

        List<SettleRepairVO> repairList = vo.getRepairList();
        if(CollectionUtils.isNotEmpty(repairList)){
            for(SettleRepairVO dailyRent:repairList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal dailyRenMny = dailyRent.getRepairMny()==null?BigDecimal.ZERO:dailyRent.getRepairMny();
                    BigDecimal dailyRenTaxMny = dailyRent.getRepairTaxMny()==null?BigDecimal.ZERO:dailyRent.getRepairTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(dailyRenMny);
                        costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }
        List<SettleScrapVO> scrapList = vo.getScrapList();
        if(CollectionUtils.isNotEmpty(scrapList)){
            for(SettleScrapVO dailyRent:scrapList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal dailyRenMny = dailyRent.getCompensateMny()==null?BigDecimal.ZERO:dailyRent.getCompensateMny();
                    BigDecimal dailyRenTaxMny = dailyRent.getCompensateTaxMny()==null?BigDecimal.ZERO:dailyRent.getCompensateTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(dailyRenMny);
                        costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }
        List<SettleLoseVO> loseList = vo.getLoseList();
        if(CollectionUtils.isNotEmpty(loseList)){
            for(SettleLoseVO dailyRent:loseList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal dailyRenMny = dailyRent.getCompensateMny()==null?BigDecimal.ZERO:dailyRent.getCompensateMny();
                    BigDecimal dailyRenTaxMny = dailyRent.getCompensateTaxMny()==null?BigDecimal.ZERO:dailyRent.getCompensateTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(dailyRenMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(dailyRenTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(dailyRenMny);
                        costCtrlDetailVO.setTaxMny(dailyRenTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }
        List<SettleOtherVO> otherList = vo.getOtherList();
        if(CollectionUtils.isNotEmpty(otherList)){
            for(SettleOtherVO dailyRent:otherList){
                if (null!=dailyRent.getSubjectId()&&!"del".equals(dailyRent.getRowState())){
                    BigDecimal detailMny = dailyRent.getSettleMny()==null?BigDecimal.ZERO:dailyRent.getSettleMny();
                    BigDecimal detailTaxMny = dailyRent.getSettleTaxMny()==null?BigDecimal.ZERO:dailyRent.getSettleTaxMny();
                    if(map.containsKey(dailyRent.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(dailyRent.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(dailyRent.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(dailyRent.getSubjectId(),costCtrlDetailVO);
                    }
                }

            }
        }

        if(null!=map&&map.size()>0){
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (null!=vo.getId()){
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList<>(map.values()));
            return ctrlVO;
        }else{
            return null;
        }
    }
    /**
     * 单据管控-累计变更金额大于合同金额
     *
     * @return
     */
    private List<ParamsCheckVO> checkParamsMny(Integer purchaseType, BigDecimal contractTaxMny, BigDecimal settleTaxMny, BigDecimal totalSettleTaxMny, Long orgId, String settleType) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        String CHECK_PARAM_CODE = "";
        if ( "0".equals(settleType)) {//类型（0-过程结算，1-最终结算）
            CHECK_PARAM_CODE = CHECK_PARAM_CODE_GC;
        } else {
            CHECK_PARAM_CODE = CHECK_PARAM_CODE_ZZ;
        }
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    if (2 == purchaseType) {
                        // 集采合同直接赋值为不控制
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        return paramsCheckVOList;
                    } else {
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    }
                    settleTaxMny = settleTaxMny != null ? settleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
                    totalSettleTaxMny = totalSettleTaxMny != null ? totalSettleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(settleTaxMny)
                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny)
                                .append("元，合同金额*").append(roleValue).append("% = ").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 关联保存
     *
     * @param vo
     * @return
     */
    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO vo) {
        SettleEntity entity = baseMapper.selectById(vo.getId());
        if (ListUtil.isNotEmpty(vo.getDailyRentList())) {
            List<SettleDailyRentEntity> dailyList = BeanMapper.mapList(vo.getDailyRentList(), SettleDailyRentEntity.class);
            entity.setDailyRentList(dailyList);
        }
        if (ListUtil.isNotEmpty(vo.getMonthRentList())) {
            List<SettleMonthRentEntity> monthList = BeanMapper.mapList(vo.getMonthRentList(), SettleMonthRentEntity.class);
            entity.setMonthRentList(monthList);
        }
        if (ListUtil.isNotEmpty(vo.getNumRentList())) {
            List<SettleNumRentEntity> numList = BeanMapper.mapList(vo.getNumRentList(), SettleNumRentEntity.class);
            entity.setNumRentList(numList);
        }
        if (ListUtil.isNotEmpty(vo.getRepairList())) {
            List<SettleRepairEntity> repairList = BeanMapper.mapList(vo.getRepairList(), SettleRepairEntity.class);
            entity.setRepairList(repairList);
        }
        if (ListUtil.isNotEmpty(vo.getScrapList())) {
            List<SettleScrapEntity> scrapList = BeanMapper.mapList(vo.getScrapList(), SettleScrapEntity.class);
            entity.setScrapList(scrapList);
        }
        if (ListUtil.isNotEmpty(vo.getLoseList())) {
            List<SettleLoseEntity> loseList = BeanMapper.mapList(vo.getLoseList(), SettleLoseEntity.class);
            entity.setLoseList(loseList);
        }
        if (ListUtil.isNotEmpty(vo.getOtherList())) {
            List<SettleOtherEntity> otherList = BeanMapper.mapList(vo.getOtherList(), SettleOtherEntity.class);
            entity.setOtherList(otherList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, SettleVO.class));

    }

    /**
     * 推送目标成本(成本科目、核酸对象)
     *
     * @param entity
     */
    @Override
    public void costPush(SettleEntity entity) {
        logger.info("开始costPush");
        List<SettleDailyRentEntity> dailyList = entity.getDailyRentList();
        List<SettleMonthRentEntity> monthList = entity.getMonthRentList();
        List<SettleNumRentEntity> numList = entity.getNumRentList();
        List<SettleRepairEntity> repairList = entity.getRepairList();
        List<SettleScrapEntity> scrapList = entity.getScrapList();
        List<SettleLoseEntity> loseList = entity.getLoseList();
        List<SettleOtherEntity> otherList = entity.getOtherList();

        String relationFlag = "1";

        if (ListUtil.isNotEmpty(dailyList)) {
            for (SettleDailyRentEntity detail : dailyList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isNotEmpty(monthList)) {
            for (SettleMonthRentEntity detail : monthList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isNotEmpty(numList)) {
            for (SettleNumRentEntity detail : numList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isNotEmpty(repairList)) {
            for (SettleRepairEntity detail : repairList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isNotEmpty(scrapList)) {
            for (SettleScrapEntity detail : scrapList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isNotEmpty(loseList)) {
            for (SettleLoseEntity detail : loseList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isNotEmpty(otherList)) {
            for (SettleOtherEntity detail : otherList) {
                if (null == detail.getSubjectId() || null == detail.getWbsId()) {
                    relationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(dailyList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(numList)
                && ListUtil.isEmpty(repairList) && ListUtil.isEmpty(scrapList) && ListUtil.isEmpty(loseList)
                && ListUtil.isEmpty(otherList)) {
            relationFlag = "0";
        }
        saveCost(entity,1);//生效状态 0-未生效，1-生效

        // 更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, entity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, relationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        entity.setRelationFlag(relationFlag);
    }

    private void saveCost(SettleEntity entity,Integer effectiveStatus) {
        // 日租
        List<CostDetailVO> costVOList = new ArrayList<>();
        List<SettleDailyRentEntity> dailyList = entity.getDailyRentList();
        if (ListUtil.isNotEmpty(dailyList)) {
            for (SettleDailyRentEntity detail : dailyList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getDailyRentTaxMny());
                costVO.setHappenMny(detail.getDailyRentMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_DAILY");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }
        // 月租
        List<SettleMonthRentEntity> monthList = entity.getMonthRentList();
        if (ListUtil.isNotEmpty(monthList)) {
            for (SettleMonthRentEntity detail : monthList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getMonthRentTaxMny());
                costVO.setHappenMny(detail.getMonthRentMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_MONTH");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }
        // 工程量租
        List<SettleNumRentEntity> numList = entity.getNumRentList();
        if (ListUtil.isNotEmpty(numList)) {
            for (SettleNumRentEntity detail : numList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getNumRentTaxMny());
                costVO.setHappenMny(detail.getNumRentMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_NUM");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }

        // 维修
        List<SettleRepairEntity> repairList = entity.getRepairList();
        if (ListUtil.isNotEmpty(repairList)) {
            for (SettleRepairEntity detail : repairList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getRepairTaxMny());
                costVO.setHappenMny(detail.getRepairMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_REPAIR");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }

        // 报废
        List<SettleScrapEntity> scrapList = entity.getScrapList();
        if (CollectionUtils.isNotEmpty(scrapList)) {
            for (SettleScrapEntity detail : scrapList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getCompensateTaxMny());
                costVO.setHappenMny(detail.getCompensateMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_SCRAP");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }

        // 遗失
        List<SettleLoseEntity> loseList = entity.getLoseList();
        if (CollectionUtils.isNotEmpty(loseList)) {
            for (SettleLoseEntity detail : loseList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getCompensateTaxMny());
                costVO.setHappenMny(detail.getCompensateMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_LOSE");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }


        // 其他
        List<SettleOtherEntity> otherList = entity.getOtherList();
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity detail : otherList) {
                CostDetailVO costVO = new CostDetailVO();
                costVO.setSubjectId(detail.getSubjectId());
                costVO.setSubjectCode(detail.getSubjectCode());
                costVO.setSubjectName(detail.getSubjectName());
                costVO.setWbsId(detail.getWbsId());
                costVO.setWbsCode(detail.getWbsCode());
                costVO.setWbsName(detail.getWbsName());
                costVO.setSourceId(entity.getId());
                costVO.setSourceDetailId(detail.getId());
                costVO.setHappenTaxMny(detail.getSettleTaxMny());
                costVO.setHappenMny(detail.getSettleMny());
                costVO.setHappenDate(entity.getSettleDate());
                costVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costVO.setSourceType("PRO_RMAT_SETTLE");
                costVO.setSourceTabType("PRO_RMAT_SETTLE_OTHER");
                costVO.setProjectId(entity.getProjectId());
                costVO.setSourceBillCode(entity.getBillCode());
                costVO.setSourceBillName(SourceTypeEnum.周转材租赁结算.getTypeName());
                costVO.setSourceBillUrl("/ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
                costVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costVOList.add(costVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costVOList)) {
            logger.info("推送数据--------" + JSONObject.toJSONString(costVOList));
            CommonResponse<String> response = costDetailApi.saveSubject(costVOList);
            logger.info("推送结果--------" + JSONObject.toJSONString(response));
            if (response.isSuccess()) {
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
    }

    /**
     * 删除成本科目、核酸对象
     *
     * @param id
     */
    @Override
    public void pullCost(Long id) {
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SettleEntity::getId, id);
        updateWrapper.set(SettleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);

        costDetailApi.deleteSubject(id);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        ExecutionVO executionVO = this.targetCost(this.selectById(id));

        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("推送目标成本入参：" + JSONObject.toJSONString(executionVO));
        if (!response.isSuccess()) {
            logger.error("推送目标成本失败: , {}", response.getMsg());
            throw new BusinessException(response.getMsg());
        }

        return true;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = baseMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("删除失败!");
        }
    }

    @Override
    public ExecutionVO targetFinishCost(SettleEntity entity) {
        // 计算所有过程结算累计结算金额
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, entity.getContractId());
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        List<SettleEntity> list = this.list(wrapper);
        // 查询合同
        ContractEntity contractEntity = contractService.getById(entity.getContractId());
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setContractId(entity.getContractId());
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setMemo(entity.getMemo());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,entity.getSettleDate()));
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType("BT220310000000002");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(entity.getSettleMny());
        totalVO.setTaxMoney(entity.getSettleTaxMny());
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-prormat-frontend/#/settle/card?id=" + entity.getId());
        executionVO.setDetailList(numDetailExecution(contractEntity, list,entity.getId()));
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public List<DetailExecutionVO> numDetailExecution(ContractEntity contractEntity, List<SettleEntity> list ,Long sourceId) {
        logger.info("目标成本 子表数据组装---：contractEntity{}",JSONObject.toJSONString(contractEntity));
        logger.info("目标成本 子表数据组装---：list{}",JSONObject.toJSONString(list));

        List<DetailExecutionVO> detailList = new ArrayList<>();
        List<Long> settleIdList = list.stream().map(SettleEntity::getId).collect(Collectors.toList());


        //根据结算单查询 租赁
        LambdaQueryWrapper<SettleLeaseEntity> leaseQueryWrapper = new LambdaQueryWrapper<>();
        leaseQueryWrapper.in(SettleLeaseEntity::getSettleId, settleIdList);
        List<SettleLeaseEntity> leaseList = leaseService.list(leaseQueryWrapper);

        // 计算租赁金额
        LambdaQueryWrapper<RentCalculateEntity> calculateWrapper = new LambdaQueryWrapper<>();
        calculateWrapper.eq(RentCalculateEntity::getId, leaseList.stream().map(SettleLeaseEntity::getSourceId).collect(Collectors.toList()));
        calculateWrapper.in(RentCalculateEntity::getBillState, Arrays.asList(1, 3));
        List<RentCalculateEntity> list1 = calculateService.list(calculateWrapper);
        //获取结算子表进行汇总
        List<Long> calculateIdList = list1.stream().map(RentCalculateEntity::getId).collect(Collectors.toList());
        List<ContractMonthRentEntity> monthRentList = contractEntity.getMonthRentList();//月租明细
        List<ContractDailyRentEntity> dailyRentList = contractEntity.getDailyRentList();//日租明细
        List<ContractNumRentEntity> numRentList = contractEntity.getNumRentList();//工程量租明细
        if (dailyRentList != null) {
            List<SettleDailyRentEntity> settleDailyRents = new ArrayList<>();
            if (!settleIdList.isEmpty()){
                //根据结算单查询 日租金额
                LambdaQueryWrapper<SettleDailyRentEntity> dailyQueryWrapper = new LambdaQueryWrapper<>();
                dailyQueryWrapper.in(SettleDailyRentEntity::getSettleId, settleIdList);
                 settleDailyRents = dailyRentService.list(dailyQueryWrapper);
            }
            List<RentCalculateDailyEntity> calculateDailyList = new ArrayList<>();

            if (!calculateIdList.isEmpty()){
                // 计算租赁金额 -- 日租
                LambdaQueryWrapper<RentCalculateDailyEntity> calculateDailyWrapper = new LambdaQueryWrapper<>();
                calculateDailyWrapper.in(RentCalculateDailyEntity::getRentId, calculateIdList);
                calculateDailyList = calculateDailyService.list(calculateDailyWrapper);
            }
            Map<Long, List<SettleDailyRentEntity>> dailyMap = settleDailyRents.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(SettleDailyRentEntity::getMaterialId));
            Map<Long, List<RentCalculateDailyEntity>> calculateDailyMap = calculateDailyList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(RentCalculateDailyEntity::getMaterialId));
            Map<Long, List<ContractDailyRentEntity>> contractDailyMap = dailyRentList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(ContractDailyRentEntity::getMaterialId));
            Map<Long, List<ContractDailyRentEntity>> contractDailyParentMap = dailyRentList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.groupingBy(ContractDailyRentEntity::getMaterialTypeId));
            if (!contractDailyMap.isEmpty()) {
                for (Long materialId : contractDailyMap.keySet()) {
                    BigDecimal sumMny = BigDecimal.ZERO;
                    BigDecimal sumTaxMny = BigDecimal.ZERO;
                    if (!dailyMap.isEmpty()) {
                        if (dailyMap.get(materialId) != null) {
                            List<SettleDailyRentEntity> settleDailyRentEntities = dailyMap.get(materialId);
                            BigDecimal sumRentMny = settleDailyRentEntities.stream().filter(e -> e.getDailyRentMny() != null).map(SettleDailyRentEntity::getDailyRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny = settleDailyRentEntities.stream().filter(e -> e.getDailyRentTaxMny() != null).map(SettleDailyRentEntity::getDailyRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                        }
                    }
                    if (!calculateDailyMap.isEmpty()) {
                        if (calculateDailyMap.get(materialId) != null) {
                            List<RentCalculateDailyEntity> settleDailyRentEntities = calculateDailyMap.get(materialId);
                            BigDecimal sumRentMny = settleDailyRentEntities.stream().filter(e -> e.getDailyRentMny() != null).map(RentCalculateDailyEntity::getDailyRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny = settleDailyRentEntities.stream().filter(e -> e.getDailyRentTaxMny() != null).map(RentCalculateDailyEntity::getDailyRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                        }
                    }
                    List<ContractDailyRentEntity> contractDailyRentEntities = contractDailyMap.get(materialId);
                    BigDecimal contractSumMny = contractDailyRentEntities.stream().filter(e -> e.getRentMny() != null).map(ContractDailyRentEntity::getRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDailyRentEntities.stream().filter(e -> e.getRentTaxMny() != null).map(ContractDailyRentEntity::getRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ContractDailyRentEntity dailyRent = contractDailyRentEntities.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId());
                    detailExecutionVO.setSourceBillId(sourceId);
                    detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                    //判断是否是分类
                    if (dailyRent.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(dailyRent.getMaterialId());
                    }
                    detailExecutionVO.setCode(dailyRent.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                    detailExecutionVO.setName(dailyRent.getMaterialName());
                    detailExecutionVO.setUnitId(dailyRent.getUnitId());
                    detailExecutionVO.setUnitName(dailyRent.getUnitName());
                    detailExecutionVO.setNum(dailyRent.getCount());
                    detailExecutionVO.setSpec(dailyRent.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                    detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                    detailExecutionVO.setTaxRate(dailyRent.getTax());
                    detailExecutionVO.setContractId(sourceId);
                    detailExecutionVO.setRentDayNum(dailyRent.getRentDays()==null?BigDecimal.ZERO:new BigDecimal(dailyRent.getRentDays().toString()));
                    detailExecutionVO.setMemo(dailyRent.getMemo());
                    detailExecutionVO.setContractDetailId(dailyRent.getId());
                    detailList.add(detailExecutionVO);
                }
            }
            if (!contractDailyParentMap.isEmpty()) {
                for (Long materialTypeId : contractDailyParentMap.keySet()) {
                    BigDecimal sumMny = BigDecimal.ZERO;
                    BigDecimal sumTaxMny = BigDecimal.ZERO;
                    List<ContractDailyRentEntity> contractDailyRentEntities = contractDailyParentMap.get(materialTypeId);
                    //获取到当前分类的明细集合
                    if (!settleDailyRents.isEmpty()) {
                        BigDecimal sumRentMny = settleDailyRents.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getDailyRentMny() != null).map(SettleDailyRentEntity::getDailyRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal sumRentTaxMny = settleDailyRents.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getDailyRentTaxMny() != null).map(SettleDailyRentEntity::getDailyRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                        sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                    }
                    if (!calculateDailyList.isEmpty()) {
                        BigDecimal sumRentMny = calculateDailyList.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getDailyRentMny() != null).map(RentCalculateDailyEntity::getDailyRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal sumRentTaxMny = calculateDailyList.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getDailyRentTaxMny() != null).map(RentCalculateDailyEntity::getDailyRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                        sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                    }
                    BigDecimal contractSumMny = contractDailyRentEntities.stream().filter(e -> e.getRentMny() != null).map(ContractDailyRentEntity::getRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDailyRentEntities.stream().filter(e -> e.getRentTaxMny() != null).map(ContractDailyRentEntity::getRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ContractDailyRentEntity dailyRent = contractDailyRentEntities.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId());
                    detailExecutionVO.setSourceBillId(sourceId);
                    detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                    //判断是否是分类
                    if (dailyRent.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(dailyRent.getMaterialId());
                    }
                    detailExecutionVO.setCode(dailyRent.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                    detailExecutionVO.setName(dailyRent.getMaterialName());
                    detailExecutionVO.setUnitId(dailyRent.getUnitId());
                    detailExecutionVO.setUnitName(dailyRent.getUnitName());
                    detailExecutionVO.setNum(dailyRent.getCount());
                    detailExecutionVO.setSpec(dailyRent.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                    detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                    detailExecutionVO.setTaxRate(dailyRent.getTax());
                    detailExecutionVO.setContractId(sourceId);
                    detailExecutionVO.setRentDayNum(dailyRent.getRentDays()==null?BigDecimal.ZERO:new BigDecimal(dailyRent.getRentDays().toString()));
                    detailExecutionVO.setContractDetailId(dailyRent.getId());
                    detailExecutionVO.setMemo(dailyRent.getMemo());
                    detailList.add(detailExecutionVO);
                }
            }
        }
        if (monthRentList != null) {
            List<SettleMonthRentEntity> settleMonthRents = new ArrayList<>();
            if (!settleIdList.isEmpty()){
                //根据结算单查询 月租金额
                LambdaQueryWrapper<SettleMonthRentEntity> monthQueryWrapper = new LambdaQueryWrapper<>();
                monthQueryWrapper.in(SettleMonthRentEntity::getSettleId, settleIdList);
                settleMonthRents = monthRentService.list(monthQueryWrapper);
            }
            List<RentCalculateMonthEntity> calculateMonthList = new ArrayList<>();
            if(!calculateIdList.isEmpty()){
                //计算租赁金额 -- 月租
                LambdaQueryWrapper<RentCalculateMonthEntity> calculateMonthWrapper = new LambdaQueryWrapper<>();
                calculateMonthWrapper.in(RentCalculateMonthEntity::getRentId, settleIdList);
                calculateMonthList= calculateMonthService.list(calculateMonthWrapper);
            }
            Map<Long, List<SettleMonthRentEntity>> monthMap = settleMonthRents.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(SettleMonthRentEntity::getMaterialId));
            Map<Long, List<RentCalculateMonthEntity>> calculateMonthMap = calculateMonthList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(RentCalculateMonthEntity::getMaterialId));
            Map<Long, List<ContractMonthRentEntity>> contractMonthMap = monthRentList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(ContractMonthRentEntity::getMaterialId));
            Map<Long, List<ContractMonthRentEntity>> contractMonthParentMap = monthRentList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.groupingBy(ContractMonthRentEntity::getMaterialTypeId));
            if (!contractMonthMap.isEmpty()) {
                for (Long materialId : contractMonthMap.keySet()) {
                    BigDecimal sumMny = BigDecimal.ZERO;
                    BigDecimal sumTaxMny = BigDecimal.ZERO;
                    if (!monthMap.isEmpty()) {
                        if (monthMap.get(materialId) != null) {
                            List<SettleMonthRentEntity> settleDailyRentEntities = monthMap.get(materialId);
                            BigDecimal sumRentMny = settleDailyRentEntities.stream().filter(e -> e.getMonthRentMny() != null).map(SettleMonthRentEntity::getMonthRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny = settleDailyRentEntities.stream().filter(e -> e.getMonthRentTaxMny() != null).map(SettleMonthRentEntity::getMonthRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);

                        }
                    }
                    if (!calculateMonthMap.isEmpty()) {
                        if (calculateMonthMap.get(materialId) != null) {
                            List<RentCalculateMonthEntity> settleDailyRentEntities2 = calculateMonthMap.get(materialId);
                            BigDecimal sumRentMny2 = settleDailyRentEntities2.stream().filter(e -> e.getMonthRentMny() != null).map(RentCalculateMonthEntity::getMonthRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny2 = settleDailyRentEntities2.stream().filter(e -> e.getMonthRentTaxMny() != null).map(RentCalculateMonthEntity::getMonthRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny2);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny2);
                        }
                    }
                    List<ContractMonthRentEntity> contractDailyRentEntities = contractMonthMap.get(materialId);
                    BigDecimal contractSumMny = contractDailyRentEntities.stream().filter(e -> e.getRentMny() != null).map(ContractMonthRentEntity::getRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDailyRentEntities.stream().filter(e -> e.getRentTaxMny() != null).map(ContractMonthRentEntity::getRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ContractMonthRentEntity monthRentVO = contractDailyRentEntities.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                    detailExecutionVO.setSourceBillId(sourceId);
                    detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                    //判断是否是分类
                    if (monthRentVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                    detailExecutionVO.setName(monthRentVO.getMaterialName());
                    detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                    detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                    detailExecutionVO.setNum(monthRentVO.getCount());
                    detailExecutionVO.setSpec(monthRentVO.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                    detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                    detailExecutionVO.setTaxRate(monthRentVO.getTax());
                    detailExecutionVO.setMemo(monthRentVO.getMemo());
                    detailExecutionVO.setContractId(sourceId);
                    detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                    detailExecutionVO.setRentMonthNum(monthRentVO.getRentMonths()==null?BigDecimal.ZERO:new BigDecimal(monthRentVO.getRentMonths().toString()));
                    detailExecutionVO.setRentDayNum(monthRentVO.getRentDays()==null?BigDecimal.ZERO:new BigDecimal(monthRentVO.getRentDays().toString()));
                    detailExecutionVO.setContractDetailId(monthRentVO.getId());
                    detailList.add(detailExecutionVO);
                }
            }
            if (!contractMonthParentMap.isEmpty()) {
                for (Long materialTypeId : contractMonthParentMap.keySet()) {
                    BigDecimal sumMny = BigDecimal.ZERO;
                    BigDecimal sumTaxMny = BigDecimal.ZERO;
                    if (!monthMap.isEmpty()) {
                        if (!settleMonthRents.isEmpty()) {
                            BigDecimal sumRentMny = settleMonthRents.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getMonthRentMny() != null).map(SettleMonthRentEntity::getMonthRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny = settleMonthRents.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getMonthRentTaxMny() != null).map(SettleMonthRentEntity::getMonthRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);

                        }
                    }
                    if (!calculateMonthMap.isEmpty()) {
                        if (!calculateMonthList.isEmpty()) {
                            BigDecimal sumRentMny2 = calculateMonthList.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getMonthRentMny() != null).map(RentCalculateMonthEntity::getMonthRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny2 = calculateMonthList.stream().filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getMonthRentTaxMny() != null).map(RentCalculateMonthEntity::getMonthRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny2);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny2);
                        }
                    }
                    List<ContractMonthRentEntity> contractDailyRentEntities = contractMonthParentMap.get(materialTypeId);
                    BigDecimal contractSumMny = contractDailyRentEntities.stream().filter(e -> e.getRentMny() != null).map(ContractMonthRentEntity::getRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDailyRentEntities.stream().filter(e -> e.getRentTaxMny() != null).map(ContractMonthRentEntity::getRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ContractMonthRentEntity monthRentVO = contractDailyRentEntities.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId());
                    detailExecutionVO.setSourceBillId(sourceId);
                    detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                    //判断是否是分类
                    if (monthRentVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                    detailExecutionVO.setName(monthRentVO.getMaterialName());
                    detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                    detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                    detailExecutionVO.setNum(monthRentVO.getCount());
                    detailExecutionVO.setSpec(monthRentVO.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                    detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                    detailExecutionVO.setTaxRate(monthRentVO.getTax());
                    detailExecutionVO.setContractId(sourceId);
                    detailExecutionVO.setMemo(monthRentVO.getMemo());
                    detailExecutionVO.setContractDetailId(monthRentVO.getId());
                    detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                    detailExecutionVO.setRentMonthNum(monthRentVO.getRentMonths()==null?BigDecimal.ZERO:new BigDecimal(monthRentVO.getRentMonths().toString()));
                    detailExecutionVO.setRentDayNum(monthRentVO.getRentDays()==null?BigDecimal.ZERO:new BigDecimal(monthRentVO.getRentDays().toString()));
                    detailList.add(detailExecutionVO);
                }
            }
        }
        if (numRentList != null) {
            List<SettleNumRentEntity> settleNumRents = new ArrayList<>();
            if (!settleIdList.isEmpty()){
                //根据结算单查询 工程量金额
                LambdaQueryWrapper<SettleNumRentEntity> numQueryWrapper = new LambdaQueryWrapper<>();
                numQueryWrapper.in(SettleNumRentEntity::getSettleId, settleIdList);
                settleNumRents= numRentService.list(numQueryWrapper);
            }
            List<RentCalculateNumEntity> calculateNumList = new ArrayList<>();
            if (!calculateIdList.isEmpty()){
                //计算租赁金额 -- 工程量
                LambdaQueryWrapper<RentCalculateNumEntity> numNumWrapper = new LambdaQueryWrapper<>();
                numNumWrapper.in(RentCalculateNumEntity::getRentId, calculateIdList);
                calculateNumList= calculateNumService.list(numNumWrapper);
            }
            Map<Long, List<SettleNumRentEntity>> numMap = settleNumRents.stream()
                    .filter(t -> t.getMaterialId() != null)
                    .collect(Collectors.groupingBy(SettleNumRentEntity::getMaterialId));
            Map<Long, List<RentCalculateNumEntity>> calculateNumMap = calculateNumList.stream()
                    .filter(t -> t.getMaterialId() != null)
                    .collect(Collectors.groupingBy(RentCalculateNumEntity::getMaterialId));
            Map<Long, List<ContractNumRentEntity>> contractNumMap = numRentList.stream()
                    .filter(t -> t.getMaterialId() != null)
                    .collect(Collectors.groupingBy(ContractNumRentEntity::getMaterialId));
            Map<Long, List<ContractNumRentEntity>> contractNumParentMap = numRentList.stream()
                    .filter(t -> t.getMaterialId() != null)
                    .collect(Collectors.groupingBy(ContractNumRentEntity::getMaterialId));
            if (!contractNumMap.isEmpty()) {
                for (Long materialId : contractNumMap.keySet()) {
                    BigDecimal sumMny = BigDecimal.ZERO;
                    BigDecimal sumTaxMny = BigDecimal.ZERO;
                    if (!numMap.isEmpty()) {
                        if (numMap.get(materialId) != null) {
                            List<SettleNumRentEntity> settleDailyRentEntities = numMap.get(materialId);
                            BigDecimal sumRentMny = settleDailyRentEntities.stream()
                                    .filter(e -> e.getNumRentMny() != null).map(SettleNumRentEntity::getNumRentMny)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny = settleDailyRentEntities.stream()
                                    .filter(e -> e.getNumRentTaxMny() != null).map(SettleNumRentEntity::getNumRentTaxMny)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                        }
                    }
                    if (!calculateNumMap.isEmpty()) {
                        if (calculateNumMap.get(materialId) != null) {
                            List<RentCalculateNumEntity> settleDailyRentEntities = calculateNumMap.get(materialId);
                            BigDecimal sumRentMny = settleDailyRentEntities.stream()
                                    .filter(e -> e.getNumRentMny() != null)
                                    .map(RentCalculateNumEntity::getNumRentMny)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sumRentTaxMny = settleDailyRentEntities.stream()
                                    .filter(e -> e.getNumRentTaxMny() != null)
                                    .map(RentCalculateNumEntity::getNumRentTaxMny)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                        }
                    }
                    List<ContractNumRentEntity> contractDailyRentEntities = contractNumMap.get(materialId);
                    BigDecimal contractSumMny = contractDailyRentEntities.stream().filter(e -> e.getRentMny() != null).map(ContractNumRentEntity::getRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDailyRentEntities.stream().filter(e -> e.getRentTaxMny() != null).map(ContractNumRentEntity::getRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ContractNumRentEntity numRentVO = contractDailyRentEntities.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(numRentVO.getId() == null ? IdWorker.getId() : numRentVO.getId());
                    detailExecutionVO.setSourceBillId(sourceId);
                    detailExecutionVO.setCategoryId(numRentVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(numRentVO.getMaterialTypeName());
                    //判断是否是分类
                    if (numRentVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(numRentVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(numRentVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(numRentVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(numRentVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                    detailExecutionVO.setName(numRentVO.getMaterialName());
                    detailExecutionVO.setUnitId(numRentVO.getUnitId());
                    detailExecutionVO.setUnitName(numRentVO.getUnitName());
                    detailExecutionVO.setNum(numRentVO.getCount());
                    detailExecutionVO.setSpec(numRentVO.getSpec());
                    detailExecutionVO.setPrice(numRentVO.getUnitPrice());
                    detailExecutionVO.setTaxPrice(numRentVO.getUnitTaxPrice());
                    detailExecutionVO.setTaxRate(numRentVO.getTax());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setContractId(sourceId);
                    detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                    detailExecutionVO.setQuantityNum(numRentVO.getQuantities());
                    detailExecutionVO.setMemo(numRentVO.getMemo());
                    detailExecutionVO.setContractDetailId(numRentVO.getId());

                    detailList.add(detailExecutionVO);
                }
            }
            if (!contractNumParentMap.isEmpty()) {
                for (Long materialTypeId : contractNumParentMap.keySet()) {
                    BigDecimal sumMny = BigDecimal.ZERO;
                    BigDecimal sumTaxMny = BigDecimal.ZERO;
                    if (!settleNumRents.isEmpty()) {
                        BigDecimal sumRentMny = settleNumRents.stream()
                                .filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getNumRentMny() != null).map(SettleNumRentEntity::getNumRentMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal sumRentTaxMny = settleNumRents.stream()
                                .filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getNumRentTaxMny() != null).map(SettleNumRentEntity::getNumRentTaxMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny);
                        sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny);
                    }
                    if (!calculateNumList.isEmpty()) {
                        BigDecimal sumRentMny2 = calculateNumList.stream()
                                .filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getNumRentMny() != null)
                                .map(RentCalculateNumEntity::getNumRentMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal sumRentTaxMny2 = calculateNumList.stream()
                                .filter(e -> materialTypeId.equals(e.getMaterialTypeId()) && e.getNumRentTaxMny() != null)
                                .map(RentCalculateNumEntity::getNumRentTaxMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        sumMny = ComputeUtil.safeAdd(sumMny, sumRentMny2);
                        sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, sumRentTaxMny2);
                    }
                    List<ContractNumRentEntity> contractDailyRentEntities = contractNumMap.get(materialTypeId);
                    BigDecimal contractSumMny = contractDailyRentEntities.stream().filter(e -> e.getRentMny() != null).map(ContractNumRentEntity::getRentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDailyRentEntities.stream().filter(e -> e.getRentTaxMny() != null).map(ContractNumRentEntity::getRentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ContractNumRentEntity numRentVO = contractDailyRentEntities.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(numRentVO.getId() == null ? IdWorker.getId() : numRentVO.getId());
                    detailExecutionVO.setSourceBillId(sourceId);
                    detailExecutionVO.setCategoryId(numRentVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(numRentVO.getMaterialTypeName());
                    //判断是否是分类
                    if (numRentVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(numRentVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(numRentVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(numRentVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(numRentVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());//设置周转材
                    detailExecutionVO.setName(numRentVO.getMaterialName());
                    detailExecutionVO.setUnitId(numRentVO.getUnitId());
                    detailExecutionVO.setUnitName(numRentVO.getUnitName());
                    detailExecutionVO.setNum(numRentVO.getCount());
                    detailExecutionVO.setSpec(numRentVO.getSpec());
                    detailExecutionVO.setPrice(numRentVO.getUnitPrice());
                    detailExecutionVO.setTaxPrice(numRentVO.getUnitTaxPrice());
                    detailExecutionVO.setTaxRate(numRentVO.getTax());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setContractId(sourceId);
                    detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                    detailExecutionVO.setQuantityNum(numRentVO.getQuantities());
                    detailExecutionVO.setMemo(numRentVO.getMemo());
                    detailExecutionVO.setContractDetailId(numRentVO.getId());
                    detailList.add(detailExecutionVO);
                }
            }
        }
        return detailList;
    }

}
