/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.ownrmat.bean.OwnEntity;
import com.ejianc.business.pro.ownrmat.service.IOwnService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.vo.OwnDetailVO;
import com.ejianc.business.pro.ownrmat.vo.OwnVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="own")
public class OwnBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IOwnService ownService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IValidateService validateContract;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OwnVO ownVO = this.ownService.queryDetail(billId);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(OwnEntity::getEffectTime, (Object)new Date());
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.ownService.update((Wrapper)lambd);
        StoreManageVO vo = new StoreManageVO();
        vo.setStoreId(ownVO.getProjectId());
        vo.setOutEffectiveON(Boolean.valueOf(true));
        vo.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93);
        ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date lastShareDate = null;
        try {
            lastShareDate = sdf.parse(ownVO.getAmortizationCycle());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isNotEmpty((Collection)ownVO.getOwnDetailList())) {
            for (OwnDetailVO detailVO : ownVO.getOwnDetailList()) {
                FlowVO flowVO = new FlowVO();
                flowVO.setSourceId(detailVO.getFlowSourceId());
                flowVO.setSourceDetailId(detailVO.getFlowSourceDetailId());
                flowVO.setShareMny(detailVO.getAmortizationMny());
                flowVO.setShareTaxMny(detailVO.getAmortizationMnyTax());
                flowVO.setLastShareDate(lastShareDate);
                flowVOList.add(flowVO);
            }
        }
        vo.setFlowVOList(flowVOList);
        CommonResponse commonResponse = this.storeManageApi.updateShareMny(vo);
        this.logger.info("\u66f4\u65b0\u644a\u9500\u91d1\u989d\u5ba1\u6279\u901a\u8fc7\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)commonResponse));
        if (commonResponse.isSuccess()) {
            this.logger.info("\u63a8\u9001\u6210\u672c---");
            this.ownService.costPush(ownVO);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OwnVO ownVO = this.ownService.queryDetail(billId);
        this.validateContract.validateProject(ownVO.getProjectId(), null, null, "\u5f03\u5ba1");
        this.ownService.validateTime(ownVO, "\u5f03\u5ba1");
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(OwnEntity::getEffectTime, null);
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.ownService.update((Wrapper)lambd);
        StoreManageVO vo = new StoreManageVO();
        vo.setStoreId(ownVO.getProjectId());
        vo.setOutEffectiveON(Boolean.valueOf(false));
        vo.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93);
        ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
        String lastAmortizationCycle = this.ownService.getLastAmortizationCycle(ownVO.getProjectId(), ownVO.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date lastShareDate = null;
        if (lastAmortizationCycle != null && lastAmortizationCycle.length() > 0) {
            try {
                lastShareDate = sdf.parse(lastAmortizationCycle);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ownVO.getOwnDetailList())) {
            for (OwnDetailVO detailVO : ownVO.getOwnDetailList()) {
                FlowVO flowVO = new FlowVO();
                flowVO.setSourceId(detailVO.getFlowSourceId());
                flowVO.setSourceDetailId(detailVO.getFlowSourceDetailId());
                flowVO.setShareMny(detailVO.getAmortizationMny());
                flowVO.setShareTaxMny(detailVO.getAmortizationMnyTax());
                flowVO.setLastShareDate(lastShareDate);
                flowVOList.add(flowVO);
            }
        }
        vo.setFlowVOList(flowVOList);
        CommonResponse commonResponse = this.storeManageApi.updateShareMny(vo);
        if (commonResponse.isSuccess()) {
            this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
            this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)ownVO.getId());
            CommonResponse stringCommonResponse = this.costDetailApi.updateCostDetail(ownVO.getId(), Integer.valueOf(0));
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, new Object[]{ownVO.getId()});
            updateWrapper.set(OwnEntity::getRelationFlag, (Object)"0");
            this.ownService.update((Wrapper)updateWrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

