package com.ejianc.business.pro.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.api.IAssistRmatInContractApi;
import com.ejianc.business.assist.rmat.enums.RmatPriceSourceTypeEnum;
import com.ejianc.business.outrmat.api.IAssistRmatOutContractApi;
import com.ejianc.business.pro.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.pro.pricelib.enums.OutFlagEnum;
import com.ejianc.business.pro.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.pro.pricelib.utils.DateUtils;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.business.pro.pricelib.vo.PriceLibVO;
import com.ejianc.business.pro.pricelib.vo.PriceTrendVo;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.ISettleService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.pro.pricelib.bean.PriceContractEntity;
import com.ejianc.business.pro.pricelib.service.IPriceContractService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材合同价格数据
 * 
 * @author generator
 * 
 */
@Service("priceContractService")
public class PriceContractServiceImpl extends BaseServiceImpl<PriceContractMapper, PriceContractEntity> implements IPriceContractService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private ISettleService settlementService;
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAssistRmatInContractApi assistRmatInContractApi;
    @Autowired
    private IAssistRmatOutContractApi assistRmatOutContractApi;


    @Override
    public void savePriceContractByTiming(Date date) {
        logger.info("========================价格库合同明细定时任务执行开始===========================");
        QueryParam queryParam = new QueryParam();
        List<ContractEntity> contractEntityList;
        String outLogDate = "";
        if (date != null) {
            // 日期不为空，则取大于上日日期数据
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            logger.info("执行定时任务，查询参数：{}", qDate);
            contractEntityList = baseMapper.getContractListByTime(qDate);
        }
        else {
            // 日期为空，默认为初始化，取提交后的数据
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            queryParam.getParams().put("rent_type",new Parameter(QueryParam.NE, 1));//不查内租的
            contractEntityList = contractService.queryList(queryParam, false);
        }
        logger.info("执行日期：{}，查询合同结果：{}", outLogDate, JSONObject.toJSONString(contractEntityList));
        // 合同列表为空，不处理
        if (CollectionUtils.isEmpty(contractEntityList)) return;
        // 1.查询合同明细
        List<Long> contractIdList = contractEntityList.stream().map(ContractEntity::getId).collect(Collectors.toList());
        List<ContractDailyRentEntity> dailyRentList = baseMapper.getContractDayDetailListByContractId(contractIdList);
        List<ContractMonthRentEntity > monthRentList = baseMapper.getContractMonDetailListByContractId(contractIdList);
        List<ContractNumRentEntity > numRentList = baseMapper.getContractNumDetailListByContractId(contractIdList);
        // 合同明细列表为空，不处理
        if (CollectionUtils.isEmpty(dailyRentList)&&CollectionUtils.isEmpty(monthRentList)&&CollectionUtils.isEmpty(numRentList)) return;

        // 2.查询材料内码
        List<Long> materialTypeIdList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(dailyRentList)){
            materialTypeIdList.addAll(dailyRentList.stream().map(ContractDailyRentEntity::getMaterialTypeId)
                    .distinct().collect(Collectors.toList()));
        }
        if(CollectionUtils.isNotEmpty(monthRentList)){
            materialTypeIdList.addAll(monthRentList.stream().map(ContractMonthRentEntity::getMaterialTypeId)
                    .distinct().collect(Collectors.toList()));
        }
        if(CollectionUtils.isNotEmpty(numRentList)){
            materialTypeIdList.addAll(numRentList.stream().map(ContractNumRentEntity::getMaterialTypeId)
                    .distinct().collect(Collectors.toList()));
        }

        CommonResponse<List<MaterialCategoryVO>> materialResponse = materialApi
                .queryCategoryListByIds(materialTypeIdList);
        Map<Long, String> materialCategoryMap = new HashMap<>();
        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(materialResponse));
        if (materialResponse.isSuccess()) {
            List<MaterialCategoryVO> materialCategoryVOList = materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream()
                    .collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode,
                            (key1, key2) -> key2));
        }

        // 3.查询项目信息
        List<Long> projectIdList = contractEntityList.stream().map(ContractEntity::getProjectId)
                .distinct().collect(Collectors.toList());
        CommonResponse<List<ProjectPoolDTO>> projectResponse = projectSetApi.getProjectListIds(projectIdList);
        logger.info("查询项目地址，查询结果：{}", JSONObject.toJSONString(projectResponse));
        Map<Long, String> projectAreaMap = new HashMap<>();
        Map<Long, String> projectAreaNameMap = new HashMap<>();
        if (projectResponse.isSuccess()) {
            List<ProjectPoolDTO> projectPoolList = projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getArea()))
                    .collect(Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getAreaName()))
                    .collect(Collectors
                            .toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }

        // 4.查询最终结算日
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter(QueryParam.IN, contractIdList));
        settleParam.getParams().put("settle_type", new Parameter(QueryParam.EQ, 1));
        settleParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays
                .asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<SettleEntity> settlementEntityList = settlementService.queryList(settleParam, false);
        Map<Long, Date> settlementDateMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(settlementEntityList)) {
            settlementDateMap = settlementEntityList.stream().collect(Collectors.toMap(SettleEntity::getContractId,
                    SettleEntity::getSettleDate, (key1, key2) -> key2));
        }

        // 材料明细按合同id分组
        Map<Long, List<ContractDailyRentEntity>> detailDayMap = dailyRentList.stream()
                .collect(Collectors.groupingBy(ContractDailyRentEntity::getContractId));

        Map<Long, List<ContractMonthRentEntity>> detailMonMap = monthRentList.stream()
                .collect(Collectors.groupingBy(ContractMonthRentEntity::getContractId));

        Map<Long, List<ContractNumRentEntity>> detailNumMap = numRentList.stream()
                .collect(Collectors.groupingBy(ContractNumRentEntity::getContractId));




        // 处理合同及合同明细
        // 进行插入数据组装
        List<PriceContractEntity> saveEntityList = new ArrayList<>();
        for (ContractEntity entity : contractEntityList) {
            List<ContractDailyRentEntity> dayDetailList = detailDayMap.get(entity.getId());

            List<ContractMonthRentEntity> monDetailList = detailMonMap.get(entity.getId());

            List<ContractNumRentEntity> numDetailList = detailNumMap.get(entity.getId());

            if (CollectionUtils.isEmpty(dayDetailList)&&CollectionUtils.isEmpty(monDetailList)&&CollectionUtils.isEmpty(numDetailList)) continue;

            if(CollectionUtils.isNotEmpty(dayDetailList)){
                for (ContractDailyRentEntity detailEntity : dayDetailList) {
                    // 材料id为空不做价格库处理（大类不处理）
                    if (detailEntity.getMaterialId() == null) continue;
                    PriceContractEntity priceContractEntity = BeanMapper.map(entity, PriceContractEntity.class);
                    priceContractEntity = ChangeContractDay(priceContractEntity,detailEntity);
                    priceContractEntity.setRentCalculationType("0");//日租
                    priceContractEntity.setArea(projectAreaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                    priceContractEntity.setAreaName(projectAreaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                    priceContractEntity.setSourceId(entity.getId());
                    priceContractEntity.setSourceType(RmatPriceSourceTypeEnum.周转材租赁合同.getCode());
                    priceContractEntity.setTargetResultId(entity.getTargetResultId());
                    // 子表信息
                    priceContractEntity.setMaterialInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId())); // 分类内码，查询获取
                    priceContractEntity.setSettlementDate(settlementDateMap.get(entity.getId())); // 最终结算日
                    saveEntityList.add(priceContractEntity);
                }
            }

            if(CollectionUtils.isNotEmpty(monDetailList)){
                for (ContractMonthRentEntity detailEntity : monDetailList) {
                    // 材料id为空不做价格库处理（大类不处理）
                    if (detailEntity.getMaterialId() == null) continue;
                    PriceContractEntity priceContractEntity = BeanMapper.map(entity, PriceContractEntity.class);
                    priceContractEntity = ChangeContractMon(priceContractEntity,detailEntity);
                    priceContractEntity.setRentCalculationType("1");//月租
                    priceContractEntity.setArea(projectAreaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                    priceContractEntity.setAreaName(projectAreaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                    priceContractEntity.setSourceId(entity.getId());
                    priceContractEntity.setSourceType(RmatPriceSourceTypeEnum.周转材租赁合同.getCode());
                    priceContractEntity.setTargetResultId(entity.getTargetResultId());
                    // 子表信息
                    priceContractEntity.setMaterialInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId())); // 分类内码，查询获取
                    priceContractEntity.setSettlementDate(settlementDateMap.get(entity.getId())); // 最终结算日
                    saveEntityList.add(priceContractEntity);
                }
            }

           if(CollectionUtils.isNotEmpty(numDetailList)){
               for (ContractNumRentEntity detailEntity : numDetailList) {
                   // 材料id为空不做价格库处理（大类不处理）
                   if (detailEntity.getMaterialId() == null) continue;
                   PriceContractEntity priceContractEntity = BeanMapper.map(entity, PriceContractEntity.class);
                   priceContractEntity = ChangeContractNum(priceContractEntity,detailEntity);
                   priceContractEntity.setRentCalculationType("2");//工程量租
                   priceContractEntity.setArea(projectAreaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                   priceContractEntity.setAreaName(projectAreaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                   priceContractEntity.setSourceId(entity.getId());
                   priceContractEntity.setSourceType(RmatPriceSourceTypeEnum.周转材租赁合同.getCode());
                   priceContractEntity.setTargetResultId(entity.getTargetResultId());
                   // 子表信息
                   priceContractEntity.setMaterialInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId())); // 分类内码，查询获取
                   priceContractEntity.setSettlementDate(settlementDateMap.get(entity.getId())); // 最终结算日
                   saveEntityList.add(priceContractEntity);
               }
           }
        }


        logger.info("获取设备公司数据前数据条数：" + saveEntityList.size());

        //获取周转材租入数据
        CommonResponse<List<PriceContractVO>> corpRentResponse = assistRmatInContractApi.getPriceContractDataByAssistRmatIn(date != null ? "1" : "0");
        logger.info("获取辅料周转材租入合同数据，查询结果：{}", JSONObject.toJSONString(corpRentResponse));
        if (corpRentResponse.isSuccess()) {
            List<PriceContractVO> corpRentContractList = corpRentResponse.getData();
            saveEntityList.addAll(BeanMapper.mapList(corpRentContractList, PriceContractEntity.class));
        }

        //获取周转材租出数据
        CommonResponse<List<PriceContractVO>> corpOutResponse = assistRmatOutContractApi.getPriceContractDataByAssistRmatOut(date != null ? "1" : "0");
        logger.info("获取辅料周转材租出合同数据，查询结果：{}", JSONObject.toJSONString(corpOutResponse));
        if (corpOutResponse.isSuccess()) {
            List<PriceContractVO> corpOutContractList = corpOutResponse.getData();
            saveEntityList.addAll(BeanMapper.mapList(corpOutContractList, PriceContractEntity.class));
        }

        logger.info("获取辅料周转材数据后数据条数：" + saveEntityList.size());



        // 查询是否为修改
        if (CollectionUtils.isEmpty(saveEntityList)) return;
        List<Long> sourceDetailIdList = saveEntityList.stream().map(PriceContractEntity::getSourceDetailId)
                .collect(Collectors.toList());
        // 查询数据库
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceDetailId", new Parameter(QueryParam.IN, sourceDetailIdList));
        List<PriceContractEntity> queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty(queryPriceList)) {
            // sourceDetailId,id
            Map<Long, PriceContractEntity> queryPriceMap = queryPriceList.stream()
                    .collect(Collectors.toMap(PriceContractEntity::getSourceDetailId, Function.identity(),
                            (key1, key2) -> key2));
            for (PriceContractEntity entity : saveEntityList) {
                PriceContractEntity queryEntity = queryPriceMap.get(entity.getSourceDetailId());
                if (queryEntity != null) {
                    entity.setId(queryEntity.getId());
                    entity.setOutFlag(queryEntity.getOutFlag());
                    entity.setCreateTime(queryEntity.getCreateTime());
                    entity.setCreateUserCode(queryEntity.getCreateUserCode());
                }
            }
        }
        // 批量变更保存数据
        logger.info("入库数据：{}", JSONObject.toJSONString(saveEntityList));
        super.saveOrUpdateBatch(saveEntityList);
        // 删除bill_state非1和3的数据
        // 不使用物理删除，使用逻辑删除
        QueryWrapper<PriceContractEntity> wrapper = new QueryWrapper<>();
        wrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove(wrapper, false);
//        baseMapper.delPriceContractByBillState();
        // 删除dr!=0的数据
        // 删除的id
        List<Long> delIdList = saveEntityList.stream().filter(t -> t.getDr() != 0).map(PriceContractEntity::getId)
                .collect(Collectors.toList());
        logger.info("删除数据id：{}",JSONObject.toJSONString(delIdList));
        if (CollectionUtils.isNotEmpty(delIdList)) {
            super.removeByIds(delIdList, false);
//            String delIdListStr = delIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
//            baseMapper.delPriceContractByIds(delIdListStr);
//            baseMapper.delPriceContractByIds(delIdList);
        }
        logger.info("========================价格库合同明细定时任务执行结束===========================");
    }

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        // 初始化参数
        logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }
        else {
            throw new BusinessException("查询日期不能为空");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        logger.info("查询价格库，返回：{}", JSONObject.toJSONString(priceLibList));
        IPage<PriceLibVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), priceLibList.size());
        // 进行分页处理
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param) {
        // 初始化参数
        logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }
        else {
            throw new BusinessException("查询日期不能为空");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList;
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceLibList)) throw new BusinessException("查询详情失败！");
        return priceLibList.get(0);
    }

    @Override
    public List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId) {
        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, materialTypeId));
        if (StringUtils.isNotEmpty(materialTypeId)) {
            String[] materialTypeIdList = materialTypeId.split(",");
//            queryParam.getParams().put("materialTypeId", new Parameter(QueryParam.IN, materialTypeIdList));
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            for (String str : materialTypeIdList) {
                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("material_innerCode", new Parameter(QueryParam.LIKE_RIGHT, str));
                c1.getComplexParams().add(c2);
            }
            queryParam.getComplexParams().add(c1);
        }
        return this.queryPriceLibListAll(startDate, endDate, null, queryParam);
    }

    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate",QueryParam.DESC);
            param.getOrderMap().put("contractMny",QueryParam.DESC);
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        List<PriceContractVO> voList;
        IPage<PriceContractVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) return pageDate;
        voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
//        voList.sort(Comparator.comparing(PriceContractVO::getSignDate).reversed()
//                .thenComparing(PriceContractVO::getContractMny).reversed().reversed());
//        voList.sort(Comparator.comparing(PriceContractVO::getSignDate).reversed());
        // 处理URL
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            int targetType = vo.getTargetResultId() == null ? 1 : 0;
            String url = "/ejc-prormat-frontend/#/contract/contractMultiCards?id="
                    + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag()
                    + "&performanceStatus=" + vo.getPerformanceStatus() + "&cardType=addCard";
            if (myOrgList.contains(vo.getOrgId())) {
                vo.setContractUrl(url);
            }
        }
        for (PriceContractVO vo : voList) {
            vo.setRentCalculationName(this.getRentTypeName(vo.getRentCalculationType()));
        }
        // 进行分页处理
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceTrendVo> rtnList;
        // list转Map，同一天只会有一个价格
        Map<String, PriceTrendVo> trendMap = new HashMap<>();
        // 查询价格库合同明细
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream()
                    .collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List<BigDecimal> priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List<BigDecimal> taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                    taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                }
                PriceTrendVo vo;
                String dateStr = DateUtils.transformationDefaultDate(entry.getKey());
                if (trendMap.containsKey(dateStr)) {
                    vo = trendMap.get(dateStr);
                }
                else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractMinPrice(Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractTaxMinPrice(Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        // map转list
        rtnList = new ArrayList<>(trendMap.values());
        // 按照日期排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = super.selectById(id);
        if (entity == null) throw new BusinessException("明细不存在");
        entity.setOutFlag(OutFlagEnum.已移除.getCode());
        super.saveOrUpdate(entity, false);
    }

    /**
     * 查询组织权限
     *
     * @return 权限列表
     */
    private List<Long> queryOrgIdList() {
        CommonResponse<List<Long>> orgIdListResponse = priceDepotPowerSetApi
                .queryOrgList(InvocationInfoProxy.getOrgId());
        logger.info("查询组织权限，查询结果：{}", JSONObject.toJSONString(orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("查询组织权限失败:" + orgIdListResponse.getMsg());
        }
        return orgIdListResponse.getData();
    }
    /**
     * 查询当前组织本下
     * @return 组织本下list
     */
    private List<Long> getMyOrgList() {
        CommonResponse<List<OrgVO>> orgVOResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<OrgVO> orgVOList = orgVOResp.getData();
        if (CollectionUtils.isNotEmpty(orgVOList)) {
            return orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }
    /**
     * 校验查询条件
     *
     * @param param 查询条件
     * @return 日期
     */
    private Map<String, Date> checkQueryParam(QueryParam param) {
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }
        else {
            throw new BusinessException("查询日期不能为空");
        }
        if (!paramMap.containsKey("materialId")) {
            throw new BusinessException("查询材料不能为空！");
        }
        Map<String, Date> rtnMap = new HashMap<>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    /**
     * 查询价格库信息(参照查询列表查询都走此方法)
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 查询结果
     * @param param     查询条件
     * @return 查询结果
     */
    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList,
                                                  QueryParam param) {

        // 查询合同信息
//        priceLibList.addAll(this.queryPriceContractGroupByMaterialId(priceLibList, startDate, orgIdList, param));
//        priceLibList.addAll(this.queryPriceCheckGroupByMaterialId(priceLibList, startDate, endDate, orgIdList,
//        param));
//        priceLibList.addAll(this.queryPriceSettlementGroupByMaterialId(priceLibList, startDate, endDate, orgIdList,
//        param));
        Map<Long, PriceLibVO> map = new HashMap<>();
        this.queryPriceContractGroupByMaterialId(map, startDate, orgIdList, param);
        logger.info("查询合同后结果：{}", JSONObject.toJSONString(map));
        this.queryPriceGuide(map);
        logger.info("查询指导价后结果：{}", JSONObject.toJSONString(map));
        List<PriceLibVO> priceLibList = new ArrayList<>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
//            priceLibList.sort(Comparator.comparing(PriceLibVO::getMaterialName, Comparator.nullsLast(String::compareTo)));
            priceLibList.sort(Comparator.comparing(PriceLibVO::getMaterialCode, Comparator.nullsLast(String::compareTo)));
        }
        logger.info("查询后结果：{}", JSONObject.toJSONString(priceLibList));
        return priceLibList;
    }

    /**
     * 查询合同价格库信息
     *
     * @param libMap    价格库组装列表
     * @param startDate 开始日期
     * @param orgIdList 权限列表
     * @return 合同价格库列表
     */
    private void queryPriceContractGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate,
                                                     List<Long> orgIdList, QueryParam param) {
        // 截止到当前日期状态为履约中的合同+已终止、已结束的合同取对应最终结算日期大于等于开始日期的合同
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) return;
        // 按照材料Id分组
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream()
                .collect(Collectors.groupingBy(PriceContractEntity::getMaterialId));
        // 按照材料Id分组(每个材料只有一行)
//        Map<Long, List<PriceLibVO>> libMap = priceLibList.stream()
//                .collect(Collectors.groupingBy(PriceLibVO::getMaterialId));
        // 汇总信息
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO; // 数量
            BigDecimal mny = BigDecimal.ZERO; // 金额(无税)
            BigDecimal taxRate = BigDecimal.ZERO; // 税率
            BigDecimal taxMny = BigDecimal.ZERO; // 金额(含税)
            BigDecimal avgPrice = BigDecimal.ZERO; // 合同均价(无税)
            // 合同最高价(无税)
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价(无税)
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String priceArea = minPrice + "-" + maxPrice; // 合同价格区间（无税）
            BigDecimal taxAvgPrice = BigDecimal.ZERO; // 合同均价（含税）
            // 合同最高价（含税）
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价（含税）
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice; // 合同价格区间（含税）
            for (PriceContractEntity entity : value) {
                num = num.add(entity.getContractNum()==null?BigDecimal.ZERO:entity.getContractNum());
                mny = mny.add(entity.getContractMny()==null?BigDecimal.ZERO:entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            PriceLibVO priceLibVO;
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            }
            else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setMaterialInnerCode(priceContract.getMaterialInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setRentCalculationType(priceContract.getRentCalculationType());
            priceLibVO.setRentCalculationName(this.getRentTypeName(priceContract.getRentCalculationType()));
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
        }
    }


    public String getRentTypeName(String RentType){
        if("0".equals(RentType)){
            return "日租";
        }else if("1".equals(RentType)){
            return "月租";
        }else {
            return "工程量租";
        }
    }

    /**
     * 查询符合条件的价格库合同明细
     *
     * @param startDate 开始日期
     * @param orgIdList 权限列表
     * @param param     查询参数
     * @return 查询结果
     */
    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList,
                                                             QueryParam param) {
        // 截止到当前日期状态为履约中的合同+已终止、已结束的合同取对应最终结算日期大于等于开始日期的合同
        QueryParam contractParam = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter(QueryParam.EQ, OutFlagEnum.未移除.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty(param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        // 履约中
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("performance_status", new Parameter(QueryParam.EQ, 2));
        c1.getComplexParams().add(c2);
        // 已终止+已结束  最终结算日期大于等于开始日期的合同
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("performance_status", new Parameter(QueryParam.IN, Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter(QueryParam.GE, startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        logger.info("查询合同价格库，查询参数：{}", JSONObject.toJSONString(contractParam));
        return super.queryList(contractParam, false);
    }

    /**
     * 计算税率（（含税/无税 - 1）*100）
     *
     * @param taxMny 含税金额
     * @param mny    无税金额
     * @return 税率
     */
    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, BigDecimal.ROUND_HALF_UP).subtract(BigDecimal.ONE).multiply(b);
    }

    /**
     * 查询物资指导价
     *
     * @param libMap 价格库信息
     */
    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) return;
        List<Long> materialIdList = new ArrayList<>(libMap.keySet());
        List<PriceGuideDetailEntity> list = priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) return;
        Map<Long, PriceGuideDetailEntity> guideMap = list.stream().collect(Collectors
                .toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (guideMap.containsKey(materialId)) {
                PriceGuideDetailEntity guide = guideMap.get(materialId);
                BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
                BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                vo.setGuidePriceArea(min + "-" + max);
            }
        }
    }
    public PriceContractEntity ChangeContractDay(PriceContractEntity priceContractEntity,ContractDailyRentEntity detailEntity){
        priceContractEntity.setSourceDetailId(detailEntity.getId());
        priceContractEntity.setMaterialId(detailEntity.getMaterialId());
        priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
        priceContractEntity.setMaterialName(detailEntity.getMaterialName());
        priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractEntity.setSpec(detailEntity.getSpec());
        priceContractEntity.setUnitId(detailEntity.getUnitId());
        priceContractEntity.setUnitName(detailEntity.getUnitName());
        priceContractEntity.setContractNum(detailEntity.getCount());
        priceContractEntity.setContractPrice(detailEntity.getUnitPrice());
        priceContractEntity.setContractMny(detailEntity.getRentMny());
        priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
        priceContractEntity.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractEntity.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractEntity.setMemo(detailEntity.getMemo());

        priceContractEntity.setOutFlag(OutFlagEnum.未移除.getCode());
        priceContractEntity.setId(null);
        priceContractEntity.setCreateTime(null);
        priceContractEntity.setCreateUserCode(null);
        priceContractEntity.setUpdateTime(null);
        priceContractEntity.setUpdateUserCode(null);
        priceContractEntity.setDr(detailEntity.getDr());
        return priceContractEntity;
    }



    public PriceContractEntity ChangeContractMon(PriceContractEntity priceContractEntity,ContractMonthRentEntity detailEntity){
        priceContractEntity.setSourceDetailId(detailEntity.getId());
        priceContractEntity.setMaterialId(detailEntity.getMaterialId());
        priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
        priceContractEntity.setMaterialName(detailEntity.getMaterialName());
        priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractEntity.setSpec(detailEntity.getSpec());
        priceContractEntity.setUnitId(detailEntity.getUnitId());
        priceContractEntity.setUnitName(detailEntity.getUnitName());
        priceContractEntity.setContractNum(detailEntity.getCount());
        priceContractEntity.setContractPrice(detailEntity.getUnitPrice());
        priceContractEntity.setContractMny(detailEntity.getRentMny());
        priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
        priceContractEntity.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractEntity.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractEntity.setMemo(detailEntity.getMemo());

        priceContractEntity.setOutFlag(OutFlagEnum.未移除.getCode());
        priceContractEntity.setId(null);
        priceContractEntity.setCreateTime(null);
        priceContractEntity.setCreateUserCode(null);
        priceContractEntity.setUpdateTime(null);
        priceContractEntity.setUpdateUserCode(null);
        priceContractEntity.setDr(detailEntity.getDr());
        return priceContractEntity;
    }

    public PriceContractEntity ChangeContractNum(PriceContractEntity priceContractEntity,ContractNumRentEntity detailEntity){
        priceContractEntity.setSourceDetailId(detailEntity.getId());
        priceContractEntity.setMaterialId(detailEntity.getMaterialId());
        priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
        priceContractEntity.setMaterialName(detailEntity.getMaterialName());
        priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractEntity.setSpec(detailEntity.getSpec());
        priceContractEntity.setUnitId(detailEntity.getUnitId());
        priceContractEntity.setUnitName(detailEntity.getUnitName());
        priceContractEntity.setContractNum(detailEntity.getCount());
        priceContractEntity.setContractPrice(detailEntity.getUnitPrice());
        priceContractEntity.setContractMny(detailEntity.getRentMny());
        priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
        priceContractEntity.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractEntity.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractEntity.setMemo(detailEntity.getMemo());

        priceContractEntity.setOutFlag(OutFlagEnum.未移除.getCode());
        priceContractEntity.setId(null);
        priceContractEntity.setCreateTime(null);
        priceContractEntity.setCreateUserCode(null);
        priceContractEntity.setUpdateTime(null);
        priceContractEntity.setUpdateUserCode(null);
        priceContractEntity.setDr(detailEntity.getDr());
        return priceContractEntity;
    }
}
