package com.ejianc.business.pro.pricelib.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.pro.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.pro.pricelib.service.IPriceGuideService;
import com.ejianc.business.pro.pricelib.vo.PriceGuideVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 周转材指导价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceGuide")
public class PriceGuideController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RMAT_GUIDE_CODE";//此处需要根据实际修改

    @Autowired
    private IPriceGuideService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceGuideVO> saveOrUpdate(@RequestBody PriceGuideVO saveOrUpdateVO) {
        PriceGuideEntity entity = BeanMapper.map(saveOrUpdateVO, PriceGuideEntity.class);
        // parentOrgCode如果是空的，则需要查询赋值
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 查询材料内码
        List<PriceGuideDetailEntity> guideDetailList = entity.getPriceGuideDetailList();
        List<Long> materialTypeIdList = guideDetailList.stream().map(PriceGuideDetailEntity::getMaterialTypeId)
                .distinct().collect(Collectors.toList());
        CommonResponse<List<MaterialCategoryVO>> materialResponse = materialApi
                .queryCategoryListByIds(materialTypeIdList);
        Map<Long, String> materialCategoryMap = new HashMap<>();
        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(materialResponse));
        if (materialResponse.isSuccess()) {
            List<MaterialCategoryVO> materialCategoryVOList = materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream()
                    .collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode,
                            (key1, key2) -> key2));
        }
        //循环list通过map获取内码
        for (PriceGuideDetailEntity detailEntity : guideDetailList) {
            detailEntity.setMaterialInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId()));
        }
    	service.saveOrUpdate(entity, false);
    	PriceGuideVO vo = BeanMapper.map(entity, PriceGuideVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceGuideVO> queryDetail(Long id) {
    	PriceGuideEntity entity = service.selectById(id);
    	PriceGuideVO vo = BeanMapper.map(entity, PriceGuideVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceGuideVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PriceGuideVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceGuideVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceGuideVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PriceGuideEntity> page = service.queryPage(param,false);
        IPage<PriceGuideVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceGuideVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PriceGuideEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PriceGuide-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPriceGuideData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceGuideVO>> refPriceGuideData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceGuideEntity> page = service.queryPage(param,false);
        IPage<PriceGuideVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceGuideVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description saveOrUpdate 启停用
     */
    @RequestMapping(value = "/startUpdate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceGuideVO> startUpdate(@RequestParam Long id, Integer state) {
        PriceGuideEntity priceGuideEntity = service.selectById(id);
        priceGuideEntity.setFlag(state);
        service.saveOrUpdate(priceGuideEntity, false);
        PriceGuideVO vo = BeanMapper.map(priceGuideEntity, PriceGuideVO.class);
        return CommonResponse.success("启用停用状态调整成功！",vo);
    }
    /**
     * @Description saveOrUpdate 复制子表
     */
    @RequestMapping(value = "/copyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PriceGuideDetailVO>> copyDetail(@RequestParam Long id) {
        PriceGuideEntity priceGuideEntity = service.selectById(id);
        List<PriceGuideDetailEntity> detailList = priceGuideEntity.getPriceGuideDetailList();
        //将id设置为空
        detailList.forEach(detail -> {
            detail.setId(IdWorker.getId());
            detail.setRowState("add");
            detail.setVersion(null);
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setCreateUserCode(null);
            detail.setUpdateUserCode(null);
        });
        return CommonResponse.success("复制子表成功！",BeanMapper.mapList(detailList, PriceGuideDetailVO.class));
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "priceDetail-import.xlsx", "指导价明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PriceGuideDetailVO> successList = new ArrayList<>();
        List<PriceGuideDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String,MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
                if(!materialRes.isSuccess()){
                    return CommonResponse.error(materialRes.getMsg());
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PriceGuideDetailVO detailVO = new PriceGuideDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = datas.get(0);
                    detailVO.setMaterialCode(materialCode);
                    if(map.containsKey(materialCode)){
                        MaterialVO materialVO =   map.get(materialCode);
                        detailVO.setMaterialTypeId(materialVO.getCategoryId());
                        detailVO.setMaterialTypeName(materialVO.getCategoryName());
                        detailVO.setMaterialId(materialVO.getId());
                        detailVO.setMaterialName(materialVO.getName());
                        detailVO.setSpec(materialVO.getSpec());
                        detailVO.setUnitId(materialVO.getUnitId());
                        detailVO.setUnitName(materialVO.getUnitName());
                    }else{
                        detailVO.setErrorMsg("材料编码不匹配！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String minMny = datas.get(1);
                        detailVO.setMinPrice(StringUtils.isNotBlank(minMny) ? new BigDecimal(minMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("最低价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String maxMny = datas.get(2);
                        detailVO.setMaxPrice(StringUtils.isNotBlank(maxMny) ? new BigDecimal(maxMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("最高价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
