package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.bean.ChangeEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.service.IChangeService;
import com.ejianc.business.pro.rmat.service.IContractFileService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service("contractFileService")
public class ContractFileServiceImpl implements IContractFileService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private ISignatureCommonApi signatureCommonApi;


    @Override
    public JSONObject getSignedFileInfo(Long billId, String billType) {
        JSONObject resp = new JSONObject();

        List<ContractVO> voList = new ArrayList<>();
        ContractVO vo = new ContractVO();
        if (Objects.equals("contract", billType)) {
            ContractEntity entity = contractService.selectById(billId);
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setBillType(BillTypeEnum.周转材租赁合同.getCode());
            vo.setSourceType(billType);
        }else {
            ChangeEntity entity = changeService.selectById(billId);
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setBillType(BillTypeEnum.周转材租赁合同变更.getCode());
            vo.setSourceType(billType);
        }
        voList.add(vo);


        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(voList);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            throw new BusinessException("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            throw new BusinessException("未获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        if("contract".equals(billType)) {
            ContractEntity contract = contractService.selectById(billId);
            if (Objects.equals(contract.getSignedFileId(), null)) {
                contract.setSignedFileId(signedFileInfo.getFileId());
                contractService.saveOrUpdate(contract, false);
            }
        } else {
            ChangeEntity contractChange = changeService.selectById(billId);
            if (Objects.equals(contractChange.getSignedChangeFileId(), null)) {
                contractChange.setSignedChangeFileId(signedFileInfo.getFileId());
                changeService.saveOrUpdate(contractChange, false);
            }
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return resp;
    }

}
