package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.bean.StopEntity;
import com.ejianc.business.pro.rmat.bean.StopEntity;
import com.ejianc.business.pro.rmat.enums.BillTypeEnum;
import com.ejianc.business.pro.rmat.mapper.StopMapper;
import com.ejianc.business.pro.rmat.service.IMaterialService;
import com.ejianc.business.pro.rmat.service.IStopService;
import com.ejianc.business.pro.rmat.utils.DateUtil;
import com.ejianc.business.pro.rmat.utils.MaterialConstant;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.vo.MaterialVO;
import com.ejianc.business.pro.rmat.vo.StopDetailVO;
import com.ejianc.business.pro.rmat.vo.StopVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 停用单实体
 * 
 * @author generator
 * 
 */
@Service("stopService")
public class StopServiceImpl extends BaseServiceImpl<StopMapper, StopEntity> implements IStopService{

    private static final String BILL_CODE = "PRO_RMAT_STOP";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private PushSupUtil pushSupUtil;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.停用单.getCode();
    private static final String BILL_NAME = BillTypeEnum.停用单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/stop/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/prormat/stop/billDel";


    @Override
    public StopVO saveOrUpdate(StopVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
//        this.validateContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        materialService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.停用单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        this.validateTime(saveOrUpdateVO, MaterialConstant.保存);
        // 校验数量不能大于可参照数量
        this.validateNum(saveOrUpdateVO);
        StopEntity entity = BeanMapper.map(saveOrUpdateVO, StopEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 汇总材料分类
        List<StopDetailVO> detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);

        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, StopVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<StopEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的停用单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param stopVO
     * @return
     */
    @Override
    public String validateTime(StopVO stopVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", stopVO.getContractId());
        if(stopVO.getId() != null){
            params.put("billType", MaterialConstant.停用单);
            params.put("billId", stopVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);

        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(stopVO.getStopTime(), lastDate, maxTimeMap, stopVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(stopVO.getStopTime())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(StopDetailVO vo : stopVO.getDetailList()){
            if(ValidateUtil.compareDate(vo.getStopTime(), lastDate, maxTimeMap, vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getStopTime())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(StopEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        StopEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                StopEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(StopEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = baseMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("删除失败!");
        }
    }

    /**
     * 校验数量不能大于可参照数量
     * @param stopVO
     * @return
     */
    private String validateNum(StopVO stopVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, stopVO.getContractId()));
        List<MaterialVO> list = materialService.queryCheckList(param, "stop");
        Map<String, MaterialVO> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId() + "|" + x.getRentCalculationType(), Function.identity()));
        String key = null;
        for(StopDetailVO vo : stopVO.getDetailList()){
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType();
            if(map.containsKey(key) && vo.getNum().compareTo(map.get(key).getRefNum()) > 0){
                throw new BusinessException("子表数量大于可参照数量");
            }
        }
        return "校验通过！";
    }
}
