package com.ejianc.business.pro.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.pro.pricelib.bean.PriceHistoryEntity;
import com.ejianc.business.pro.pricelib.mapper.PriceHistoryMapper;
import com.ejianc.business.pro.pricelib.service.IPriceContractService;
import com.ejianc.business.pro.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.pro.pricelib.service.IPriceHistoryService;
import com.ejianc.business.pro.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.pro.pricelib.vo.PriceHistoryVO;
import com.ejianc.business.pro.pricelib.vo.PriceLibVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材合同历史价格数据
 * 
 * @author generator
 * 
 */
@Service("priceHistoryService")
public class PriceHistoryServiceImpl extends BaseServiceImpl<PriceHistoryMapper, PriceHistoryEntity> implements IPriceHistoryService{

    //TODO 待补值
    private static final String PRICE_CHECK_CODE = "";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initPriceHistory() {
        logger.info("---历史价格init开始---");
        //1.先执行全删除操作
        logger.info("---数据全删除操作开始---");
        baseMapper.delPriceHistoryAll();
        logger.info("---数据插入操作开始---");
        //2.执行数据插入
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.材料价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.材料价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        logger.info("返回参数--{}",JSONObject.toJSONString(data));
        if(CollectionUtils.isEmpty(data)){//为空结束
            return;
        }
        Date nowDate = new Date();
        Map<String,PriceHistoryVO>  fatherPriceHistoryMap = new HashMap<>();//父级
        Map<String,PriceHistoryVO> sonPriceHistoryMap = new HashMap<>();//子级
        for (PriceDepotParamSetDTO paramSetDTO : data) {
            if(null==paramSetDTO.getSource()){
                continue;
            }
            Date beforeDate = getMonthBefore(nowDate,paramSetDTO.getCycle());
            logger.info("当前时间--{}-前-{}--个月时间--{}", DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",nowDate),paramSetDTO.getCycle().toString(),DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",beforeDate));
            if(!paramSetDTO.getLeafFlag()){//获取父级明细
                List<PriceLibVO> priceLibVOS = priceContractService.queryPriceLibList(beforeDate, nowDate, paramSetDTO.getCategoryId());
                if(CollectionUtils.isEmpty(priceLibVOS)){
                    continue;
                }
                List<PriceHistoryVO> priceHistoryVOS = BeanMapper.mapList(priceLibVOS, PriceHistoryVO.class);
                Map<String,PriceHistoryVO>  priceHistoryVOMap= priceHistoryVOS.stream().map(item -> {
                    item.setId(item.getMaterialId());
                    return item;
                }).collect(Collectors.toMap(t->t.getId().toString(), Function.identity(), (key1, key2) -> key2));
                fatherPriceHistoryMap.putAll(priceHistoryVOMap);
            }//获取子级结算明细 分类为空则跳过
            else if(StringUtils.isNotEmpty(paramSetDTO.getCategoryId())){
                List<PriceLibVO> priceLibVOS = priceContractService.queryPriceLibList(beforeDate, nowDate, paramSetDTO.getCategoryId());
                if(CollectionUtils.isEmpty(priceLibVOS)){
                    continue;
                }
                List<PriceHistoryVO> priceHistoryVOS = BeanMapper.mapList(priceLibVOS, PriceHistoryVO.class);
                Map<String,PriceHistoryVO>  priceHistoryVOMap= priceHistoryVOS.stream().map(item -> {
                    item.setId(item.getMaterialId());
                    return item;
                }).collect(Collectors.toMap(t->t.getId().toString(), Function.identity(), (key1, key2) -> key2));
                duplicates(sonPriceHistoryMap,priceHistoryVOMap);
            }
        }
        duplicates(fatherPriceHistoryMap,sonPriceHistoryMap);
        if(!fatherPriceHistoryMap.isEmpty()){
            List<PriceHistoryEntity> priceHistoryEntities = BeanMapper.mapList(fatherPriceHistoryMap.values(), PriceHistoryEntity.class);
            logger.info("保存数据大小{}条",priceHistoryEntities.size());
            super.saveOrUpdateBatch(priceHistoryEntities);
        }
        logger.info("---数据插入操作结束---");
    }
    /*去除重复
     * 后面覆盖前面
     * */
    public void duplicates(Map<String,PriceHistoryVO> oldMap,Map<String,PriceHistoryVO> nowMap){
        if(!oldMap.isEmpty()){
            for (String s : nowMap.keySet()) {
                if(oldMap.containsKey(s)){
                    oldMap.remove(s);
                }
            }
        }
        oldMap.putAll(nowMap);
    }
    /**
     * 获取当前日期n个月前的时间
     * @param nowTime 当前时间
     *  @param num 月份周期
     * @return
     */
    public  Date getMonthBefore(Date nowTime,BigDecimal num){
        if(null==num){
            num = new BigDecimal(0);
        }
        int month = num.intValue();
        Date beforeDate = DateUtil.subMonths(nowTime, month);//获取前几个月时间
        return beforeDate;
    }



    @Override
    public MaterialPriceHistoryApiVO getMaterialPriceHistoryApiVO(Long materialId,String rentCalculationType) {
        PriceHistoryEntity priceHistoryEntity = null;

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.EQ, materialId));
        queryParam.getParams().put("rent_calculation_type", new Parameter(QueryParam.EQ, rentCalculationType));
        List<PriceHistoryEntity> priceHistoryList = super.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(priceHistoryList)){
            priceHistoryEntity = priceHistoryList.get(0);
        }else{
            return new MaterialPriceHistoryApiVO();
        }
        MaterialPriceHistoryApiVO vo = BeanMapper.map(priceHistoryEntity, MaterialPriceHistoryApiVO.class);
        Map<Long, MaterialPriceHistoryApiVO> guidePriceMap = new HashMap<>();
        guidePriceMap.put(materialId,vo);
        this.queryPriceGuide(guidePriceMap);
        vo.setHistoryPriceArea(vo.getContractPriceArea());
        vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
        String guidePriceArea= guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea()==null?"":guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea();
        vo.setGuidePriceArea(guidePriceArea);
        vo.setGuideTaxPriceArea(guidePriceArea);//目前指导价含税无税一样
        return vo;
    }

    @Override
    public Map<Long, MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOMap(List<Long> materialIds,String rentCalculationType) {
        Map<Long, MaterialPriceHistoryApiVO> map = new HashMap<>();
        if(CollectionUtils.isEmpty(materialIds)){
            return map;
        }
        List<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = this.getMaterialPriceHistoryApiVOS(materialIds,rentCalculationType);
        if(CollectionUtils.isEmpty(materialPriceHistoryApiVOS)){
            return map;
        }
        map = materialPriceHistoryApiVOS.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity(), (key1, key2) -> key2));
        return map;
    }

    @Override
    public List<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOS(List<Long> materialIds,String rentCalculationType) {
        if(CollectionUtils.isEmpty(materialIds)){
            return new ArrayList<>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, materialIds));
        queryParam.getParams().put("rent_calculation_type", new Parameter(QueryParam.EQ, rentCalculationType));
        List<PriceHistoryEntity> priceHistoryList = super.queryList(queryParam);
        if(CollectionUtils.isEmpty(priceHistoryList)){
            return new ArrayList<>();
        }
        List<MaterialPriceHistoryApiVO> historyApiVOS = BeanMapper.mapList(priceHistoryList, MaterialPriceHistoryApiVO.class);
        if(CollectionUtils.isNotEmpty(priceHistoryList)){
            Map<Long, MaterialPriceHistoryApiVO> guidePriceMap = historyApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
            this.queryPriceGuide(guidePriceMap);
            for (MaterialPriceHistoryApiVO vo : historyApiVOS) {
                vo.setHistoryPriceArea(vo.getContractPriceArea());
                vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
                String guidePriceArea= guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea()==null?"":guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea();
                vo.setGuidePriceArea(guidePriceArea);
                vo.setGuideTaxPriceArea(guidePriceArea);//目前指导价含税无税一样
            }
        }
        return  historyApiVOS;
    }

    /**
     * 查询物资指导价
     *
     * @param libMap 价格库信息
     */
    private void queryPriceGuide(Map<Long, MaterialPriceHistoryApiVO> libMap) {
        if (libMap.isEmpty()) return;
        List<Long> materialIdList = new ArrayList<>(libMap.keySet());
        List<PriceGuideDetailEntity> list = priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) return;
        Map<Long, PriceGuideDetailEntity> guideMap = list.stream().collect(Collectors
                .toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, MaterialPriceHistoryApiVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            MaterialPriceHistoryApiVO vo = entry.getValue();
            if (guideMap.containsKey(materialId)) {
                PriceGuideDetailEntity guide = guideMap.get(materialId);
                BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
                BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                vo.setGuidePriceArea(min + "-" + max);
            }
        }
    }
    //价格库参数控制
    @Override
    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialPriceHistoryApiVO> detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        Integer priceCheckType = materialPriceHistoryApiVO.getPriceCheckType();
        if(priceCheckType==null){
            logger.info("priceCheckType为空直接返回结果");
            return paramsCheckVO;
        }
        if(CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        String name="周转材租赁合同";
        String MAX_CODE ="P-11m2X40116";
        String MIN_CODE ="P-wyHzSH0117";
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询高价比例
//        CommonResponse<BillParamVO> maxParamByCode = paramConfigApi.getBillParamByCode(MAX_CODE);
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史高价控制参数失败");
        }
        //查询高价比例
//        CommonResponse<BillParamVO> minParamByCode = paramConfigApi.getBillParamByCode(MIN_CODE);
        CommonResponse<List<BillParamVO>> minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE,orgId);
        if(!minParamByCode.isSuccess() && null == minParamByCode.getData()){
            logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史低价控制参数失败");
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info(name+"历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info(name+"历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName(name+"价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(name+"单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if(price.compareTo(minPriceParam) < 0){
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName(name+"价小于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(name+"单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }


    @Override
    public Boolean historyPriceShow(Integer priceCheckType) {
        Boolean flag = true;
        return flag;
    }
}
