package com.ejianc.business.pro.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.rmat.bean.NeedPlanEntity;
import com.ejianc.business.pro.rmat.service.INeedPlanDetailService;
import com.ejianc.business.pro.rmat.service.INeedPlanService;
import com.ejianc.business.pro.rmat.vo.NeedPlanDetailRefVO;
import com.ejianc.business.pro.rmat.vo.NeedPlanDetailVO;
import com.ejianc.business.pro.rmat.vo.NeedPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 周转材需用计划主实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("needPlan")
public class NeedPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private INeedPlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private INeedPlanDetailService needPlanDetailService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<NeedPlanVO> saveOrUpdate(@RequestBody NeedPlanVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<NeedPlanVO> queryDetail(Long id) {
    	NeedPlanEntity entity = service.selectById(id);
    	NeedPlanVO vo = BeanMapper.map(entity, NeedPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<NeedPlanVO> vos) {
        service.removeByIds(vos.stream().map(NeedPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<NeedPlanVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("construction");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<NeedPlanEntity> page = service.queryPage(param,false);
        IPage<NeedPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), NeedPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<NeedPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("NeedPlan-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refNeedPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<NeedPlanVO>> refNeedPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<NeedPlanEntity> page = service.queryPage(param,false);
        IPage<NeedPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), NeedPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 计划参照-列表二级树
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/needPlanRef")
    public CommonResponse<JSONObject> planRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                              @RequestParam(value = "condition", required = false) String condition,
                                              @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("planFlag", new Parameter("eq", true));
        queryParam.getParams().put("materialId1", new Parameter(QueryParam.SQL,"material_id is not null"));
        Long projectId = null;
        Integer materialType = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        Page<NeedPlanDetailVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        PlanVO planVO = new PlanVO();
        planVO.setTenantId(InvocationInfoProxy.getTenantid());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<NeedPlanDetailVO> list = needPlanDetailService.geMaterialDetail(page,wrapper);
        List<Long> materialListId = new ArrayList<>();
        for (NeedPlanDetailVO planDetailVO : list){
            planDetailVO.setParentId(999L);
            planDetailVO.setTid(planDetailVO.getMaterialId());
            materialListId.add(planDetailVO.getMaterialId());
        }
        QueryParam queryDetailParam = new QueryParam();
        queryDetailParam.getParams().put("materialId", new Parameter(QueryParam.IN, materialListId));
        List<NeedPlanDetailRefVO> planVOList = service.getPlanByMaterialId(materialListId,wrapper);
        //遍历集合,添加children, 计划明细
        for(NeedPlanDetailVO planDetailVO : list){
            ArrayList<NeedPlanDetailRefVO> planDetail = new ArrayList<>();
            for(NeedPlanDetailRefVO planVOChild : planVOList){
                if (planDetailVO.getMaterialId().equals(planVOChild.getMaterialId())){
                    planVOChild.setParentId(planDetailVO.getMaterialId());
                    planVOChild.setOrderNumsSum(planVOChild.getSurplusNumsSum());
                    planVOChild.setRowState("add");
                    planVOChild.setSourceName(planVOChild.getPlanBillCode()+planVOChild.getPlanEmployeeName());
                    planDetail.add(planVOChild);
                }
            }
            planDetailVO.setPlanDetail(planDetail);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }
}
