package com.ejianc.business.pro.rmat.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.rmat.bean.RentCalculateEntity;
import com.ejianc.business.pro.rmat.mapper.CheckMapper;
import com.ejianc.business.pro.rmat.service.IRentCalculateService;
import com.ejianc.business.pro.rmat.vo.SourceBliVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/rentCalculateApi/")
public class RentCalculateApi {

    @Autowired
    private IRentCalculateService service;
    @Autowired
    private CheckMapper checkMapper;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * 根据合同ID(contractId)查询该合同下已生效租金计算金额之和
     * @param contractId
     * @return
     */
    @GetMapping("/queryRentMny")
    public CommonResponse<BigDecimal> queryRentMny(@RequestParam(value = "contractId") Long contractId) {
        BigDecimal totalRentTaxMny = new BigDecimal("0.00");
        Map<String, BigDecimal> totalMny = new HashMap<>();
        QueryWrapper<RentCalculateEntity> query = new QueryWrapper<>();
        query.select("IFNULL(SUM(rent_tax_mny), 0) AS totalRentTaxMny");
        query.eq("contract_id", contractId);
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map map = service.getMap(query);
        totalMny.put("totalRentTaxMny", null != map && null != map.get("totalRentTaxMny") ? new BigDecimal(map.get("totalRentTaxMny").toString()) : BigDecimal.ZERO);
        totalRentTaxMny = totalMny.get("totalRentTaxMny").compareTo(new BigDecimal(0E-8)) == 0 ? new BigDecimal(0):totalMny.get("totalRentTaxMny");
        return CommonResponse.success("查询成功！", totalRentTaxMny);
    }

    /**
     * 周转材管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  周转材验收单、结算单数量；
     * 2、协同单据数量：查该供应商在本下项目生效的  周转材验收单（订单）、结算单（已签字）的数量；
     * 3、比例：协同单据数量/累计单据数量；
     * @param supplierId
     * @param dateIn
     * @return
     */
    @GetMapping(value = "getSourceBliVO")
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn){
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        SourceBliVO vo= checkMapper.getSourceBliVO(supplierId,orgIds,dateIn);
        return CommonResponse.success("查询成功！", vo);
    }

}
