package com.ejianc.business.process.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ApplicationStateEnum {
    申请中(0,"申请中"),
    施工中(1,"施工中"),
    已完工(2,"已完工"),
    七天内未办理(3,"7天内未办理"),
    办理中(4,"办理中"),
    办理完成(5,"办理完成"),
    超时未办理(6,"超时未办理");

    private Integer code;
    private String name;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    ApplicationStateEnum(Integer code,String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    private static Map<Integer, ApplicationStateEnum> enumMap = new HashMap<>();
    static {
        enumMap = EnumSet.allOf(ApplicationStateEnum.class).stream().collect(Collectors.toMap(ApplicationStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ApplicationStateEnum getEnumByCode(Integer code) {
        return enumMap.get(code);
    }
}
