package com.ejianc.business.prosub.api;

import com.ejianc.business.prosub.hystrix.PriceContractCollectHystrix;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 合同价格库API
 */
@FeignClient(name = "ejc-prosub-web", url = "${common.env.feign-client-url}", path = "ejc-prosub-web", fallback = PriceContractCollectHystrix.class)
public interface IPriceContractCollectApi {

    // 查询多个档案清单历史价格
    @PostMapping(value = "/api/priceContractCollectApi/getPriceContractByDocIds")
    CommonResponse<List<PriceContractCollectVO>> getPriceContractByDocIds(@RequestBody List<Long> docIds);
}
