package com.ejianc.business.prosub.dataModel.vo;


import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 数据模型-合同劳务分包清单执行情况vo
 * 数据模型-分包合同/项目 vo
 * 合同+分包清单编号+劳务末级清单(同一清单添加多条，显示多条，不合并)
 * 项目+分包清单编号+劳务末级清单(同一清单添加多条，合并)
 */
public class ContractDataModelVO implements Serializable {


    private static final long serialVersionUID = 1L;
    /**
     * 来源类型：档案 doc    总计划 plan    目标成功 target    定标结果新增 targetResult
     * 本行清单来源于“档案”“目标成本”“总计划”"定标结果"
     */
    private String sourceType;

    /**
     * 来源类型：档案 doc    总计划 plan    目标成功 target    定标结果新增 targetResult
     * 本行清单来源于“档案”“目标成本”“总计划”"定标结果"
     * 清单来源
     */
    private String sourceTypeName;

    /**
     * 所属合同Id
     */
    private Long contractId;

    /**
     * 档案Id
     */
    private Long docId;

    /**
     * 清单id
     */
    private Long detailId;

    /**
     * 清单编号
     */
    private String detailCode;

    /**
     * 清单名称
     */
    private String detailName;

    /**
     * 工作内容
     */
    private String detailWorkContent;

    /**
     * 计量规则
     */
    private String detailMeasurementRules;

    /**
     * 单位
     */
    private String detailUnit;

    /**
     * 合同量   工程量   查本行清单在该合同下签订数量（包含审批中、已提交、审批通过）
     */
    private BigDecimal detailNum;

    /**
     * 合同金额  合同清单金额（无税）
     */
    private BigDecimal detailMny;

    /**
     * 合同清单金额（含税）   查本行清单在该合同下含税金额（包含审批中、已提交、审批通过）
     */
    private BigDecimal detailTaxMny;

    /**
     * 累计合同过程结算量  合同量   查本行清单在该合同的过程结算单数量累计值（包含审批中、已提交、审批通过）
     */
    private BigDecimal totalProcessNum;

    /**
     * 累计合同过程结算金额（无税）
     */
    private BigDecimal totalProcessMny;

    /**
     * 累计合同过程结算金额（含税）   查本行清单在该合同的过程结算单含税金额累计值（包含审批中、已提交、审批通过）
     */
    private BigDecimal totalProcessTaxMny;

    /**
     * 累计合同节点结算量  合同量   查本行清单在该合同的节点结算单数量累计值（包含审批中、已提交、审批通过）
     */
    private BigDecimal totalNodeNum;

    /**
     * 累计合同节点结算金额（无税）
     */
    private BigDecimal totalNodeMny;

    /**
     * 累计合同节点结算金额（含税）   查本行清单在该合同的节点结算单含税金额累计值（包含审批中、已提交、审批通过）
     */
    private BigDecimal totalNodeTaxMny;

    /**
     * 累计合同最终结算量  合同量   查本行清单在该合同的最终结算单数量累计值（包含审批中、已提交、审批通过）
     */
    private BigDecimal totalFinishNum;

    /**
     * 累计合同最终结算金额（无税）
     */
    private BigDecimal totalFinishMny;

    /**
     * 累计合同最终结算金额（含税）   查本行清单在该合同的最终结算单含税金额累计值（包含审批中、已提交、审批通过）
     */
    private BigDecimal totalFinishTaxMny;


    //项目分包清单执行情况
    private BigDecimal planNum; // 总计划量
    private BigDecimal planTaxMny; // 总计划金额
    private BigDecimal targetNum; // 目标量
    private BigDecimal targetMny; // 目标金额
    private BigDecimal targetRemainderNum; // 目标剩余量
    private BigDecimal targetRemainderMny; // 目标剩余金额


    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public BigDecimal getTotalFinishTaxMny() {
        return totalFinishTaxMny;
    }

    public void setTotalFinishTaxMny(BigDecimal totalFinishTaxMny) {
        this.totalFinishTaxMny = totalFinishTaxMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getDetailId() {
        return detailId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getTotalProcessNum() {
        return totalProcessNum;
    }

    public void setTotalProcessNum(BigDecimal totalProcessNum) {
        this.totalProcessNum = totalProcessNum;
    }

    public BigDecimal getTotalProcessMny() {
        return totalProcessMny;
    }

    public void setTotalProcessMny(BigDecimal totalProcessMny) {
        this.totalProcessMny = totalProcessMny;
    }

    public BigDecimal getTotalProcessTaxMny() {
        return totalProcessTaxMny;
    }

    public void setTotalProcessTaxMny(BigDecimal totalProcessTaxMny) {
        this.totalProcessTaxMny = totalProcessTaxMny;
    }

    public BigDecimal getTotalNodeNum() {
        return totalNodeNum;
    }

    public void setTotalNodeNum(BigDecimal totalNodeNum) {
        this.totalNodeNum = totalNodeNum;
    }

    public BigDecimal getTotalNodeMny() {
        return totalNodeMny;
    }

    public void setTotalNodeMny(BigDecimal totalNodeMny) {
        this.totalNodeMny = totalNodeMny;
    }

    public BigDecimal getTotalNodeTaxMny() {
        return totalNodeTaxMny;
    }

    public void setTotalNodeTaxMny(BigDecimal totalNodeTaxMny) {
        this.totalNodeTaxMny = totalNodeTaxMny;
    }

    public BigDecimal getTotalFinishNum() {
        return totalFinishNum;
    }

    public void setTotalFinishNum(BigDecimal totalFinishNum) {
        this.totalFinishNum = totalFinishNum;
    }

    public BigDecimal getTotalFinishMny() {
        return totalFinishMny;
    }

    public void setTotalFinishMny(BigDecimal totalFinishMny) {
        this.totalFinishMny = totalFinishMny;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getPlanTaxMny() {
        return planTaxMny;
    }

    public void setPlanTaxMny(BigDecimal planTaxMny) {
        this.planTaxMny = planTaxMny;
    }

    public BigDecimal getTargetNum() {
        return targetNum;
    }

    public void setTargetNum(BigDecimal targetNum) {
        this.targetNum = targetNum;
    }

    public BigDecimal getTargetMny() {
        return targetMny;
    }

    public void setTargetMny(BigDecimal targetMny) {
        this.targetMny = targetMny;
    }

    public BigDecimal getTargetRemainderNum() {
        return targetRemainderNum;
    }

    public void setTargetRemainderNum(BigDecimal targetRemainderNum) {
        this.targetRemainderNum = targetRemainderNum;
    }

    public BigDecimal getTargetRemainderMny() {
        return targetRemainderMny;
    }

    public void setTargetRemainderMny(BigDecimal targetRemainderMny) {
        this.targetRemainderMny = targetRemainderMny;
    }
}
