package com.ejianc.business.prosub.api;

import com.ejianc.business.prosub.hystrix.ContractHystrix;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.prosub.vo.SourceBliVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 合同管理API
 */
@FeignClient(name = "ejc-prosub-web", url = "${common.env.feign-client-url}", path = "ejc-prosub-web", fallback = ContractHystrix.class)
public interface IContractApi {

    // 修改合同履约状态
    @PostMapping(value = "/api/contract/updatePerformanceStatusById")
    public CommonResponse<ContractVO> updatePerformanceStatusById(@RequestBody ContractVO vo);

    @GetMapping(value = "/api/contract/getLinkUrl")
    CommonResponse<String> getLinkUrl(@RequestParam("contractId") Long contractId);

    @GetMapping(value = "/api/contract/getSourceBliVO")
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn);

    @PostMapping(value = "/api/contract/updateFilingStatus")
    CommonResponse<ContractVO> updateFilingStatus(@RequestBody ContractVO vo);

    @GetMapping(value = "/api/contract/queryContractByTargetResultId")
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value = "targetResultIdList") List<String> targetResultIdList);
}
