package com.ejianc.business.process.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.prosub.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 零工登记 子表 清单明细
 * 
 * @author generator
 * 
 */
public class RegistrationDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Long registrationId; // 零工登记id
    private java.lang.String contractName; // 合同名称
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractCode; // 合同编码
    private java.lang.Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private java.lang.Integer supplementFlag; // 合同类型：0-主合同 1-补充协议
    private java.lang.String listName; // 清单名称
    private java.lang.Long listId; // 清单id
    private java.lang.Integer listType; // 清单来源 0- 选择，1-新增
    private java.lang.Long sourceId; // 清单来源id 合同id
    private java.math.BigDecimal workNum; // 工程量
    private java.math.BigDecimal price; // 单价
    private java.math.BigDecimal taxPrice; // 单价(含税)
    private java.math.BigDecimal listTaxRate; // 税率
    private java.math.BigDecimal listTaxMny; // 总额 自动计算 不支持修改(含税)
    private java.math.BigDecimal listMny; // 总额 自动计算 不支持修改
    private java.math.BigDecimal listTax; // 税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 结束时间 大于等于开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 开始时间 小于等于结束日期
    private String fileType;//文件类型
    /**
     * 来源类型(1:从合同清单，2:从其他费用选择，3:从价格调整及增补项选择)
     */
    private Integer sourceType;
    private BigDecimal detailSubNum; // 分包报送工程量
    private BigDecimal detailSubTaxPrice; // 分包报送单价
    private BigDecimal detailSubTaxMny; // 分包报送金额
    private BigDecimal detailProjectNum; // 项目部工程量
    private BigDecimal detailProjectTaxPrice; // 项目部单价
    private BigDecimal detailProjectTaxMny; // 项目部金额
    private BigDecimal detailBranchNum; // 分公司审批工程量
    private BigDecimal detailBranchTaxPrice; // 分公司审批单价
    private BigDecimal detailBranchTaxMny; // 分公司审批金额
    private BigDecimal detailMasterNum; // 建设公司审批工程量
    private BigDecimal detailMasterTaxPrice; // 建设公司审批单价
    private BigDecimal detailMasterTaxMny; // 建设公司审批金额
    /**
     * 序号
     */
    private String treeIndex;
    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 是否末级
     */
    private Boolean leafFlag;
    private String tid;
    private String tpid;
    private List<ITreeNodeB> children;

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }


    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    /**
     * 工作内容
     */
    private String detailWorkContent;

    /**
     * 计量规则
     */
    private String detailMeasurementRules;
    /**
     * 单位
     */
    private String detailUnit;
    /**
     * 备注
     */
    private String detailMemo;

    public String getDetailUnit() {
        return detailUnit;
    }
    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public String getDetailMemo() {
        return detailMemo;
    }
//    @Override
//    public Long getNodeID() {
//        return getId();
//    }
//
//    @Override
//    public Long getParentID() {
//        return parentId;
//    }
//
//    public List<ITreeNodeB> getChildren() {
//        if (children == null) {
//            children = new ArrayList<>();
//        }
//        return children;
//
//    }
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 零工登记id
     */
    public java.lang.Long getRegistrationId() {
        return registrationId;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    /**
     * 零工登记id
     */
    public void setRegistrationId(java.lang.Long registrationId) {
        this.registrationId = registrationId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public java.lang.Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public void setContractType(java.lang.Integer contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public java.lang.Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public void setSupplementFlag(java.lang.Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 清单名称
     */
    public java.lang.String getListName() {
        return listName;
    }

    /**
     * 清单名称
     */
    public void setListName(java.lang.String listName) {
        this.listName = listName;
    }
    /**
     * 清单id
     */
    public java.lang.Long getListId() {
        return listId;
    }

    /**
     * 清单id
     */
    public void setListId(java.lang.Long listId) {
        this.listId = listId;
    }
    /**
     * 清单来源 0- 选择，1-新增
     */
    public java.lang.Integer getListType() {
        return listType;
    }

    /**
     * 清单来源 0- 选择，1-新增
     */
    public void setListType(java.lang.Integer listType) {
        this.listType = listType;
    }
    /**
     * 清单来源id 合同id
     */
    public java.lang.Long getSourceId() {
        return sourceId;
    }

    /**
     * 清单来源id 合同id
     */
    public void setSourceId(java.lang.Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getWorkNum() {
        return workNum;
    }

    /**
     * 工程量
     */
    public void setWorkNum(java.math.BigDecimal workNum) {
        this.workNum = workNum;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public java.math.BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setTaxPrice(java.math.BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getListTaxRate() {
        return listTaxRate;
    }

    /**
     * 税率
     */
    public void setListTaxRate(java.math.BigDecimal listTaxRate) {
        this.listTaxRate = listTaxRate;
    }
    /**
     * 总额 自动计算 不支持修改(含税)
     */
    public java.math.BigDecimal getListTaxMny() {
        return listTaxMny;
    }

    /**
     * 总额 自动计算 不支持修改(含税)
     */
    public void setListTaxMny(java.math.BigDecimal listTaxMny) {
        this.listTaxMny = listTaxMny;
    }
    /**
     * 总额 自动计算 不支持修改
     */
    public java.math.BigDecimal getListMny() {
        return listMny;
    }

    /**
     * 总额 自动计算 不支持修改
     */
    public void setListMny(java.math.BigDecimal listMny) {
        this.listMny = listMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getListTax() {
        return listTax;
    }

    /**
     * 税额
     */
    public void setListTax(java.math.BigDecimal listTax) {
        this.listTax = listTax;
    }
    /**
     * 结束时间 大于等于开始日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 结束时间 大于等于开始日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 开始时间 小于等于结束日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 开始时间 小于等于结束日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }

    public BigDecimal getDetailSubNum() {
        return detailSubNum;
    }

    public void setDetailSubNum(BigDecimal detailSubNum) {
        this.detailSubNum = detailSubNum;
    }

    public BigDecimal getDetailSubTaxPrice() {
        return detailSubTaxPrice;
    }

    public void setDetailSubTaxPrice(BigDecimal detailSubTaxPrice) {
        this.detailSubTaxPrice = detailSubTaxPrice;
    }

    public BigDecimal getDetailSubTaxMny() {
        return detailSubTaxMny;
    }

    public void setDetailSubTaxMny(BigDecimal detailSubTaxMny) {
        this.detailSubTaxMny = detailSubTaxMny;
    }

    public BigDecimal getDetailProjectNum() {
        return detailProjectNum;
    }

    public void setDetailProjectNum(BigDecimal detailProjectNum) {
        this.detailProjectNum = detailProjectNum;
    }

    public BigDecimal getDetailProjectTaxPrice() {
        return detailProjectTaxPrice;
    }

    public void setDetailProjectTaxPrice(BigDecimal detailProjectTaxPrice) {
        this.detailProjectTaxPrice = detailProjectTaxPrice;
    }

    public BigDecimal getDetailProjectTaxMny() {
        return detailProjectTaxMny;
    }

    public void setDetailProjectTaxMny(BigDecimal detailProjectTaxMny) {
        this.detailProjectTaxMny = detailProjectTaxMny;
    }

    public BigDecimal getDetailBranchNum() {
        return detailBranchNum;
    }

    public void setDetailBranchNum(BigDecimal detailBranchNum) {
        this.detailBranchNum = detailBranchNum;
    }

    public BigDecimal getDetailBranchTaxPrice() {
        return detailBranchTaxPrice;
    }

    public void setDetailBranchTaxPrice(BigDecimal detailBranchTaxPrice) {
        this.detailBranchTaxPrice = detailBranchTaxPrice;
    }

    public BigDecimal getDetailBranchTaxMny() {
        return detailBranchTaxMny;
    }

    public void setDetailBranchTaxMny(BigDecimal detailBranchTaxMny) {
        this.detailBranchTaxMny = detailBranchTaxMny;
    }

    public BigDecimal getDetailMasterNum() {
        return detailMasterNum;
    }

    public void setDetailMasterNum(BigDecimal detailMasterNum) {
        this.detailMasterNum = detailMasterNum;
    }

    public BigDecimal getDetailMasterTaxPrice() {
        return detailMasterTaxPrice;
    }

    public void setDetailMasterTaxPrice(BigDecimal detailMasterTaxPrice) {
        this.detailMasterTaxPrice = detailMasterTaxPrice;
    }

    public BigDecimal getDetailMasterTaxMny() {
        return detailMasterTaxMny;
    }

    public void setDetailMasterTaxMny(BigDecimal detailMasterTaxMny) {
        this.detailMasterTaxMny = detailMasterTaxMny;
    }

    public List<ITreeNodeB> getChildren() {
        return children;
    }
}
