package com.ejianc.business.settle.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 结算子表-形象进度
 * 
 * @author generator
 * 
 */
public class SettleProgressVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long settleId; // 结算id
    private Long sourceId; // 来源id
    private String sourceBillCode; // 来源主单据编号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date sourceBillDate; // 来源单据编制时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date progressStartTime; // 计量开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date progressEndTime; // 计量截止时间
    private Long progressEmployeeId; // 编制人id
    private String progressEmployeeName; // 编制人name
    

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }
    public Date getProgressStartTime() {
        return progressStartTime;
    }

    public void setProgressStartTime(Date progressStartTime) {
        this.progressStartTime = progressStartTime;
    }
    public Date getProgressEndTime() {
        return progressEndTime;
    }

    public void setProgressEndTime(Date progressEndTime) {
        this.progressEndTime = progressEndTime;
    }
    public Long getProgressEmployeeId() {
        return progressEmployeeId;
    }

    public void setProgressEmployeeId(Long progressEmployeeId) {
        this.progressEmployeeId = progressEmployeeId;
    }
    public String getProgressEmployeeName() {
        return progressEmployeeName;
    }

    public void setProgressEmployeeName(String progressEmployeeName) {
        this.progressEmployeeName = progressEmployeeName;
    }
    
}
