package com.ejianc.business.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.material.vo.MaterialApplyDetailVO;

/**
 * 领料限额登记主实体
 * 
 * @author generator
 * 
 */
public class MaterialApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 合同编码
     */
    private String contractCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同类型:分包合同-0,专业合同-1
     */
    private Integer contractType;

    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 项目编号
     */
    private String projectCode;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 乙方项目经理Id（乙方负责人id）
     */
    private Long supplierProjectManagerId;

    /**
     * 乙方项目经理名称（乙方负责人名称）
     */
    private String supplierProjectManagerName;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办部门id
     */
    private Long departmentId;

    /**
     * 经办部门名称
     */
    private String departmentName;

    /**
     * 项目部id
     */
    private Long orgId;

    /**
     * 项目部编码
     */
    private String orgCode;

    /**
     * 项目部名称
     */
    private String orgName;

    /**
     * 项目部所属组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部所属组织编码
     */
    private String parentOrgCode;

    /**
     * 项目部所属组织名称
     */
    private String parentOrgName;

    /**
     * 合同类别Id
     */
    private Long contractCategoryId;

    /**
     * 合同类别名称
     */
    private String contractCategoryName;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 备注
     */
    private String memo;

    /**
     * 单据状态名称（不入库） ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private String billStateName;

    /**
     * 领料限额登记明细实体
     */
    private List<MaterialApplyDetailVO> materialApplyDetailList = new ArrayList<>();

    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }


    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }


    public Long getDepartmentId() {
        return departmentId;
    }


    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<MaterialApplyDetailVO> getMaterialApplyDetailList() {
        return materialApplyDetailList;
     }

     public void setMaterialApplyDetailList(List<MaterialApplyDetailVO> materialApplyDetailList) {
        this.materialApplyDetailList = materialApplyDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

}
