package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包总计划实体
 * 
 * @author generator
 * 
 */
public class PlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 总计划变更状态：未变更
     */
    public static final Integer PLAN_CHANGE_STATE_UNCHANGED = 0;

    /**
     * 总计划变更状态：变更中
     */
    public static final Integer PLAN_CHANGE_STATE_CHANGING = 1;

    /**
     * 总计划变更状态：已变更
     */
    public static final Integer PLAN_CHANGE_STATE_CHANGED = 2;

    /**
     * 总计划类型：专业总计划
     */
    public static final Integer PLAN_TYPE_PRO_SUB = 1;
    /**
     * 总计划类型：分包总计划
     */
    public static final Integer PLAN_TYPE_LABOR_SUB = 0;

    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private String billCode; // 计划编码
    private BigDecimal totalPlanTaxMny; // 总计划金额
    private BigDecimal totalPlanMny; // 总计划金额无税
    private String memo; // 备注
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Integer changeState; // 变更状态
    private Integer billState; // 单据状态
    private Long changeId; // 当前对应的变更计划Id
    private String createUserName; // 创建人名称
    private String modifyUserName; // 修改人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate; // 生效日期
    private Integer changeVersion; // 变更版本

    private Long employeeId;//经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办单位id
    private String departmentName; // 经办单位
    private Long parentOrgId; // 项目部上级组织id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer subType; // 分包类型 0-劳务分包 1-专业分包

    /**
     * 变更状态名称
     */
    private String changeStateName;

    /**
     * 单据状态名称
     */
    private String billStateName;
    
    private List<PlanDetailVO> planDetailList = new ArrayList<>(); // 分包总计划明细实体

    /**
     * 变更历史列表
     */
    private List<PlanChangeHisVO> planChangeHisList = new ArrayList<>();

    /**
     * 档案内码
     */
    private String docInnerCode;

    public String getDocInnerCode() {
        return docInnerCode;
    }

    public void setDocInnerCode(String docInnerCode) {
        this.docInnerCode = docInnerCode;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getTotalPlanTaxMny() {
        return totalPlanTaxMny;
    }

    public void setTotalPlanTaxMny(BigDecimal totalPlanTaxMny) {
        this.totalPlanTaxMny = totalPlanTaxMny;
    }

    public BigDecimal getTotalPlanMny() {
        return totalPlanMny;
    }

    public void setTotalPlanMny(BigDecimal totalPlanMny) {
        this.totalPlanMny = totalPlanMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }
    
     public List<PlanDetailVO> getPlanDetailList() {
        return planDetailList;
     }

     public void setPlanDetailList(List<PlanDetailVO> planDetailList) {
        this.planDetailList = planDetailList;
     }

    public List<PlanChangeHisVO> getPlanChangeHisList() {
        return planChangeHisList;
    }

    public void setPlanChangeHisList(List<PlanChangeHisVO> planChangeHisList) {
        this.planChangeHisList = planChangeHisList;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
