package com.ejianc.business.process.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.process.vo.SalaryDetailVO;
import com.ejianc.business.process.vo.SalaryExtraVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人工资单主实体
 * 
 * @author generator
 * 
 */
public class SalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Integer contractType; // 合同类型：劳务合同-0，专业合同-1
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private Long supplierId; // 供应商Id（乙方id）
    private String supplierName; // 供应商名称（乙方名称）
    private Long supplierProjectManagerId; // 乙方项目经理Id（乙方负责人id）
    private String supplierProjectManagerName; // 乙方项目经理名称（乙方负责人名称）
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date belongMonth; // 所属月份
    private BigDecimal sumSalaryMny; // 工资单总金额
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; //  经办人部门
    private BigDecimal sumWorkerSalaryMny; // 工人工资(实发工资汇总)
    private BigDecimal sumExtraMny; // 额外费用(额外费用汇总)
    private String memo; //  备注
    private BigDecimal sumMny;
    
    private List<SalaryDetailVO> salaryDetailList = new ArrayList<>(); // 工人工资单明细表
    private List<SalaryExtraVO> salaryExtraList = new ArrayList<>(); // 工人工资额外费用子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "proSubContract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }
    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }
    public Date getBelongMonth() {
        return belongMonth;
    }

    public void setBelongMonth(Date belongMonth) {
        this.belongMonth = belongMonth;
    }
    public BigDecimal getSumSalaryMny() {
        return sumSalaryMny;
    }

    public void setSumSalaryMny(BigDecimal sumSalaryMny) {
        this.sumSalaryMny = sumSalaryMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getSumWorkerSalaryMny() {
        return sumWorkerSalaryMny;
    }

    public void setSumWorkerSalaryMny(BigDecimal sumWorkerSalaryMny) {
        this.sumWorkerSalaryMny = sumWorkerSalaryMny;
    }

    public BigDecimal getSumExtraMny() {
        return sumExtraMny;
    }

    public void setSumExtraMny(BigDecimal sumExtraMny) {
        this.sumExtraMny = sumExtraMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<SalaryDetailVO> getSalaryDetailList() {
        return salaryDetailList;
     }

     public void setSalaryDetailList(List<SalaryDetailVO> salaryDetailList) {
        this.salaryDetailList = salaryDetailList;
     }
     public List<SalaryExtraVO> getSalaryExtraList() {
        return salaryExtraList;
     }

     public void setSalaryExtraList(List<SalaryExtraVO> salaryExtraList) {
        this.salaryExtraList = salaryExtraList;
     }

    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }


}
